/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.repository.sql.db.MetadataSchema;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.SqlStorageFacade$;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.TestAuthentication;
import com.xebialabs.xlrelease.TestCleanupException;
import com.xebialabs.xlrelease.actors.utils.ScalaSpringSupport;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.LiquibaseSupport;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.SqlTeamRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.upgrade.liquibase.BeforeUpgrade;
import java.io.Serializable;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import liquibase.Liquibase;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Profile(value={"integrationTest"})
@ScalaSignature(bytes="\u0006\u0001\r=a\u0001B\u001a5\u0001mB\u0001b\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\te\u0002\u0011\t\u0011)A\u0005g\"A1\u0010\u0001B\u0001B\u0003%A\u0010\u0003\u0006\u0002\u0002\u0001\u0011\t\u0011)A\u0005\u0003\u0007A!\"!\u0003\u0001\u0005\u0003\u0005\u000b\u0011BA\u0006\u0011)\t9\u0002\u0001B\u0001B\u0003%\u0011\u0011\u0004\u0005\u000b\u0003?\u0001!\u0011!Q\u0001\n\u0005\u0005\u0002BCA\u0014\u0001\t\u0005\t\u0015!\u0003\u0002*!Q\u0011q\u0006\u0001\u0003\u0002\u0003\u0006I!!\r\t\u0015\u0005]\u0002A!A!\u0002\u0013\tI\u0004\u0003\u0006\u0002f\u0001\u0011\t\u0011)A\u0005\u0003sAq!a\u001b\u0001\t\u0003\ti\u0007C\u0004\u0002\u0014\u0002!\t%!&\t\r5\u0003A\u0011IAW\u0011\u001d\tY\f\u0001C!\u0003{Cq!!4\u0001\t\u0003\ni\u000bC\u0004\u0002P\u0002!I!!5\t\u000f\u0005M\u0007\u0001\"\u0003\u0002R\"9\u0011Q\u001b\u0001\u0005\n\u0005]\u0007bBAp\u0001\u0011%\u0011q\u001b\u0005\u000b\u0003C\u0004\u0001R1A\u0005\u0002\u0005\r\b\"CAz\u0001\t\u0007I\u0011BA{\u0011!\ti\u0010\u0001Q\u0001\n\u0005]\bbBA\u0000\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005?\u0001A\u0011\u0002B\u0011\u0011\u001d\u0011I\u0003\u0001C!\u0003[CqAa\u000b\u0001\t\u0003\u0012i\u0003C\u0004\u00034\u0001!\tB!\u000e\t\u000f\t-\u0002\u0001\"\u0011\u0003:!9!1\n\u0001\u0005B\t5\u0003b\u0002B-\u0001\u0011\u0005\u0013Q\u0016\u0005\b\u00057\u0002A\u0011\u0002B/\u0011\u001d\u0011y\u0006\u0001C\u0005\u0005CBqA!$\u0001\t\u0013\u0011i\u0006C\u0004\u0003\u0010\u0002!IA!\u0018\t\u000f\tE\u0005\u0001\"\u0003\u0003\u0014\"9!q\u0013\u0001\u0005\n\te\u0005b\u0002BN\u0001\u0011%!\u0011\u0014\u0005\b\u0005;\u0003A\u0011\u0002BM\u0011\u001d\u0011y\n\u0001C\u0005\u0005;BqA!)\u0001\t\u0003\ti\u000bC\u0006\u00030\u0002\u0001\r\u00111A\u0005\u0002\tE\u0006b\u0003B]\u0001\u0001\u0007\t\u0019!C\u0001\u0005wC1B!1\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00034\"9!q\u001a\u0001\u0005\u0002\tE\u0007b\u0002Bj\u0001\u0011\u0005!Q[\u0004\b\u0005s$\u0004\u0012\u0001B~\r\u0019\u0019D\u0007#\u0001\u0003~\"9\u00111\u000e\u0019\u0005\u0002\r\u0015\u0001b\u0002B&a\u0011\u00051q\u0001\u0002\u0011'Fd7\u000b^8sC\u001e,g)Y2bI\u0016T!!\u000e\u001c\u0002\u0013ad'/\u001a7fCN,'BA\u001c9\u0003%AXMY5bY\u0006\u00147OC\u0001:\u0003\r\u0019w.\\\u0002\u0001'!\u0001A\b\u0012%Q'f\u000b\u0007CA\u001fC\u001b\u0005q$BA A\u0003\u0011a\u0017M\\4\u000b\u0003\u0005\u000bAA[1wC&\u00111I\u0010\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u00153U\"\u0001\u001b\n\u0005\u001d#$!D*u_J\fw-\u001a$bG\u0006$W\r\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006IA.[9vS\n\f7/\u001a\u0006\u0003\u001bR\nq!\u001e9he\u0006$W-\u0003\u0002P\u0015\ni!)\u001a4pe\u0016,\u0006o\u001a:bI\u0016\u0004\"!R)\n\u0005I#$A\u0005+fgR\fU\u000f\u001e5f]RL7-\u0019;j_:\u0004\"\u0001V,\u000e\u0003US!A\u0016\u001b\u0002\u0005\u0011\u0014\u0017B\u0001-V\u0005Aa\u0015.];jE\u0006\u001cXmU;qa>\u0014H\u000f\u0005\u0002[?6\t1L\u0003\u0002];\u0006)Q\u000f^5mg*\u0011a\fN\u0001\u0007C\u000e$xN]:\n\u0005\u0001\\&AE*dC2\f7\u000b\u001d:j]\u001e\u001cV\u000f\u001d9peR\u0004\"AY5\u000e\u0003\rT!\u0001Z3\u0002\u000f\r|g\u000e^3yi*\u0011amZ\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001.A\u0002pe\u001eL!A[2\u0003/\u0005\u0003\b\u000f\\5dCRLwN\\\"p]R,\u0007\u0010^!xCJ,\u0017!\u00044pY\u0012,'oU3sm&\u001cW\r\u0005\u0002na6\taN\u0003\u0002pi\u000591/\u001a:wS\u000e,\u0017BA9o\u000551u\u000e\u001c3feN+'O^5dK\u0006qA/Z1n%\u0016\u0004xn]5u_JL\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003qR\n!B]3q_NLGo\u001c:z\u0013\tQXOA\tTc2$V-Y7SKB|7/\u001b;pef\f\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z!\tih0D\u0001x\u0013\tyxOA\tSK2,\u0017m]3SKB|7/\u001b;pef\fAC]3mK\u0006\u001cXmU3be\u000eD7+\u001a:wS\u000e,\u0007cA7\u0002\u0006%\u0019\u0011q\u00018\u0003)I+G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2f\u0003U!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\u0004B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#)\u0018a\u00039feNL7\u000f^3oG\u0016LA!!\u0006\u0002\u0010\t)B)\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017aF2p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z!\ri\u00181D\u0005\u0004\u0003;9(aF\"p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z\u0003]\u0019\u0017\r\\3oI\u0006\u0014XI\u001c;ssJ+\u0007o\\:ji>\u0014\u0018\u0010E\u0002~\u0003GI1!!\nx\u0005]\u0019\u0015\r\\3oI\u0006\u0014XI\u001c;ssJ+\u0007o\\:ji>\u0014\u00180\u0001\tbe\u000eD\u0017N^5oON+'O^5dKB\u0019Q.a\u000b\n\u0007\u00055bN\u0001\tBe\u000eD\u0017N^5oON+'O^5dK\u0006\tBO]5hO\u0016\u0014(+\u001a9pg&$xN]=\u0011\u0007u\f\u0019$C\u0002\u00026]\u0014\u0011\u0003\u0016:jO\u001e,'OU3q_NLGo\u001c:z\u00031QGMY2UK6\u0004H.\u0019;f!\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\nAaY8sK*\u0019\u00111I3\u0002\t)$'mY\u0005\u0005\u0003\u000f\niD\u0001\u0007KI\n\u001cG+Z7qY\u0006$X\rK\u0004\u000b\u0003\u0017\ny&!\u0019\u0011\t\u00055\u00131L\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005U\u0013qK\u0001\bM\u0006\u001cGo\u001c:z\u0015\r\tI&Z\u0001\u0006E\u0016\fgn]\u0005\u0005\u0003;\nyEA\u0005Rk\u0006d\u0017NZ5fe\u0006)a/\u00197vK\u0006\u0012\u00111M\u0001\u001aq2\u0014(+\u001a9pg&$xN]=KI\n\u001cG+Z7qY\u0006$X-A\u000bsKB|'\u000f^5oO*#'m\u0019+f[Bd\u0017\r^3)\u000f-\tY%a\u0018\u0002j\u0005\u0012\u0011QM\u0001\u0007y%t\u0017\u000e\u001e \u00151\u0005=\u0014\u0011OA:\u0003k\n9(!\u001f\u0002|\u0005u\u0014qPAA\u0003\u0007\u000b9\t\u0005\u0002F\u0001!)1\u000e\u0004a\u0001Y\")!\u000f\u0004a\u0001g\")1\u0010\u0004a\u0001y\"9\u0011\u0011\u0001\u0007A\u0002\u0005\r\u0001bBA\u0005\u0019\u0001\u0007\u00111\u0002\u0005\b\u0003/a\u0001\u0019AA\r\u0011\u001d\ty\u0002\u0004a\u0001\u0003CAq!a\n\r\u0001\u0004\tI\u0003C\u0004\u000201\u0001\r!!\r\t\u000f\u0005]B\u00021\u0001\u0002:!B\u00111QA&\u0003?\n\t\u0007C\u0004\u0002f1\u0001\r!!\u000f)\u0011\u0005\u001d\u00151JA0\u0003SB3\u0001DAG!\u0011\ti%a$\n\t\u0005E\u0015q\n\u0002\n\u0003V$xn^5sK\u0012\f\u0001\u0003\u001f7SK2,\u0017m]3WKJ\u001c\u0018n\u001c8\u0015\u0005\u0005]\u0005\u0003BAM\u0003Sk!!a'\u000b\u00075\u000biJ\u0003\u0003\u0002 \u0006\u0005\u0016aA1qS*!\u00111UAS\u0003\u0019\u0019XM\u001d<fe*\u0019\u0011q\u0015\u001c\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!a+\u0002\u001c\n9a+\u001a:tS>tGCAAX!\u0011\t\t,a.\u000e\u0005\u0005M&BAA[\u0003\u0015\u00198-\u00197b\u0013\u0011\tI,a-\u0003\tUs\u0017\u000e^\u0001\u0019e\u0016\u0004xn]5u_JLh+\u001a:tS>t7+\u001a:wS\u000e,WCAA`!\u0011\t\t-!3\u000e\u0005\u0005\r'bA'\u0002F*\u0019\u0011q\u0019\u001c\u0002\u0015ad\u0007\u000f\\1uM>\u0014X.\u0003\u0003\u0002L\u0006\r'\u0001\u0007*fa>\u001c\u0018\u000e^8ssZ+'o]5p]N+'O^5dK\u0006IAm\\+qOJ\fG-Z\u0001\u0017o&\u0004XmT;u\u0003J\u001c\u0007.\u001b<f\t\u0006$\u0018MY1tKV\u0011\u0011qV\u0001\u0010o&\u0004XmT;u\t\u0006$\u0018MY1tK\u0006\u0011\u0012n\u001d#c\u00072,\u0017M\\;q\u000b:\f'\r\\3e+\t\tI\u000e\u0005\u0003\u00022\u0006m\u0017\u0002BAo\u0003g\u0013qAQ8pY\u0016\fg.\u0001\u0010jg&sG/Z4sCRLwN\u001c+fgR\u0004&o\u001c4jY\u0016\f5\r^5wK\u0006QA-\u0019;b'>,(oY3\u0016\u0005\u0005\u0015\b\u0003BAt\u0003_l!!!;\u000b\u0007Y\fYO\u0003\u0002\u0002n\u0006)!.\u0019<bq&!\u0011\u0011_Au\u0005)!\u0015\r^1T_V\u00148-Z\u0001\u0003\u001d2+\"!a>\u0011\u0007u\nI0C\u0002\u0002|z\u0012aa\u0015;sS:<\u0017a\u0001(MA\u0005YA/\u00192mK\u0016C\u0018n\u001d;t)\u0011\u0011\u0019Aa\u0002\u0015\t\u0005e'Q\u0001\u0005\b\u0003oA\u00029AA\u001d\u0011\u001d\u0011I\u0001\u0007a\u0001\u0005\u0017\t\u0011\u0002^1cY\u0016t\u0015-\\3\u0011\t\t5!1\u0004\b\u0005\u0005\u001f\u00119\u0002\u0005\u0003\u0003\u0012\u0005MVB\u0001B\n\u0015\r\u0011)BO\u0001\u0007yI|w\u000e\u001e \n\t\te\u00111W\u0001\u0007!J,G-\u001a4\n\t\u0005m(Q\u0004\u0006\u0005\u00053\t\u0019,\u0001\neK2,G/\u001a+bE2,7i\u001c8uK:$H\u0003\u0002B\u0012\u0005O!B!a,\u0003&!9\u0011qG\rA\u0004\u0005e\u0002b\u0002B\u00053\u0001\u0007!1B\u0001\bG2,\u0017M\\;q\u0003\u0019!W\r\\3uKR!\u0011\u0011\u001cB\u0018\u0011\u001d\u0011\td\u0007a\u0001\u0005\u0017\t!!\u001b3\u0002\u001b\u0011,G.\u001a;f%\u0016dW-Y:f)\u0011\tyKa\u000e\t\u000f\tEB\u00041\u0001\u0003\fQ!\u0011\u0011\u001cB\u001e\u0011\u001d\u0011i$\ba\u0001\u0005\u007f\tA\u0001^3b[B!!\u0011\tB$\u001b\t\u0011\u0019EC\u0002\u0003FQ\na\u0001Z8nC&t\u0017\u0002\u0002B%\u0005\u0007\u0012A\u0001V3b[\u0006\tB-\u001a7fi\u00164%o\\7Be\u000eD\u0017N^3\u0015\t\t=#Q\u000b\t\u0005\u0003c\u0013\t&\u0003\u0003\u0003T\u0005M&aA%oi\"9!q\u000b\u0010A\u0002\t-\u0011!\u0003:fY\u0016\f7/Z%e\u0003U1XM]5gsJ+\u0007o\\:ji>\u0014\u0018p\u00117fC:\fAbY8v]R4u\u000e\u001c3feN$\"Aa\u0014\u00025Q,7\u000f\u001e#jI:{Go\u00117fC:\fe\r^3s\u0013R\u001cX\r\u001c4\u0015\u0011\t\r$\u0011\u000eB7\u0005\u0013\u00032!\u0012B3\u0013\r\u00119\u0007\u000e\u0002\u0015)\u0016\u001cHo\u00117fC:,\b/\u0012=dKB$\u0018n\u001c8\t\u000f\t-\u0014\u00051\u0001\u0003\f\u0005AA/Z:u\u001d\u0006lW\rC\u0004\u0003p\u0005\u0002\rA!\u001d\u0002\r\u0005\u001cG/\u001b<f!\u0019\u0011\u0019H! \u0003\u0004:!!Q\u000fB=\u001d\u0011\u0011\tBa\u001e\n\u0005\u0005U\u0016\u0002\u0002B>\u0003g\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u0000\t\u0005%aA*fc*!!1PAZ!!\t\tL!\"\u0003\f\t-\u0011\u0002\u0002BD\u0003g\u0013a\u0001V;qY\u0016\u0014\u0004b\u0002BFC\u0001\u0007!\u0011O\u0001\tCJ\u001c\u0007.\u001b<fI\u0006i1m\\;oiJ+G.Z1tKN\fQbY8v]R$&/[4hKJ\u001c\u0018aG4fiJ+W.Y5oS:<GK]5hO\u0016\u00148\u000fR3uC&d7\u000f\u0006\u0002\u0003\u0016B1!1\u000fB?\u0005\u0017\t\u0011dZ3u%\u0016l\u0017-\u001b8j]\u001e4u\u000e\u001c3fe\u0012+G/Y5mgR\u0011!\u0011O\u0001\u001cO\u0016$(+Z7bS:Lgn\u001a*fY\u0016\f7/Z:EKR\f\u0017\u000e\\:\u0002G\u001d,GOU3nC&t\u0017N\\4Be\u000eD\u0017N^3e%\u0016dW-Y:fg\u0012+G/Y5mg\u0006)2m\\;oi\u0006\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\u0018!C2mK\u0006t\u0007\f\u001c#cQ\rI#Q\u0015\t\u0005\u0005O\u0013Y+\u0004\u0002\u0003**!\u0011\u0011KAv\u0013\u0011\u0011iK!+\u0003\u0015A\u0013X\rR3tiJ|\u00170\u0001\nbaBd\u0017nY1uS>t7i\u001c8uKb$XC\u0001BZ!\r\u0011'QW\u0005\u0004\u0005o\u001b'AE!qa2L7-\u0019;j_:\u001cuN\u001c;fqR\fa#\u00199qY&\u001c\u0017\r^5p]\u000e{g\u000e^3yi~#S-\u001d\u000b\u0005\u0003_\u0013i\fC\u0005\u0003@.\n\t\u00111\u0001\u00034\u0006\u0019\u0001\u0010J\u0019\u0002'\u0005\u0004\b\u000f\\5dCRLwN\\\"p]R,\u0007\u0010\u001e\u0011)\u00071\u0012)\r\u0005\u0003\u0003H\n-WB\u0001Be\u0015\u0011\tI&a-\n\t\t5'\u0011\u001a\u0002\r\u0005\u0016\fg\u000e\u0015:pa\u0016\u0014H/_\u0001\u0016O\u0016$\u0018\t\u001d9mS\u000e\fG/[8o\u0007>tG/\u001a=u)\t\u0011\u0019,A\u000btKR\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0015\t\u0005=&q\u001b\u0005\n\u0005\u007fs\u0013\u0011!a\u0001\u0005gCs\u0001\u0001Bn\u0003?\u0012)\u000f\u0005\u0003\u0003^\n\u0005XB\u0001Bp\u0015\r\t\tfY\u0005\u0005\u0005G\u0014yNA\u0004Qe>4\u0017\u000e\\3-\u0005\t\u001d\u0018E\u0001Bu\u0003=Ig\u000e^3he\u0006$\u0018n\u001c8UKN$\bf\u0001\u0001\u0003nB!!q\u001eB{\u001b\t\u0011\tPC\u0002\u0003t\u0016\f!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u00119P!=\u0003\u0013\r{W\u000e]8oK:$\u0018\u0001E*rYN#xN]1hK\u001a\u000b7-\u00193f!\t)\u0005gE\u00021\u0005\u007f\u0004B!!-\u0004\u0002%!11AAZ\u0005\u0019\te.\u001f*fMR\u0011!1 \u000b\u0005\u0007\u0013\u0019i\u0001\u0006\u0003\u0003P\r-\u0001bBA\u001ce\u0001\u0007\u0011\u0011\b\u0005\b\u0005/\u0012\u0004\u0019\u0001B\u0006\u0001")
public class SqlStorageFacade
implements StorageFacade,
BeforeUpgrade,
TestAuthentication,
LiquibaseSupport,
ScalaSpringSupport,
ApplicationContextAware {
    private DataSource dataSource;
    private final FolderService folderService;
    private final SqlTeamRepository teamRepository;
    private final ReleaseRepository releaseRepository;
    private final DependencyPersistence dependencyPersistence;
    private final ConfigurationRepository configurationRepository;
    private final CalendarEntryRepository calendarEntryRepository;
    private final ArchivingService archivingService;
    private final TriggerRepository triggerRepository;
    @Qualifier(value="xlrRepositoryJdbcTemplate")
    private final JdbcTemplate jdbcTemplate;
    @Qualifier(value="reportingJdbcTemplate")
    private final JdbcTemplate reportingJdbcTemplate;
    private final String NL;
    private ApplicationContext applicationContext;
    private volatile boolean bitmap$0;

    public <T> T springBean(ClassTag<T> evidence$1) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, evidence$1);
    }

    public <T> T springBean(String name, ClassTag<T> evidence$2) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, (String)name, evidence$2);
    }

    public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
        return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
    }

    public <T> T withAuthentication(Authentication auth, Function0<T> t) {
        return (T)TestAuthentication.withAuthentication$((TestAuthentication)this, (Authentication)auth, t);
    }

    @Override
    public Logger logger() {
        return StorageFacade.super.logger();
    }

    public Version xlReleaseVersion() {
        return Version.valueOf((String)"xl-release", (String)"0.0.0");
    }

    public void upgrade() {
        this.doUpgrade();
    }

    public RepositoryVersionService repositoryVersionService() {
        return null;
    }

    public void doUpgrade() {
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    private void wipeOutArchiveDatabase() {
        DataSource reportingDataSource = (DataSource)this.springBean("reportingDataSource", ClassTag$.MODULE$.apply(DataSource.class));
        LiquibaseSupport reporting = new LiquibaseSupport(null, reportingDataSource){
            private final DataSource reportingDataSource$1;

            public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
                return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
            }

            public DataSource dataSource() {
                return this.reportingDataSource$1;
            }
            {
                this.reportingDataSource$1 = reportingDataSource$1;
                LiquibaseSupport.$init$((LiquibaseSupport)this);
            }
        };
        reporting.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable & scala.Serializable)liquibase -> {
            SqlStorageFacade.$anonfun$wipeOutArchiveDatabase$1(this, liquibase);
            return BoxedUnit.UNIT;
        });
    }

    private void wipeOutDatabase() {
        block0: {
            if (!this.isDbCleanupEnabled() || !this.isIntegrationTestProfileActive()) break block0;
            this.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable & scala.Serializable)liquibase -> {
                SqlStorageFacade.$anonfun$wipeOutDatabase$1(this, liquibase);
                return BoxedUnit.UNIT;
            });
        }
    }

    private boolean isDbCleanupEnabled() {
        return !System.getProperties().contains("nodbcleanup");
    }

    private boolean isIntegrationTestProfileActive() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.applicationContext().getEnvironment().getActiveProfiles())).contains((Object)"integrationTest");
    }

    private DataSource dataSource$lzycompute() {
        SqlStorageFacade sqlStorageFacade = this;
        synchronized (sqlStorageFacade) {
            if (!this.bitmap$0) {
                this.dataSource = (DataSource)this.springBean("xlrRepositoryDataSource", ClassTag$.MODULE$.Nothing());
                this.bitmap$0 = true;
            }
        }
        return this.dataSource;
    }

    public DataSource dataSource() {
        return !this.bitmap$0 ? this.dataSource$lzycompute() : this.dataSource;
    }

    private String NL() {
        return this.NL;
    }

    public boolean tableExists(String tableName, JdbcTemplate jdbcTemplate) {
        boolean bl;
        try {
            jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT count(*) FROM ").append(tableName).toString(), Long.TYPE);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void deleteTableContent(String tableName, JdbcTemplate jdbcTemplate) {
        block0: {
            if (!this.tableExists(tableName, jdbcTemplate)) break block0;
            this.logger().info(new StringBuilder(9).append("DELETING ").append(tableName).toString());
            jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(tableName).toString());
        }
    }

    @Override
    public void cleanup() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.DEPENDENCIES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASE_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.COMMENTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASKS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_ACTIVITY_LOGS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES_EXT$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISK_ASSESSMENTS", sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISKS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGER_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.ARTIFACTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        if (this.tableExists(Schema.PATHS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(31).append("DELETE FROM ").append(Schema.PATHS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).append(" OR ").append(Schema.PATHS$.MODULE$.DESCENDANT_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        if (this.tableExists(Schema.FOLDERS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(15).append("UPDATE ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" SET ").append(Schema.FOLDERS$.MODULE$.SECURITY_UID()).append(" = ").append(FolderRow.Root$.MODULE$.uid()).toString());
            this.jdbcTemplate.execute(new StringBuilder(23).append("DELETE FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        this.deleteTableContent(MetadataSchema.METADATA$.MODULE$.TABLE(), sqlJdbcTemplate);
        if (this.tableExists(Schema.USER_PROFILE$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(30).append("DELETE FROM ").append(Schema.USER_PROFILE$.MODULE$.TABLE()).append(" WHERE ").append(Schema.USER_PROFILE$.MODULE$.USERNAME()).append(" <> 'admin'").toString());
        }
        JdbcTemplate sqlJdbcTemplate2 = this.reportingJdbcTemplate;
        this.deleteTableContent(Schema.Archive$.ITSM_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.DEPLOYMENT_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.CODE_COMPLIANCE_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_TASKS_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_PHASES_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME(), sqlJdbcTemplate2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean delete(String id) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.logger().trace(new StringBuilder(12).append("Deleting id ").append(id).toString());
            if (Ids.isReleaseId((String)id)) {
                this.deleteRelease(id);
            } else if (Ids.isDependencyId((String)id)) {
                $this.dependencyPersistence.deleteDependency(id);
            } else if (!Ids.isPlanItemId((String)id)) {
                if (Ids.isFolderId((String)id)) {
                    if ($this.folderService.exists(id)) {
                        $this.folderService.delete(id);
                    }
                } else if (Ids.isCustomConfigurationId((String)id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isCalendarId((String)id)) {
                    $this.calendarEntryRepository.delete(id);
                } else if (Ids.isConfigurationId((String)id) && $this.configurationRepository.exists(id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isTeamId((String)id)) {
                    $this.teamRepository.delete(id);
                } else if (Ids.isVariableId((String)id)) {
                    this.logger().warn(new StringBuilder(63).append("Variable '").append(id).append("' will be deleted once the parent release is deleted.").toString());
                } else if (!id.endsWith("PythonScript") && !id.endsWith("/valueProvider")) {
                    if (Ids.isTriggerId((String)id)) {
                        $this.triggerRepository.delete(id);
                    } else if (Ids.isInRelease((String)id)) {
                        this.logger().warn(new StringBuilder(69).append("Id '").append(id).append("' will be deleted once the parent release or template is deleted.").toString());
                    } else {
                        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Delete of CI with id `%s` is not supported")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                    }
                }
            }
            return true;
        });
        if (try_ instanceof Success) {
            this.logger().warn(new StringBuilder(8).append("Deleted ").append(id).toString());
            return true;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NotFoundException) {
                this.logger().error(new StringBuilder(51).append("Unable to delete CI with Id: `").append(id).append("` as it was not found").toString());
                return true;
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable e = failure.exception();
        this.logger().error(new StringBuilder(31).append("Unable to delete CI with Id: `").append(id).append("`").toString(), e);
        return false;
    }

    public void deleteRelease(String id) {
        block5: {
            this.logger().info("Deleting release {}", new Object[]{id});
            boolean found = false;
            if (this.releaseRepository.exists(id)) {
                this.logger().info("Release {} found in repository", new Object[]{id});
                try {
                    this.teamRepository.deleteTeamsFromPlatform(id);
                }
                catch (NotFoundException e) {
                    this.logger().warn(new StringBuilder(26).append("Could not delete teams of ").append(id).toString(), (Throwable)e);
                }
                this.releaseRepository.delete(id);
                found = true;
            }
            if (this.archivingService.exists(id)) {
                this.logger().info("Release {} found in archive", new Object[]{id});
                this.deleteFromArchive(id);
                found = true;
            }
            if (this.archivingService.existsPreArchived(id)) {
                this.logger().info("Release {} found as pre-archived", new Object[]{id});
                this.deleteFromArchive(id);
                found = true;
            }
            if (found) break block5;
            this.logger().error("Release {} not found neither in repository nor in archive (including pre-archived releases)", new Object[]{id});
        }
    }

    @Override
    public boolean delete(Team team) {
        boolean bl;
        this.logger().trace(new StringBuilder(14).append("Deleting team ").append(team.getId()).toString());
        if (!Ids.isInRelease((String)team.getId()) || this.releaseRepository.exists(Ids.releaseIdFrom((String)team.getId()))) {
            this.teamRepository.delete(team.getId());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int deleteFromArchive(String releaseId) {
        return SqlStorageFacade$.MODULE$.deleteFromArchive(releaseId, this.reportingJdbcTemplate);
    }

    @Override
    public void verifyRepositoryClean() {
        String testName;
        String string = testName = MDC.get((String)"testName") != null ? new StringBuilder(2).append(MDC.get((String)"testName")).append(": ").toString() : "";
        if (this.countReleases() > 0 || this.countArchivedReleases() > 0) {
            throw this.testDidNotCleanAfterItself(testName, this.getRemainingReleasesDetails(), this.getRemainingArchivedReleasesDetails());
        }
        int triggerCount = this.countTriggers();
        if (triggerCount > 0) {
            throw new TestCleanupException(new StringBuilder(38).append(testName).append("Found ").append(triggerCount).append(" remaining triggers in database:").append(this.NL()).append(this.getRemainingTriggersDetails().mkString(this.NL())).toString());
        }
        if (this.countFolders() > 1) {
            Seq folders = (Seq)this.getRemainingFolderDetails().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String id = (String)A1._1();
                        String path = (String)A1._2();
                        object = new StringBuilder(4).append(id).append(" -> ").append(path).toString();
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, String> x1) {
                    Tuple2<String, String> tuple2 = x1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }, Seq$.MODULE$.canBuildFrom());
            throw new TestCleanupException(new StringBuilder(28).append(testName).append("There are leftover folders: ").append(folders).toString());
        }
    }

    private int countFolders() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(") FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).toString(), (rs, x$1) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private TestCleanupException testDidNotCleanAfterItself(String testName, Seq<Tuple2<String, String>> active, Seq<Tuple2<String, String>> archived) {
        int numActive = active.size();
        int numArchived = archived.size();
        int numTotal = numActive + numArchived;
        return new TestCleanupException(new StringBuilder(62).append(testName).append("Found ").append(numTotal).append(" remaining releases (").append(numActive).append(" from database and ").append(numArchived).append(" from archive):\n").append(SqlStorageFacade.all$1(active, archived)).toString());
    }

    private int countReleases() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.RELEASES$.MODULE$.CI_UID()).append(") FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$2) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countTriggers() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.TRIGGERS$.MODULE$.CI_UID()).append(") FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$3) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<String> getRemainingTriggersDetails() {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE()).append(", ").append(Schema.TRIGGERS$.MODULE$.ID()).append(" FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$4) -> new StringBuilder(19).append("Trigger: ").append(rs.getString(1)).append(" with id: ").append(rs.getString(2)).toString())).asScala();
    }

    private Seq<Tuple2<String, String>> getRemainingFolderDetails() {
        return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append(", ").append(Schema.FOLDERS$.MODULE$.FOLDER_PATH()).append(" FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).toString(), (rs, x$5) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala()).toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingReleasesDetails() {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.RELEASES$.MODULE$.RELEASE_ID()).append(", ").append(Schema.RELEASES$.MODULE$.RELEASE_TITLE()).append(" FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$6) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala();
    }

    private Seq<Tuple2<String, String>> getRemainingArchivedReleasesDetails() {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.reportingJdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(", ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TITLE_COLUMN()).append(" FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$7) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala();
    }

    private int countArchivedReleases() {
        return BoxesRunTime.unboxToInt((Object)this.reportingJdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(") FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$8) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    @PreDestroy
    public void cleanXlDb() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent("XL_VERSION", sqlJdbcTemplate);
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    public ApplicationContext applicationContext() {
        return this.applicationContext;
    }

    public void applicationContext_$eq(ApplicationContext x$1) {
        this.applicationContext = x$1;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext();
    }

    public void setApplicationContext(ApplicationContext x$1) {
        this.applicationContext_$eq(x$1);
    }

    public static final /* synthetic */ void $anonfun$wipeOutArchiveDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out reporting database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$wipeOutDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out repository database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    private static final String showEntry$1(String tag, Tuple2 entry) {
        Tuple2 tuple2 = entry;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String id = (String)tuple2._1();
        String title = (String)tuple2._2();
        String string = new StringBuilder(9).append(id).append(" -> '").append(title).append("' (").append(tag).append(")").toString();
        return string;
    }

    private static final String all$1(Seq active$1, Seq archived$1) {
        return ((TraversableOnce)((TraversableLike)active$1.map((Function1 & Serializable & scala.Serializable)entry -> SqlStorageFacade.showEntry$1("active", entry), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)archived$1.map((Function1 & Serializable & scala.Serializable)entry -> SqlStorageFacade.showEntry$1("archive", entry), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).mkString("", "\n * ", "\n");
    }

    @Autowired
    public SqlStorageFacade(FolderService folderService, SqlTeamRepository teamRepository, ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, DependencyPersistence dependencyPersistence, ConfigurationRepository configurationRepository, CalendarEntryRepository calendarEntryRepository, ArchivingService archivingService, TriggerRepository triggerRepository, @Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="reportingJdbcTemplate") JdbcTemplate reportingJdbcTemplate) {
        this.folderService = folderService;
        this.teamRepository = teamRepository;
        this.releaseRepository = releaseRepository;
        this.dependencyPersistence = dependencyPersistence;
        this.configurationRepository = configurationRepository;
        this.calendarEntryRepository = calendarEntryRepository;
        this.archivingService = archivingService;
        this.triggerRepository = triggerRepository;
        this.jdbcTemplate = jdbcTemplate;
        this.reportingJdbcTemplate = reportingJdbcTemplate;
        BeforeUpgrade.$init$((BeforeUpgrade)this);
        TestAuthentication.$init$((TestAuthentication)this);
        LiquibaseSupport.$init$((LiquibaseSupport)this);
        ScalaSpringSupport.$init$((ScalaSpringSupport)this);
        this.NL = System.lineSeparator();
    }
}

