/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plumbing.id.DomainIdDeserializer;
import com.xebialabs.deployit.plumbing.id.DomainIdSerializer;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurity;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.views.TaskFullView;
import java.util.List;
import java.util.Map;

public class ReleaseTasks {
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String id;
    private String title;
    private ReleaseStatus status;
    private List<TaskFullView> tasks = Lists.newArrayList();
    private Map<String, String> variables = Maps.newHashMap();
    private EffectiveSecurity security;

    public ReleaseTasks() {
    }

    public ReleaseTasks(Release release, List<TaskFullView> tasks) {
        this.title = release.getTitle();
        this.id = release.getId();
        this.tasks = tasks;
        this.status = release.getStatus();
        this.variables = VariableHelper.getUsedStringVariables((Release)release);
        this.security = (EffectiveSecurity)release.get$metadata().get(EffectiveSecurityDecorator.EFFECTIVE_SECURITY());
    }

    public String getTitle() {
        return this.title;
    }

    public String getId() {
        return this.id;
    }

    public List<TaskFullView> getTasks() {
        return this.tasks;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public EffectiveSecurity getSecurity() {
        return this.security;
    }

    public ReleaseStatus getStatus() {
        return this.status;
    }
}

