/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.xlrelease.api.v1.forms.UserAccount;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.validators.UserAccountValidator;
import com.xebialabs.xlrelease.repository.CustomPersistentTokenRepository;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.service.Users;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/profile")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class ProfileResource {
    private UserProfileService userProfileService;
    private UserService userService;
    private Users users;
    private CustomPersistentTokenRepository customPersistentTokenRepository;
    private UserAccountValidator userAccountValidator;

    @Autowired
    public ProfileResource(UserProfileService userProfileService, UserService userService, Users users, CustomPersistentTokenRepository customPersistentTokenRepository, UserAccountValidator userAccountValidator) {
        this.userProfileService = userProfileService;
        this.userService = userService;
        this.users = users;
        this.customPersistentTokenRepository = customPersistentTokenRepository;
        this.userAccountValidator = userAccountValidator;
    }

    @GET
    public UserAccount getProfile() {
        String authenticatedUsername = Permissions.getAuthenticatedUserName();
        UserProfile userProfile = this.userProfileService.findByUsername(authenticatedUsername);
        return new UserAccount(userProfile.getName(), userProfile, this.users.userExistsInRepository(authenticatedUsername));
    }

    @PUT
    public UserAccount saveProfile(UserAccount account) {
        String authenticatedUsername = Permissions.getAuthenticatedUserName();
        UserProfile profile = this.userProfileService.findByUsername(authenticatedUsername);
        profile.setEmail(account.getEmail());
        profile.setFullName(account.getFullName());
        profile.setDateFormat(account.getDateFormat());
        profile.setTimeFormat(account.getTimeFormat());
        profile.setFirstDayOfWeek(account.getFirstDayOfWeek());
        this.userProfileService.updateProfile(profile);
        if (account.hasPassword() && this.users.userExistsInRepository(authenticatedUsername)) {
            Preconditions.checkArgument((boolean)Strings.isNotBlank((String)account.getPreviousPassword()), (Object)"Previous password must be provided when changing the password.");
            this.userAccountValidator.checkPassword(account.getPassword());
            try {
                this.userService.modifyPassword(authenticatedUsername, account.getPassword(), account.getPreviousPassword());
                this.customPersistentTokenRepository.removeUserTokens(authenticatedUsername);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidPreviousPasswordException(e);
            }
        }
        return new UserAccount(profile.getName(), profile, this.users.userExistsInRepository(authenticatedUsername));
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class InvalidPreviousPasswordException
    extends DeployitException {
        public InvalidPreviousPasswordException(Throwable cause) {
            super(cause);
        }
    }
}

