/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.configuration;

import com.xebialabs.xlrelease.config.XlrConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.stereotype.Component;

@Component
public class CsrfFilterPostProcessor
implements BeanPostProcessor {
    private XlrConfig xlrConfig;

    @Autowired
    public CsrfFilterPostProcessor(XlrConfig xlrConfig) {
        this.xlrConfig = xlrConfig;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!this.xlrConfig.server_http_csrf_enabled() && bean instanceof DefaultSecurityFilterChain) {
            ((DefaultSecurityFilterChain)bean).getFilters().removeIf(f -> f instanceof CsrfFilter);
        }
        return bean;
    }
}

