/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.config;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.configuration.ArchivingSettings;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ArchivingSettingsManager {
    private static final Logger logger = LoggerFactory.getLogger(ArchivingSettingsManager.class);
    private ConfigurationRepository configurationRepository;
    private Boolean preArchivingEnabled;
    private Boolean enabled;
    private Integer searchPageSize;
    private Integer maxSecondsPerRun;
    private Integer sleepSecondsBetweenReleases;
    private Consumer<Boolean> preArchivingEnabledChangedCallback;

    @Autowired
    public ArchivingSettingsManager(ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        ArchivingSettings defaults = (ArchivingSettings)Type.valueOf(ArchivingSettings.class).getDescriptor().newInstance("Configuration/settings/ArchivingSettings");
        this.preArchivingEnabled = defaults.getPreArchivingEnabled();
        this.enabled = defaults.getEnabled();
        this.searchPageSize = defaults.getSearchPageSize();
        this.maxSecondsPerRun = defaults.getMaxSecondsPerRun();
        this.sleepSecondsBetweenReleases = defaults.getSleepSecondsBetweenReleases();
    }

    public void subscribeToPreArchivingEnabledChanges(Consumer<Boolean> callback) {
        this.preArchivingEnabledChangedCallback = callback;
    }

    public boolean getPreArchivingEnabled() {
        return this.preArchivingEnabled;
    }

    public void setPreArchivingEnabled(Boolean enabled) {
        logger.info("Setting pre-archiving enabled to be " + enabled);
        if (this.preArchivingEnabledChangedCallback != null && enabled != this.preArchivingEnabled) {
            this.preArchivingEnabledChangedCallback.accept(enabled);
        }
        this.preArchivingEnabled = enabled;
    }

    public Integer getReleaseAgeToDeleteFromJcr() {
        return this.getStoredArchivingSettings().getReleaseAgeToDeleteFromJcr();
    }

    public String getArchivingJobCronSchedule() {
        return this.getStoredArchivingSettings().getArchivingJobCronSchedule();
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        logger.info("Setting archiving enabled to be " + enabled);
        this.enabled = enabled;
    }

    public Integer getSearchPageSize() {
        return this.searchPageSize;
    }

    public void setSearchPageSize(Integer searchPageSize) {
        logger.info("Setting archiving search page size to be " + searchPageSize);
        this.searchPageSize = searchPageSize;
    }

    public Integer getMaxSecondsPerRun() {
        return this.maxSecondsPerRun;
    }

    public void setMaxSecondsPerRun(Integer maxSecondsPerRun) {
        logger.info("Setting archiving max seconds per run to be " + maxSecondsPerRun);
        this.maxSecondsPerRun = maxSecondsPerRun;
    }

    public Integer getSleepSecondsBetweenReleases() {
        return this.sleepSecondsBetweenReleases;
    }

    public void setSleepSecondsBetweenReleases(Integer sleepSecondsBetweenReleases) {
        logger.info("Setting archiving sleep seconds between releases to be " + sleepSecondsBetweenReleases);
        this.sleepSecondsBetweenReleases = sleepSecondsBetweenReleases;
    }

    private ArchivingSettings getStoredArchivingSettings() {
        return (ArchivingSettings)this.configurationRepository.read("Configuration/settings/ArchivingSettings");
    }
}

