/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.webhook;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.json.JsonSmartJsonProvider;
import com.jayway.jsonpath.spi.mapper.JsonSmartMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;

public class JsonPathResult {
    private static final JsonProvider jacksonJsonProvider = new JacksonJsonProvider();
    private static final JsonProvider jsonSmartJsonProvider = new JsonSmartJsonProvider();
    private static final MappingProvider mappingProvider = new JsonSmartMappingProvider();
    private static final Configuration config = Configuration.builder().jsonProvider(jsonSmartJsonProvider).mappingProvider(mappingProvider).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build();
    private final String json;
    private final String jsonPathExpression;

    public JsonPathResult(String json, String jsonPathExpression) {
        this.json = json;
        this.jsonPathExpression = jsonPathExpression;
    }

    public Object get() {
        return this.readJson();
    }

    public Object getString() {
        Object object = this.readJson();
        return object != null ? this.toJson(object) : null;
    }

    private Object readJson() {
        if (this.json == null || this.json.isEmpty()) {
            return null;
        }
        return JsonPath.compile((String)this.jsonPathExpression, (Predicate[])new Predicate[0]).read(this.json, config);
    }

    private String toJson(Object object) {
        return this.isString(object) ? (String)object : jacksonJsonProvider.toJson(object);
    }

    private boolean isString(Object object) {
        return object instanceof String;
    }
}

