/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.configuration.ArchivingSettings;
import com.xebialabs.xlrelease.configuration.AuditReportSettings;
import com.xebialabs.xlrelease.configuration.CustomLogoSettings;
import com.xebialabs.xlrelease.configuration.FeatureSettings;
import com.xebialabs.xlrelease.configuration.PollingSettings;
import com.xebialabs.xlrelease.configuration.ReportsSettings;
import com.xebialabs.xlrelease.configuration.ThemeColor;
import com.xebialabs.xlrelease.configuration.ThemeColors$;
import com.xebialabs.xlrelease.configuration.ThemeSettings;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005%c\u0001\u0002\b\u0010\u0001aA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!)Q\u0007\u0001C\u0001m!)1\b\u0001C\u0001y!)1\b\u0001C\u0001;\")A\r\u0001C\u0001K\")q\r\u0001C\u0001Q\")a\u000e\u0001C\u0001_\")!\u000f\u0001C\u0001g\")!\u0010\u0001C\u0005w\")a\u0010\u0001C\u0001\u007f\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0002\u0015\u0007>tg-[4ve\u0006$\u0018n\u001c8TKJ4\u0018nY3\u000b\u0005A\t\u0012aB:feZL7-\u001a\u0006\u0003%M\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005Q)\u0012!\u0003=fE&\fG.\u00192t\u0015\u00051\u0012aA2p[\u000e\u00011c\u0001\u0001\u001a?A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\u0004\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u000bMdg\r\u000e6\u000b\u0003\u0011\n\u0001b\u001a:jujdW\rZ\u0005\u0003M\u0005\u0012q\u0001T8hO&tw-A\fd_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011\u0011\u0006L\u0007\u0002U)\u00111&E\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u0017+\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u00180\u0001\u0005fm\u0016tGOQ;t!\t\u00014'D\u00012\u0015\t\u0011\u0014#\u0001\u0004fm\u0016tGo]\u0005\u0003iE\u0012\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003\u0019a\u0014N\\5u}Q\u0019q'\u000f\u001e\u0011\u0005a\u0002Q\"A\b\t\u000b\u001d\u001a\u0001\u0019\u0001\u0015\t\u000b9\u001a\u0001\u0019A\u0018\u0002\u001d\r\u0014X-\u0019;f\u001fJ,\u0006\u000fZ1uKR\u0019Qh\u0011)\u0011\u0005y\nU\"A \u000b\u0005\u0001\u000b\u0012A\u00023p[\u0006Lg.\u0003\u0002C\u007f\t\t\")Y:f\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000b\u0011#\u0001\u0019A#\u0002\u0005%$\u0007C\u0001$N\u001d\t95\n\u0005\u0002I75\t\u0011J\u0003\u0002K/\u00051AH]8pizJ!\u0001T\u000e\u0002\rA\u0013X\rZ3g\u0013\tquJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0019nAQ!\u0015\u0003A\u0002u\n\u0011cY8oM&<WO]1uS>t\u0017\n^3nQ\t!1\u000b\u0005\u0002U76\tQK\u0003\u0002W/\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005aK\u0016aB7fiJL7m\u001d\u0006\u00035V\t\u0001bY8eC\"\fG.Z\u0005\u00039V\u0013Q\u0001V5nK\u0012$\"AX1\u0011\u0005iy\u0016B\u00011\u001c\u0005\u0011)f.\u001b;\t\u000b\t,\u0001\u0019A\u001f\u0002\u001b\r|gNZ5hkJ\fG/[8oQ\t)1+\u0001\u0003sK\u0006$GCA\u001fg\u0011\u0015!e\u00011\u0001F\u0003\u0019)\u00070[:ugR\u0011\u0011\u000e\u001c\t\u00035)L!a[\u000e\u0003\u000f\t{w\u000e\\3b]\")Ai\u0002a\u0001\u000b\"\u0012qaU\u0001\u0007I\u0016dW\r^3\u0015\u0005y\u0003\b\"\u0002#\t\u0001\u0004)\u0005F\u0001\u0005T\u0003A9W\r\u001e+iK6,7+\u001a;uS:<7/F\u0001u!\t)x/D\u0001w\u0015\t\u0011\u0017#\u0003\u0002ym\niA\u000b[3nKN+G\u000f^5oOND#!C*\u0002-\r|gN^3si\u000e{Gn\u001c:OC6,Gk\\\"pI\u0016$\"\u0001\u001e?\t\u000buT\u0001\u0019\u0001;\u0002\u001bQDW-\\3TKR$\u0018N\\4t\u00039\u0019\u0018M^3DkN$x.\u001c'pO>$B!!\u0001\u0002\bA\u0019Q/a\u0001\n\u0007\u0005\u0015aO\u0001\nDkN$x.\u001c'pO>\u001cV\r\u001e;j]\u001e\u001c\bbBA\u0005\u0017\u0001\u0007\u0011\u0011A\u0001\u0013GV\u001cHo\\7M_\u001e|7+\u001a;uS:<7\u000f\u000b\u0002\f'\u0006\u0011r-\u001a;GK\u0006$XO]3TKR$\u0018N\\4t)\t\t\t\u0002\u0005\u0004\u0002\u0014\u0005u\u0011\u0011E\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005!Q\u000f^5m\u0015\t\tY\"\u0001\u0003kCZ\f\u0017\u0002BA\u0010\u0003+\u0011A\u0001T5tiB\u0019Q/a\t\n\u0007\u0005\u0015bOA\bGK\u0006$XO]3TKR$\u0018N\\4tQ\ta1+A\ntCZ,g)Z1ukJ,7+\u001a;uS:<7\u000fF\u0002_\u0003[Aq!a\f\u000e\u0001\u0004\t\t\"\u0001\u0005gK\u0006$XO]3tQ\ti1\u000bK\u0002\u0001\u0003k\u0001B!a\u000e\u0002F5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016TA!a\u0010\u0002B\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002D\u0005\u0019qN]4\n\t\u0005\u001d\u0013\u0011\b\u0002\b'\u0016\u0014h/[2f\u0001")
public class ConfigurationService
implements Logging {
    private final ConfigurationRepository configurationRepository;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ConfigurationService configurationService = this;
        synchronized (configurationService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public BaseConfiguration createOrUpdate(String id, BaseConfiguration configurationItem) {
        BaseConfiguration baseConfiguration = configurationItem;
        if (baseConfiguration instanceof ReportsSettings) {
            ReportsSettings reportsSettings = (ReportsSettings)baseConfiguration;
            reportsSettings.validate();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseConfiguration instanceof ArchivingSettings) {
            ArchivingSettings archivingSettings = (ArchivingSettings)baseConfiguration;
            archivingSettings.validate();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseConfiguration instanceof PollingSettings) {
            PollingSettings pollingSettings = (PollingSettings)baseConfiguration;
            pollingSettings.validate();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseConfiguration instanceof ThemeSettings) {
            ThemeSettings themeSettings = (ThemeSettings)baseConfiguration;
            themeSettings.setHeaderAccentColor(((Enum)ThemeColors$.MODULE$.themeColorFromCode().apply((Object)themeSettings.getHeaderAccentColor().toUpperCase())).name());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseConfiguration instanceof AuditReportSettings) {
            AuditReportSettings auditReportSettings = (AuditReportSettings)baseConfiguration;
            auditReportSettings.validate();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        configurationItem.setId(id);
        this.createOrUpdate(configurationItem);
        return this.read(id);
    }

    @Timed
    public void createOrUpdate(BaseConfiguration configuration) {
        if (!Ids.isNullId((String)configuration.getId()) && this.configurationRepository.exists(configuration.getId())) {
            Object original = this.configurationRepository.read(configuration.getId());
            PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)new Some(original), (ConfigurationItem)configuration);
            this.configurationRepository.update(configuration);
            this.eventBus.publish((XLReleaseEvent)new ConfigurationUpdatedEvent(configuration));
        } else {
            this.configurationRepository.create(configuration);
            this.eventBus.publish((XLReleaseEvent)new ConfigurationCreatedEvent(configuration));
        }
    }

    public BaseConfiguration read(String id) {
        Object object;
        Object baseConfiguration = this.configurationRepository.read(id);
        Object t = baseConfiguration;
        if (t instanceof ThemeSettings) {
            ThemeSettings themeSettings = (ThemeSettings)t;
            object = this.convertColorNameToCode(themeSettings);
        } else {
            object = t;
        }
        return object;
    }

    @Timed
    public boolean exists(String id) {
        return this.configurationRepository.exists(id);
    }

    @Timed
    public void delete(String id) {
        Object conf = this.configurationRepository.read(id);
        this.configurationRepository.delete(id);
        this.eventBus.publish((XLReleaseEvent)new ConfigurationDeletedEvent(conf));
    }

    @Timed
    public ThemeSettings getThemeSettings() {
        ThemeSettings themeSettings = this.configurationRepository.getThemeSettings();
        return this.convertColorNameToCode(themeSettings);
    }

    private ThemeSettings convertColorNameToCode(ThemeSettings themeSettings) {
        themeSettings.setHeaderAccentColor(ThemeColors$.MODULE$.colorCode(ThemeColor.valueOf((String)themeSettings.getHeaderAccentColor().toUpperCase())));
        return themeSettings;
    }

    @Timed
    public CustomLogoSettings saveCustomLogo(CustomLogoSettings customLogoSettings) {
        customLogoSettings.validateContentType();
        return (CustomLogoSettings)this.createOrUpdate("Configuration/settings/CustomLogoSettings", (BaseConfiguration)customLogoSettings);
    }

    @Timed
    public List<FeatureSettings> getFeatureSettings() {
        Buffer features = CollectionConverters$.MODULE$.ListHasAsScala(this.configurationRepository.findAllByType(Type.valueOf(FeatureSettings.class))).asScala();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(FeatureSettings.class))).asScala().map((Function1 & Serializable)featureType -> (FeatureSettings)features.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigurationService.$anonfun$getFeatureSettings$2(featureType, x$1))).getOrElse((Function0 & Serializable)() -> {
            void var1_1;
            FeatureSettings feature = (FeatureSettings)featureType.getDescriptor().newInstance("");
            feature.generateId();
            return var1_1;
        }))).toList().sortBy((Function1 & Serializable)x$2 -> x$2.getType().getDescriptor().getLabel(), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    @Timed
    public void saveFeatureSettings(List<FeatureSettings> features) {
        CollectionConverters$.MODULE$.ListHasAsScala(features).asScala().foreach((Function1 & Serializable)configuration -> {
            this.createOrUpdate(configuration);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getFeatureSettings$2(Type featureType$1, FeatureSettings x$1) {
        Type type = x$1.getType();
        Type type2 = featureType$1;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public ConfigurationService(ConfigurationRepository configurationRepository, XLReleaseEventBus eventBus) {
        this.configurationRepository = configurationRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

