/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.deployit.plumbing.CurrentVersion;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class VersionEnforcerFilter
implements Filter {
    private static final String VERSION_PARAMETER = "xlrv";
    private static final Pattern VERSION_PATTERN = Pattern.compile("^[0-9]+\\.[0-9]+(\\.[0-9]+)?(-(alpha|beta|rc|SNAPSHOT|[0-9]+)(\\.[0-9]+)?)?$");
    private String serverVersion;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.serverVersion = CurrentVersion.get();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String[] values = request.getParameterValues(VERSION_PARAMETER);
        boolean doFilter = true;
        if (values != null) {
            String clientVersion = values[0];
            if (!this.isClientVersionValid(clientVersion)) {
                response.setContentType("text/plain");
                response.getWriter().write(String.format("%s : provided version format is incorrect", "XL Release"));
                ((HttpServletResponse)response).setStatus(410);
                doFilter = false;
            }
            if (!clientVersion.equals(this.serverVersion) && doFilter) {
                response.setContentType("text/plain");
                response.getWriter().write(String.format("%s version changed : you are using %s, but server version is now %s", "XL Release", clientVersion, this.serverVersion));
                ((HttpServletResponse)response).setStatus(410);
                doFilter = false;
            }
        }
        if (doFilter) {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private boolean isClientVersionValid(String clientVersion) {
        Matcher versionMatcher = VERSION_PATTERN.matcher(clientVersion);
        return versionMatcher.matches();
    }
}

