/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.internal.ProfileResource;
import com.xebialabs.xlrelease.api.v1.UserApi;
import com.xebialabs.xlrelease.api.v1.forms.UserAccount;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.validators.UserAccountValidator;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.SessionService;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.service.Users;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.ChangePasswordView;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class UserApiImpl
implements UserApi {
    private static final Logger logger = LoggerFactory.getLogger(UserApiImpl.class);
    private final UserProfileService userProfileService;
    private final PermissionChecker permissions;
    private final Users users;
    private final UserService userService;
    private final SessionService sessionService;
    private final UserAccountValidator userAccountValidator;

    @Autowired
    public UserApiImpl(UserProfileService userProfileService, PermissionChecker permissions, Users users, UserService userService, SessionService sessionService, UserAccountValidator userAccountValidator) {
        this.userProfileService = userProfileService;
        this.permissions = permissions;
        this.users = users;
        this.userService = userService;
        this.sessionService = sessionService;
        this.userAccountValidator = userAccountValidator;
    }

    @Timed
    public Response createUser(String username, UserAccount userAccount) {
        userAccount.setUsername(username);
        UserAccount createdAccount = this.createUser(userAccount);
        return Response.ok((Object)createdAccount).build();
    }

    @Timed
    public Response updateUser(String username, UserAccount userAccount) {
        userAccount.setUsername(username);
        this.userAccountValidator.checkEmail(userAccount);
        UserAccount updatedAccount = this.updateUser(userAccount);
        return Response.ok((Object)updatedAccount).build();
    }

    @Timed
    public Response updateUsersRest(Collection<UserAccount> userAccounts) {
        this.updateUsers(userAccounts);
        return Response.noContent().build();
    }

    @Timed
    public Response updatePassword(String username, ChangePasswordView changePasswordView) {
        this.updatePassword(username, changePasswordView.getCurrentPassword(), changePasswordView.getNewPassword());
        return Response.noContent().build();
    }

    @Timed
    public Response deleteUserRest(String username) {
        this.deleteUser(username);
        return Response.noContent().build();
    }

    @Timed
    public List<UserAccount> findUsers(String email, String fullName, Boolean loginAllowed, Boolean external, Date lastActiveAfter, Date lastActiveBefore, Long page, Long resultsPerPage) {
        this.permissions.check(PlatformPermissions.EDIT_SECURITY);
        List<UserProfile> userProfiles = this.userProfileService.search(email, fullName, loginAllowed, lastActiveAfter, lastActiveBefore, page, resultsPerPage);
        List<String> internalNames = this.users.getRepositoryUsernames();
        return userProfiles.stream().map(profile -> new UserAccount(profile.getCanonicalId(), profile, this.isInternalUser(internalNames, profile.getCanonicalId()))).filter(account -> external == null || account.isExternal() == external.booleanValue()).collect(Collectors.toList());
    }

    @Timed
    public UserAccount getUser(String username) {
        if (this.isUsernameLoggedIn(username) || this.permissions.hasGlobalPermission(PlatformPermissions.EDIT_SECURITY)) {
            Optional<UserProfile> byUsername = Optional.ofNullable(this.userProfileService.findByUsername(username));
            Optional userAccount = byUsername.flatMap(u -> Optional.of(new UserAccount(username, u, this.users.userExistsInRepository(username))));
            return (UserAccount)userAccount.orElseThrow(() -> new NotFoundException(String.format("User [%s] not found", username)));
        }
        throw PermissionDeniedException.forPermission((Permission)PlatformPermissions.EDIT_SECURITY, (String)null);
    }

    @Timed
    public UserAccount createUser(UserAccount userAccount) {
        this.permissions.check(PlatformPermissions.EDIT_SECURITY);
        this.userAccountValidator.check(userAccount);
        logger.info(String.format("Creating user [%s]", userAccount.getUsername()));
        UserProfile userProfile = userAccount.toUserProfile();
        this.userProfileService.validate(userProfile);
        this.userService.create(userAccount.getUsername(), userAccount.getPassword());
        this.userProfileService.save(userProfile);
        return this.getUser(userAccount.getUsername());
    }

    @Timed
    public UserAccount updateUser(UserAccount userAccount) {
        String username = userAccount.getUsername();
        if (this.isUsernameLoggedIn(username) || this.permissions.hasGlobalPermission(PlatformPermissions.EDIT_SECURITY)) {
            logger.info(String.format("Updating user [%s]", username));
            UserProfile profile = userAccount.toUserProfile();
            this.userProfileService.updateProfile(profile);
            return userAccount;
        }
        throw PermissionDeniedException.forPermission((Permission)PlatformPermissions.EDIT_SECURITY, (String)null);
    }

    @Timed
    public void updateUsers(Collection<UserAccount> userAccounts) {
        this.permissions.check(PlatformPermissions.EDIT_SECURITY);
        userAccounts.forEach(user -> {
            this.userAccountValidator.checkEmail((UserAccount)user);
            Preconditions.checkArgument((boolean)Strings.isNotBlank((String)user.getUsername()), (Object)"Username is required");
        });
        logger.info(String.format("Updating %d users", userAccounts.size()));
        UserProfile[] userProfilesToUpdate = (UserProfile[])userAccounts.stream().map(UserAccount::toUserProfile).toArray(UserProfile[]::new);
        this.userProfileService.updateProfile(userProfilesToUpdate);
    }

    @Timed
    public void updatePassword(String username, String currentPassword, String newPassword) {
        boolean canEditSecurity = this.permissions.hasGlobalPermission(PlatformPermissions.EDIT_SECURITY);
        if (!canEditSecurity && !this.isUsernameLoggedIn(username)) {
            throw PermissionDeniedException.forPermission((Permission)PlatformPermissions.EDIT_SECURITY, (String)null);
        }
        if (this.users.userExistsInRepository(username)) {
            this.userAccountValidator.checkPassword(newPassword);
            try {
                Preconditions.checkArgument((boolean)Strings.isNotBlank((String)newPassword), (Object)"Password cannot be empty.");
                logger.info(String.format("Updating password of user [%s]", username));
                if (canEditSecurity) {
                    this.userService.modifyPassword(username, newPassword);
                }
                this.userService.modifyPassword(username, newPassword, currentPassword);
            }
            catch (IllegalArgumentException e) {
                throw new ProfileResource.InvalidPreviousPasswordException(e);
            }
        } else {
            throw new Checks.IncorrectArgumentException("Cannot update a password of an external user", new Object[0]);
        }
    }

    @Timed
    public void deleteUser(String username) {
        this.permissions.check(PlatformPermissions.EDIT_SECURITY);
        Preconditions.checkArgument((!XLReleasePermissions.isAdmin((String)username) ? 1 : 0) != 0, (Object)"Admin user cannot be deleted.");
        Preconditions.checkArgument((!this.isUsernameLoggedIn(username) ? 1 : 0) != 0, (Object)"Your own account cannot be deleted.");
        this.getUser(username);
        logger.info(String.format("Deleting user [%s]", username));
        if (this.users.userExistsInRepository(username)) {
            this.userService.delete(username);
        }
        this.userProfileService.deleteByUsername(username);
        this.sessionService.disconnect(username);
    }

    private boolean isUsernameLoggedIn(String username) {
        return username.equalsIgnoreCase(User.AUTHENTICATED_USER.getName());
    }

    private boolean isInternalUser(List<String> internalNames, String name) {
        for (String internalName : internalNames) {
            if (!name.equalsIgnoreCase(internalName)) continue;
            return true;
        }
        return false;
    }
}

