/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security.authentication;

import java.util.Collection;
import java.util.Optional;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.userdetails.LdapUserDetailsMapper;

public class UsernameAttributeLdapContextMapper
extends LdapUserDetailsMapper {
    private String ldapUsernameAttribute = "samAccountName";

    public UserDetails mapUserFromContext(DirContextOperations ctx, String username, Collection<? extends GrantedAuthority> authorities) {
        return Optional.ofNullable(ctx.getStringAttribute(this.getLdapUsernameAttribute())).map(originalUsername -> super.mapUserFromContext(ctx, originalUsername, authorities)).orElseThrow(() -> new IllegalStateException(String.format("LDAP attribute not found: %s", this.getLdapUsernameAttribute())));
    }

    public void setLdapUsernameAttribute(String ldapUsernameAttribute) {
        this.ldapUsernameAttribute = ldapUsernameAttribute;
    }

    public String getLdapUsernameAttribute() {
        return this.ldapUsernameAttribute;
    }
}

