/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plumbing.LogbackFilter;
import com.xebialabs.deployit.plumbing.ModifiedResourceFilter;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.deployit.plumbing.SlowdownFilter;
import com.xebialabs.deployit.plumbing.VersionEnforcerFilter;
import com.xebialabs.deployit.plumbing.XLRequestLogImpl;
import com.xebialabs.deployit.plumbing.XssSecurityHeadersFilter;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServlet;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServletInitializer;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry$;
import com.xebialabs.xlrelease.security.HttpSessionListenerWithTimeout;
import com.xebialabs.xlrelease.server.jetty.SSLConstants$;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.SessionTrackingMode;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%c\u0001B\f\u0019\u0001\rB\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005k!AA\b\u0001BC\u0002\u0013\u0005Q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015\u0019\u0006\u0001\"\u0015U\u0011\u0015\u0019\u0007\u0001\"\u0003e\u0011\u00151\u0007\u0001\"\u0003h\u0011\u0015I\u0007\u0001\"\u0003k\u0011\u0015a\u0007\u0001\"\u0003n\u0011\u0015y\u0007\u0001\"\u0003q\u0011\u0015\u0011\b\u0001\"\u0003t\u0011\u0015)\b\u0001\"\u0003w\u0011\u0015A\b\u0001\"\u0003z\u0011\u0015Y\b\u0001\"\u0003}\u0011\u0015q\b\u0001\"\u0003\u0000\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000bAq!!\u0003\u0001\t\u0013\tY\u0001C\u0004\u0002\u0010\u0001!I!!\u0005\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$!9\u0011q\u0005\u0001\u0005\n\u0005%\"a\t*fY\u0016\f7/\u001a&fiRL8+\u001a:wY\u0016$x+\u001a2TKJ4XM\u001d$bGR|'/\u001f\u0006\u00033i\tQA[3uifT!a\u0007\u000f\u0002\rM,'O^3s\u0015\tib$A\u0005yYJ,G.Z1tK*\u0011q\u0004I\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!I\u0001\u0004G>l7\u0001A\n\u0003\u0001\u0011\u0002\"!J\u0019\u000e\u0003\u0019R!!G\u0014\u000b\u0005!J\u0013\u0001C3nE\u0016$G-\u001a3\u000b\u0005)Z\u0013aA<fE*\u0011A&L\u0001\u0005E>|GO\u0003\u0002/_\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u00011\u0003\ry'oZ\u0005\u0003e\u0019\u0012ADS3uif\u001cVM\u001d<mKR<VMY*feZ,'OR1di>\u0014\u00180A\ntKJ4XM]\"p]\u001aLw-\u001e:bi&|g.F\u00016!\t1\u0014(D\u00018\u0015\tAd$\u0001\u0005eKBdw._5u\u0013\tQtGA\nTKJ4XM]\"p]\u001aLw-\u001e:bi&|g.\u0001\u000btKJ4XM]\"p]\u001aLw-\u001e:bi&|g\u000eI\u0001\nq2\u00148i\u001c8gS\u001e,\u0012A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003r\taaY8oM&<\u0017BA\"A\u0005%AFN]\"p]\u001aLw-\u0001\u0006yYJ\u001cuN\u001c4jO\u0002\na\u0001P5oSRtDcA$J\u0015B\u0011\u0001\nA\u0007\u00021!)1'\u0002a\u0001k!)A(\u0002a\u0001}\u0005A\u0012n\u001d*fO&\u001cH/\u001a:EK\u001a\fW\u000f\u001c;TKJ4H.\u001a;\u0015\u00035\u0003\"AT)\u000e\u0003=S\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u0013qAQ8pY\u0016\fg.\u0001\rq_N$\bK]8dKN\u001cx+\u001a2BaB\u001cuN\u001c;fqR$\"!\u0016-\u0011\u000593\u0016BA,P\u0005\u0011)f.\u001b;\t\u000be;\u0001\u0019\u0001.\u0002\u0017\r|g\u000e^3yiJ{w\u000e\u001e\t\u00037\u0006l\u0011\u0001\u0018\u0006\u0003;z\u000baa^3cCB\u0004(BA\r`\u0015\t\u0001w&A\u0004fG2L\u0007o]3\n\u0005\td&!D,fE\u0006\u0003\boQ8oi\u0016DH/\u0001\u0006tKR,\bOS3uif$\"!V3\t\u000beC\u0001\u0019\u0001.\u0002%M,G/\u001e9M_\u001e\u0014\u0017mY6GS2$XM\u001d\u000b\u0003+\"DQ!W\u0005A\u0002i\u000b1b]3ukB\u001c\u0006O]5oOR\u0011Qk\u001b\u0005\u00063*\u0001\rAW\u0001\u000fg\u0016$X\u000f]!dG\u0016\u001c8\u000fT8h)\t)f\u000eC\u0003Z\u0017\u0001\u0007!,A\btKR,\boQ8sg\u001aKG\u000e^3s)\t)\u0016\u000fC\u0003Z\u0019\u0001\u0007!,A\u000ftKR,\b\u000fW:t'\u0016\u001cWO]5us\"+\u0017\rZ3sg\u001aKG\u000e^3s)\t)F\u000fC\u0003Z\u001b\u0001\u0007!,A\ntKR,\bo\u00157po\u0012|wO\u001c$jYR,'\u000f\u0006\u0002Vo\")\u0011L\u0004a\u00015\u0006\t2/\u001a;va\u0016CH/\u001a8tS>t\u0017\t]5\u0015\u0005US\b\"B-\u0010\u0001\u0004Q\u0016\u0001F:fiV\u0004h+\u001a:tS>tWI\u001c4pe\u000e,'\u000f\u0006\u0002V{\")\u0011\f\u0005a\u00015\u0006\t2/\u001a;vaJ+\u0017/^3ti2{7-\u00197\u0015\u0007U\u000b\t\u0001C\u0003Z#\u0001\u0007!,\u0001\u000bf]\u0006\u0014G.\u001a*fg>,(oY3t\u0007\u0006\u001c\u0007.\u001a\u000b\u0004+\u0006\u001d\u0001\"B-\u0013\u0001\u0004Q\u0016!E3oC\ndWm\u0012>ja\"\u000bg\u000e\u001a7feR\u0019Q+!\u0004\t\u000be\u001b\u0002\u0019\u0001.\u0002#9,woU3tg&|g\u000eS1oI2,'/\u0006\u0002\u0002\u0014A!\u0011QCA\u000f\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011aB:fgNLwN\u001c\u0006\u00037yKA!a\b\u0002\u0018\tq1+Z:tS>t\u0007*\u00198eY\u0016\u0014\u0018!G3oC\ndW-\u00138tiJ,X.\u001a8uK\u0012D\u0015M\u001c3mKJ$2!VA\u0013\u0011\u0015IV\u00031\u0001[\u0003E\u0019X\r\u001e)s_B,'\u000f^=JM:+H\u000e\u001c\u000b\u0006+\u0006-\u0012Q\t\u0005\b\u0003[1\u0002\u0019AA\u0018\u0003\rYW-\u001f\t\u0005\u0003c\tyD\u0004\u0003\u00024\u0005m\u0002cAA\u001b\u001f6\u0011\u0011q\u0007\u0006\u0004\u0003s\u0011\u0013A\u0002\u001fs_>$h(C\u0002\u0002>=\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA!\u0003\u0007\u0012aa\u0015;sS:<'bAA\u001f\u001f\"9\u0011q\t\fA\u0002\u0005=\u0012!\u0002<bYV,\u0007")
public class ReleaseJettyServletWebServerFactory
extends JettyServletWebServerFactory {
    private final ServerConfiguration serverConfiguration;
    private final XlrConfig xlrConfig;

    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public boolean isRegisterDefaultServlet() {
        return false;
    }

    public void postProcessWebAppContext(WebAppContext contextRoot) {
        this.setupJetty(contextRoot);
        this.setupLogbackFilter(contextRoot);
        this.setupSpring(contextRoot);
        this.setupAccessLog(contextRoot);
        this.setupCorsFilter(contextRoot);
        this.setupXssSecurityHeadersFilter(contextRoot);
        this.setupSlowdownFilter(contextRoot);
        this.setupExtensionApi(contextRoot);
        this.setupVersionEnforcer(contextRoot);
        this.setupRequestLocal(contextRoot);
    }

    private void setupJetty(WebAppContext contextRoot) {
        block2: {
            ErrorHandler errorHandler = new ErrorHandler();
            errorHandler.setShowStacks(false);
            errorHandler.setShowServlet(false);
            contextRoot.setSessionHandler(this.newSessionHandler());
            contextRoot.setSecurityHandler((SecurityHandler)new ConstraintSecurityHandler());
            contextRoot.setErrorHandler(errorHandler);
            if (this.xlrConfig().metrics().enabled()) {
                this.enableInstrumentedHandler(contextRoot);
            }
            if (this.xlrConfig().server_http_gzip_enabled()) {
                this.enableGzipHandler(contextRoot);
            }
            if (!this.xlrConfig().server_http_cache_enabled() || !Environment.isProduction()) break block2;
            this.enableResourcesCache(contextRoot);
        }
    }

    private void setupLogbackFilter(WebAppContext contextRoot) {
        contextRoot.addFilter(LogbackFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSpring(WebAppContext contextRoot) {
        this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PROPERTY(), this.serverConfiguration().getKeyStorePath());
        this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getKeyStorePassword());
        this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PROPERTY(), this.serverConfiguration().getTrustStorePath());
        this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getTrustStorePassword());
        contextRoot.setInitParameter("contextClass", XmlWebApplicationContext.class.getName());
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        contextRoot.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder encodingFilter = new FilterHolder(CharacterEncodingFilter.class);
        encodingFilter.setName("encodingFilter");
        encodingFilter.setInitParameter("encoding", "UTF-8");
        encodingFilter.setInitParameter("forceEncoding", "true");
        contextRoot.addFilter(encodingFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.setResourceBase(".");
        if (!this.xlrConfig().server_session_storage_enabled()) {
            contextRoot.addEventListener((EventListener)((Object)new HttpSessionListenerWithTimeout()));
        }
        contextRoot.getInitParams().put("resteasy.scan.resources", "true");
        contextRoot.getInitParams().put("resteasy.scan.providers", "true");
        contextRoot.getInitParams().put("resteasy.document.expand.entity.references", "false");
    }

    private void setupAccessLog(WebAppContext contextRoot) {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        XLRequestLogImpl requestLogger = new XLRequestLogImpl("conf/logback-access.xml");
        requestLogHandler.setRequestLog((RequestLog)requestLogger);
        contextRoot.insertHandler((HandlerWrapper)requestLogHandler);
    }

    private void setupCorsFilter(WebAppContext contextRoot) {
        block0: {
            if (!this.xlrConfig().api_corsEnabled()) break block0;
            FilterHolder holder = new FilterHolder((Filter)new CrossOriginFilter());
            holder.setInitParameter("Access-Control-Allow-Origin", "*");
            holder.setInitParameter("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE, PUT");
            holder.setInitParameter("Access-Control-Allow-Headers", "3600");
            holder.setInitParameter("Access-Control-Max-Age", "x-requested-with, accept, origin, content-type");
            contextRoot.addFilter(holder, "/api/v1/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupXssSecurityHeadersFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new XssSecurityHeadersFilter());
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSlowdownFilter(WebAppContext contextRoot) {
        block0: {
            long slowDownInMs;
            if (!Environment.isDevelopment() || (slowDownInMs = this.xlrConfig().development_restSlowDownDelay().toMillis()) <= 0L) break block0;
            this.logger.warn((Object)new StringBuilder(48).append("Configuring slow down filter with ").append(slowDownInMs).append(" milliseconds.").toString());
            FilterHolder slowdownFilter = new FilterHolder(SlowdownFilter.class);
            slowdownFilter.setInitParameter("ms", String.valueOf(slowDownInMs));
            contextRoot.addFilter(slowdownFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupExtensionApi(WebAppContext contextRoot) {
        String apiExtensionRootPath = this.xlrConfig().serverExtension_rootPath();
        String apiExtensionContext = String.format("%s/*", apiExtensionRootPath);
        ServletHolder extensionApiServletHolder = new ServletHolder(AkkaStreamServlet.class);
        extensionApiServletHolder.setDisplayName("ExtensionApiConnectorServlet");
        extensionApiServletHolder.setAsyncSupported(true);
        contextRoot.addEventListener((EventListener)new AkkaStreamServletInitializer());
        contextRoot.addServlet(extensionApiServletHolder, apiExtensionContext);
    }

    private void setupVersionEnforcer(WebAppContext contextRoot) {
        block0: {
            if (Environment.isDevelopment()) break block0;
            contextRoot.addFilter(VersionEnforcerFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupRequestLocal(WebAppContext contextRoot) {
        contextRoot.addFilter(RequestLocal.class, "*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void enableResourcesCache(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new ModifiedResourceFilter());
        holder.setInitParameter("startTimestamp", String.valueOf(System.currentTimeMillis()));
        contextRoot.addFilter(holder, "/static/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-module.js", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-plugins.js", EnumSet.of(DispatcherType.REQUEST));
    }

    private void enableGzipHandler(WebAppContext contextRoot) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT"});
        gzipHandler.setCompressionLevel(this.xlrConfig().server_http_gzip_compression());
        gzipHandler.setMinGzipSize(this.xlrConfig().server_http_gzip_minSize().intValue());
        gzipHandler.setExcludedPaths((String[])CollectionConverters$.MODULE$.ListHasAsScala(this.xlrConfig().server_http_gzip_excludedPaths()).asScala().toSeq().toArray(ClassTag$.MODULE$.apply(String.class)));
        contextRoot.insertHandler((HandlerWrapper)gzipHandler);
    }

    /*
     * WARNING - void declaration
     */
    private SessionHandler newSessionHandler() {
        void var1_1;
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
        sessionHandler.setHttpOnly(true);
        if (!this.serverConfiguration().isSsl()) {
            this.logger.debug((Object)new StringBuilder(38).append("Setting up Secure Cookie Enabled to - ").append(this.serverConfiguration().isSecureCookieEnabled()).toString());
            sessionHandler.getSessionCookieConfig().setSecure(this.serverConfiguration().isSecureCookieEnabled());
        }
        sessionHandler.setSameSite(HttpCookie.SameSite.valueOf((String)this.xlrConfig().server_http_cookie_sameSite().getAttributeValue().toUpperCase()));
        return var1_1;
    }

    private void enableInstrumentedHandler(WebAppContext contextRoot) {
        InstrumentedHandler handler = new InstrumentedHandler(XlrMetricRegistry$.MODULE$.metricRegistry());
        contextRoot.insertHandler((HandlerWrapper)handler);
    }

    private void setPropertyIfNull(String key, String value) {
        block1: {
            block2: {
                if (value == null) break block1;
                if (System.getProperty(key) != null) break block2;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)new StringBuilder(26).append("Setting system property - ").append(key).toString());
                }
                System.setProperty(key, value);
                break block1;
            }
            if (!this.logger.isDebugEnabled()) break block1;
            this.logger.debug((Object)new StringBuilder(51).append("Not overriding already specified system property - ").append(key).toString());
        }
    }

    public ReleaseJettyServletWebServerFactory(ServerConfiguration serverConfiguration, XlrConfig xlrConfig) {
        this.serverConfiguration = serverConfiguration;
        this.xlrConfig = xlrConfig;
    }
}

