/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorService.class);

    public static void shutdown(String description, ExecutorService executorService) {
        try {
            logger.info("Shutting down {}", (Object)description);
            executorService.shutdown();
            boolean terminated = ExecutorServiceUtils.awaitTerminationIfNecessary(description, executorService);
            if (!terminated) {
                for (Runnable remainingTask : executorService.shutdownNow()) {
                    ExecutorServiceUtils.cancelRemainingTask(remainingTask);
                }
                if (!ExecutorServiceUtils.awaitTerminationIfNecessary(description, executorService)) {
                    logger.error("Unable to terminate '{}' via shutdownNow", (Object)description);
                }
            }
        }
        catch (SecurityException ex) {
            logger.error("Unable to shutdown '{}' executor service", (Object)description, (Object)ex);
        }
    }

    private static void cancelRemainingTask(Runnable task) {
        if (task instanceof Future) {
            ((Future)((Object)task)).cancel(true);
        }
    }

    private static boolean awaitTerminationIfNecessary(String description, ExecutorService executorService) {
        boolean terminated = false;
        try {
            terminated = executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while waiting for executor {} to terminate", (Object)description);
            Thread.currentThread().interrupt();
        }
        return terminated;
    }
}

