/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.TaskApi;
import com.xebialabs.xlrelease.api.v1.forms.Comment;
import com.xebialabs.xlrelease.api.v1.forms.Condition;
import com.xebialabs.xlrelease.api.v1.forms.StartTask;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.TaskGranularPermissions;
import com.xebialabs.xlrelease.security.authentication.AuthenticationService;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.GateConditionService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.UploadService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class TaskApiImpl
implements TaskApi {
    private static final Logger logger = LoggerFactory.getLogger(TaskApiImpl.class);
    private final ReleaseActorService releaseActorService;
    private final CommentService commentService;
    private final GateConditionService gateConditionService;
    private final TaskRepository taskRepository;
    private final PermissionChecker permissions;
    private final TaskGranularPermissions taskPermissionChecker;
    private final ReleaseService releaseService;
    private final UploadService uploadService;
    private final AuthenticationService authenticationService;

    @Autowired
    public TaskApiImpl(ReleaseActorService releaseActorService, TaskRepository taskRepository, PermissionChecker permissions, TaskGranularPermissions taskPermissionChecker, GateConditionService gateConditionService, UploadService uploadService, ReleaseService releaseService, AuthenticationService authenticationService, CommentService commentService) {
        this.releaseActorService = releaseActorService;
        this.taskRepository = taskRepository;
        this.permissions = permissions;
        this.taskPermissionChecker = taskPermissionChecker;
        this.gateConditionService = gateConditionService;
        this.uploadService = uploadService;
        this.releaseService = releaseService;
        this.authenticationService = authenticationService;
        this.commentService = commentService;
    }

    @Timed
    public List<Attachment> addAttachments(String taskId, HttpServletRequest request) throws IOException {
        this.permissions.checkIsAllowedToEditAttachmentsOnTask(taskId);
        ServletFileUpload upload = new ServletFileUpload();
        upload.setSizeMax((long)XlrConfig.getInstance().server().upload().maxSizeBytes());
        try {
            FileItemIterator fileItems = upload.getItemIterator(request);
            List<Attachment> attachments = this.uploadService.addAttachment(taskId, fileItems);
            if (attachments.isEmpty()) {
                logger.debug("No attachments uploaded caused by incorrect form body");
                throw new BadRequestException("Expected file upload");
            }
            return attachments;
        }
        catch (FileUploadException ex) {
            throw new BadRequestException((Throwable)ex);
        }
    }

    @Timed
    public Attachment addAttachment(String taskId, String fileName, byte[] fileByteArray) throws IOException {
        this.permissions.checkIsAllowedToEditAttachmentsOnTask(taskId);
        return this.uploadService.addAttachment(taskId, fileName, fileByteArray);
    }

    @Timed
    public void deleteAttachment(String taskId, String attachmentId) {
        String releaseId = Ids.releaseIdFrom((String)taskId);
        this.permissions.checkIsAllowedToEditAttachmentsOnTask(taskId);
        this.releaseActorService.deleteAttachmentFromTask(releaseId, taskId, attachmentId);
    }

    @Timed
    public Task getTask(String taskId) {
        this.permissions.checkView(Ids.releaseIdFrom((String)taskId));
        return this.taskRepository.findById(taskId);
    }

    @Timed
    public Task copyTask(String taskId, String targetContainerId, int targetPosition) {
        String releaseId = Ids.releaseIdFrom((String)taskId);
        this.permissions.checkCopyTask(releaseId);
        return this.releaseActorService.copyTask(taskId, targetContainerId, targetPosition);
    }

    @Timed
    public Task updateTask(Task task) {
        return this.updateTask(task.getId(), task);
    }

    @Timed
    public Task updateTask(String taskId, Task task) {
        return this.updateTask(taskId, task, false);
    }

    @Timed
    public Task updateTask(String taskId, Task task, boolean overrideLock) {
        Set<TaskUpdateDirective> directives = this.taskPermissionChecker.getUpdateDirectives(Ids.releaseIdFrom((String)taskId));
        return this.releaseActorService.updateTask(taskId, task, directives, overrideLock);
    }

    @Timed
    public Task changeTaskType(String taskId, String targetType) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)targetType) ? 1 : 0) != 0, (String)"Query parameter targetType must be provided", (Object[])new Object[0]);
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        return this.releaseActorService.changeTaskType(taskId, Type.valueOf((String)targetType));
    }

    @Timed
    public Task addTask(String containerId, Task task) {
        return this.addTask(containerId, task, null);
    }

    @Timed
    public Task addTask(String containerId, Task task, Integer position) {
        String releaseId = Ids.releaseIdFrom((String)containerId);
        this.permissions.checkView(releaseId);
        this.permissions.checkEdit(releaseId);
        this.permissions.checkEditTask(releaseId);
        if (task.isLocked()) {
            this.permissions.checkLockTaskPermission(releaseId);
        }
        if (task.getPrecondition() != null) {
            this.permissions.checkEditPreconditionPermission(releaseId);
        }
        if (task.getFailureHandler() != null || task.isTaskFailureHandlerEnabled() || task.getTaskRecoverOp() != null) {
            this.permissions.checkEditFailureHandlerPermission(releaseId);
        }
        return this.releaseActorService.createTask(containerId, task, position);
    }

    @Timed
    public Task completeTask(String taskId, Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when completing a task.");
        this.permissions.checkRelevantTaskTransitionPermission(taskId);
        Checks.checkArgument((boolean)this.areAllRequiredVariablesSet(taskId), (String)"All required values must be set before completing the task", (Object[])new Object[0]);
        return this.releaseActorService.completeTask(taskId, comment.getComment());
    }

    @Timed
    public Task completeTask(String taskId, String comment) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)comment) ? 1 : 0) != 0, (String)"Comment is mandatory when completing a task.", (Object[])new Object[0]);
        this.permissions.checkRelevantTaskTransitionPermission(taskId);
        Checks.checkArgument((boolean)this.areAllRequiredVariablesSet(taskId), (String)"All required values must be set before completing the task", (Object[])new Object[0]);
        return this.releaseActorService.completeTask(taskId, comment);
    }

    private boolean areAllRequiredVariablesSet(String taskId) {
        Object task = this.taskRepository.findById(taskId);
        return !this.isUserInputTask((Task)task) || ((UserInputTask)task).getVariables().stream().noneMatch(v -> v.getRequiresValue() && v.isValueEmpty());
    }

    private boolean isUserInputTask(Task task) {
        return task instanceof UserInputTask;
    }

    @Timed
    public Task skipTask(String taskId, Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when skipping a task.");
        this.permissions.checkRelevantTaskTransitionPermission(taskId);
        return this.releaseActorService.skipTask(taskId, comment.getComment(), User.AUTHENTICATED_USER);
    }

    @Timed
    public Task skipTask(String taskId, String comment) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)comment) ? 1 : 0) != 0, (String)"Comment is mandatory when skipping a task.", (Object[])new Object[0]);
        this.permissions.checkRelevantTaskTransitionPermission(taskId);
        if (this.authenticationService.hasScriptTask() && this.authenticationService.hasVariablesHolderForScriptContext()) {
            DefaultScriptService.ScriptTaskResults scriptTaskResults = this.authenticationService.getCurrentVariablesHolderForScriptContext().createScriptTaskResults();
            this.releaseActorService.saveScriptResults(taskId, scriptTaskResults);
        }
        return this.releaseActorService.skipTask(taskId, comment, User.AUTHENTICATED_USER);
    }

    @Timed
    public Task failTask(String taskId, Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when failing a task.");
        this.permissions.checkTaskTransitionPermission(taskId);
        return this.releaseActorService.failTaskManually(taskId, comment.getComment());
    }

    @Timed
    public Task failTask(String taskId, String comment) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)comment) ? 1 : 0) != 0, (String)"Comment is mandatory when failing a task.", (Object[])new Object[0]);
        this.permissions.checkTaskTransitionPermission(taskId);
        return this.releaseActorService.failTaskManually(taskId, comment);
    }

    @Timed
    public Task abortTask(String taskId, Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when aborting a task.");
        this.permissions.checkTaskTransitionPermission(taskId);
        Checks.checkArgument((!Strings.isNullOrEmpty((String)comment.getComment()) ? 1 : 0) != 0, (String)"Comment is mandatory when aborting a task.", (Object[])new Object[0]);
        return this.releaseActorService.abortTask(taskId, comment.getComment());
    }

    @Timed
    public Task abortTask(String taskId, String comment) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)comment) ? 1 : 0) != 0, (String)"Comment is mandatory when aborting a task.", (Object[])new Object[0]);
        this.permissions.checkTaskTransitionPermission(taskId);
        return this.releaseActorService.abortTask(taskId, comment);
    }

    @Timed
    public Task retryTask(String taskId, Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when retrying a task.");
        this.permissions.checkTaskTransitionPermission(taskId);
        Checks.checkArgument((!Strings.isNullOrEmpty((String)comment.getComment()) ? 1 : 0) != 0, (String)"Comment is mandatory when retrying a task.", (Object[])new Object[0]);
        return this.releaseActorService.retryTask(taskId, comment.getComment());
    }

    @Timed
    public Task retryTask(String taskId, String comment) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)comment) ? 1 : 0) != 0, (String)"Comment is mandatory when retrying a task.", (Object[])new Object[0]);
        this.permissions.checkTaskTransitionPermission(taskId);
        return this.releaseActorService.retryTask(taskId, comment);
    }

    @Timed
    public Task start(String taskId, Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when starting a pending task.");
        this.permissions.checkIsAllowedToStartTask(taskId);
        return this.releaseActorService.startTask(taskId, comment.getComment());
    }

    @Timed
    public Task start(String taskId, String comment) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)comment) ? 1 : 0) != 0, (String)"Comment is mandatory when starting a pending task.", (Object[])new Object[0]);
        this.permissions.checkIsAllowedToStartTask(taskId);
        return this.releaseActorService.startTask(taskId, comment);
    }

    @Timed
    public Task start(Task task, List<Variable> variables) {
        return this.start(task.getId(), new StartTask(variables));
    }

    @Timed
    public Task start(String taskId, StartTask startTask) {
        this.permissions.checkIsAllowedToWorkOnTask(taskId);
        List taskVariables = startTask.getVariables();
        return this.releaseActorService.startTaskWithInput(taskId, taskVariables);
    }

    @Timed
    public Task reopenTask(String taskId, Comment comment) {
        this.permissions.checkReopenTaskInRelease(Ids.releaseIdFrom((String)taskId));
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when reopening a task.");
        Checks.checkArgument((!Strings.isNullOrEmpty((String)comment.getComment()) ? 1 : 0) != 0, (String)"Comment is mandatory when reopening a task.", (Object[])new Object[0]);
        return this.releaseActorService.reopenTask(taskId, comment.getComment());
    }

    @Timed
    public Task reopenTask(String taskId, String comment) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)comment) ? 1 : 0) != 0, (String)"Comment is mandatory when reopening a task.", (Object[])new Object[0]);
        this.permissions.checkReopenTaskInRelease(Ids.releaseIdFrom((String)taskId));
        return this.releaseActorService.reopenTask(taskId, comment);
    }

    @Timed
    public List<Variable> getVariables(String taskId) {
        Object task = this.taskRepository.findById(taskId);
        this.permissions.checkViewTask((Task)task);
        return task.getInputVariables();
    }

    @Timed
    public Task commentTask(String taskId, Comment comment) {
        this.permissions.checkIsAllowedToCommentOnTask(taskId);
        Object task = this.taskRepository.findById(taskId);
        this.commentService.create((Task)task, comment.getComment(), User.AUTHENTICATED_USER, true);
        return task;
    }

    @Timed
    public Task commentTask(String taskId, String comment) {
        this.permissions.checkIsAllowedToCommentOnTask(taskId);
        Object task = this.taskRepository.findById(taskId);
        this.commentService.create((Task)task, comment, User.AUTHENTICATED_USER, true);
        return task;
    }

    @Timed
    public Task assignTask(String taskId, String username) {
        this.permissions.checkReassignTaskToUser(taskId, username);
        return this.releaseActorService.reassignTaskToOwner(taskId, username);
    }

    @Timed
    public List<Task> searchTasksByTitle(String taskTitle, String phaseTitle, String releaseId) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)taskTitle) ? 1 : 0) != 0, (String)"Query parameter taskTitle must be provided", (Object[])new Object[0]);
        Checks.checkArgument((!Strings.isNullOrEmpty((String)releaseId) ? 1 : 0) != 0, (String)"Query parameter releaseId must be provided", (Object[])new Object[0]);
        Release release = this.releaseService.findById(releaseId);
        this.permissions.checkView(release);
        return release.getTasksByTitle(phaseTitle, taskTitle);
    }

    @Timed
    public Task newTask() {
        return this.newTask("xlrelease.Task");
    }

    @Timed
    public Task newTask(String type) {
        Task task = Task.fromType((String)type);
        task.setTitle("New task");
        return task;
    }

    public Comment newComment(String commentText) {
        return new Comment(commentText);
    }

    @Timed
    public void delete(String taskId) {
        this.permissions.checkEdit(Ids.releaseIdFrom((String)taskId));
        this.releaseActorService.deleteTask(taskId);
    }

    @Timed
    public void deleteDependency(String dependencyId) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)dependencyId));
        String taskId = Ids.getParentId((String)dependencyId);
        TaskBasicData taskBasicData = this.taskRepository.findTaskBasicData(taskId);
        Checks.checkArgument((boolean)this.isGateTask(taskBasicData), (String)("Can only delete a dependency from a GateTask, not a " + taskBasicData.taskType().toString()), (Object[])new Object[0]);
        this.releaseActorService.deleteDependency(taskId, dependencyId);
    }

    @Timed
    public Dependency addDependency(String taskId, String targetId) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        if (!VariableHelper.containsVariables((String)targetId)) {
            this.permissions.checkView(Ids.releaseIdFrom((String)targetId));
        }
        TaskBasicData taskBasicData = this.taskRepository.findTaskBasicData(taskId);
        Checks.checkArgument((boolean)this.isGateTask(taskBasicData), (String)("Can only add a dependency to a GateTask, not a " + taskBasicData.taskType().toString()), (Object[])new Object[0]);
        return this.releaseActorService.createDependency(taskId, targetId);
    }

    @Timed
    public GateCondition addCondition(String taskId, Condition condition) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        TaskBasicData taskBasicData = this.taskRepository.findTaskBasicData(taskId);
        Checks.checkArgument((boolean)this.isGateTask(taskBasicData), (String)("Can only add a condition to a GateTask, not a " + taskBasicData.taskType().toString()), (Object[])new Object[0]);
        GateCondition gateCondition = this.releaseActorService.createGateCondition(taskId);
        gateCondition.setTitle(condition.getTitle());
        gateCondition.setChecked(condition.isChecked());
        return this.releaseActorService.updateGateCondition(gateCondition.getId(), gateCondition);
    }

    @Timed
    public GateCondition updateCondition(String conditionId, Condition condition) {
        String gateId = Ids.getParentId((String)conditionId);
        this.permissions.checkIsAllowedToWorkOnTask(gateId);
        GateCondition previousCondition = this.gateConditionService.findById(conditionId);
        previousCondition.setChecked(condition.isChecked());
        if (!Objects.equal((Object)previousCondition.getTitle(), (Object)condition.getTitle())) {
            this.permissions.checkEditTask(Ids.releaseIdFrom((String)conditionId));
            previousCondition.setTitle(condition.getTitle());
        }
        return this.releaseActorService.updateGateCondition(conditionId, previousCondition);
    }

    @Timed
    public GateCondition updateCondition(GateCondition condition) {
        return this.releaseActorService.updateGateCondition(condition.getId(), condition);
    }

    @Timed
    public void deleteCondition(String conditionId) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)conditionId));
        this.releaseActorService.deleteGateCondition(conditionId);
    }

    @Timed
    public void lockTask(String taskId) {
        this.permissions.checkLockTaskPermission(Ids.releaseIdFrom((String)taskId));
        this.releaseActorService.lockTask(taskId);
    }

    @Timed
    public void unlockTask(String taskId) {
        this.permissions.checkLockTaskPermission(Ids.releaseIdFrom((String)taskId));
        this.releaseActorService.unlockTask(taskId);
    }

    private boolean isGateTask(TaskBasicData task) {
        return task.taskType().instanceOf(Type.valueOf((String)"xlrelease.GateTask"));
    }
}

