/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.principaldata;

import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetailsServiceImpl;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.principaldata.UserDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class CrowdUserDataProvider
implements UserDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(CrowdUserDataProvider.class);
    private final CrowdUserDetailsServiceImpl crowdUserDetailsServiceImpl;

    public CrowdUserDataProvider(CrowdUserDetailsServiceImpl crowdUserDetailsService) {
        this.crowdUserDetailsServiceImpl = crowdUserDetailsService;
    }

    @Override
    public UserData getUserData(String username) {
        try {
            CrowdUserDetails crowdUserDetails = this.crowdUserDetailsServiceImpl.loadUserByUsername(username);
            if (crowdUserDetails == null) {
                return UserData.NOT_FOUND;
            }
            String email = crowdUserDetails.getEmail();
            String fullName = crowdUserDetails.getFullName();
            logger.info("Email: {} and displayName: {} have been read from Crowd", (Object)email, (Object)fullName);
            return new UserData(email, fullName);
        }
        catch (UsernameNotFoundException e) {
            logger.info("User with username: {} not found", (Object)username);
            return UserData.NOT_FOUND;
        }
        catch (DataAccessException e) {
            logger.warn("Could not get data from Crowd Server for User with username: {}", (Object)username);
            return UserData.NOT_FOUND;
        }
        catch (Exception e) {
            logger.warn("Error accessing Crowd server", (Throwable)e);
            return UserData.NOT_FOUND;
        }
    }
}

