/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.configuration.ArchivingSettings;
import com.xebialabs.xlrelease.configuration.AuditReportSettings;
import com.xebialabs.xlrelease.configuration.CustomLogoSettings;
import com.xebialabs.xlrelease.configuration.FeatureSettings;
import com.xebialabs.xlrelease.configuration.PollingSettings;
import com.xebialabs.xlrelease.configuration.ReportsSettings;
import com.xebialabs.xlrelease.configuration.ThemeColor;
import com.xebialabs.xlrelease.configuration.ThemeColors$;
import com.xebialabs.xlrelease.configuration.ThemeSettings;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Mc\u0001B\b\u0011\u0001eA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!)a\u0007\u0001C\u0001o!)A\b\u0001C\u0001{!)A\b\u0001C\u0001=\")Q\r\u0001C\u0001M\")\u0001\u000e\u0001C\u0001S\")q\u000e\u0001C\u0001a\")1\u000f\u0001C\u0001i\")1\u0010\u0001C\u0005y\"1q\u0010\u0001C\u0001\u0003\u0003Aq!a\u0004\u0001\t\u0003\t\t\u0002C\u0004\u0002\u0010\u0001!\t!a\u000b\t\u000f\u0005M\u0002\u0001\"\u0001\u00026\t!2i\u001c8gS\u001e,(/\u0019;j_:\u001cVM\u001d<jG\u0016T!!\u0005\n\u0002\u000fM,'O^5dK*\u00111\u0003F\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0006\f\u0002\u0013a,'-[1mC\n\u001c(\"A\f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Q\u0002\u0005\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VM\u001a\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nQa\u001d7gi)T\u0011!J\u0001\tOJL'P\u001f7fI&\u0011qE\t\u0002\b\u0019><w-\u001b8h\u0003]\u0019wN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002+[5\t1F\u0003\u0002-%\u0005Q!/\u001a9pg&$xN]=\n\u00059Z#aF\"p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z\u0003!)g/\u001a8u\u0005V\u001c\bCA\u00195\u001b\u0005\u0011$BA\u001a\u0013\u0003\u0019)g/\u001a8ug&\u0011QG\r\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018A\u0002\u001fj]&$h\bF\u00029um\u0002\"!\u000f\u0001\u000e\u0003AAQ\u0001K\u0002A\u0002%BQaL\u0002A\u0002A\nab\u0019:fCR,wJ]+qI\u0006$X\rF\u0002?\tF\u0003\"a\u0010\"\u000e\u0003\u0001S!!\u0011\n\u0002\r\u0011|W.Y5o\u0013\t\u0019\u0005IA\tCCN,7i\u001c8gS\u001e,(/\u0019;j_:DQ!\u0012\u0003A\u0002\u0019\u000b!!\u001b3\u0011\u0005\u001dseB\u0001%M!\tIE$D\u0001K\u0015\tY\u0005$\u0001\u0004=e>|GOP\u0005\u0003\u001br\ta\u0001\u0015:fI\u00164\u0017BA(Q\u0005\u0019\u0019FO]5oO*\u0011Q\n\b\u0005\u0006%\u0012\u0001\rAP\u0001\u0012G>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0007F\u0001\u0003U!\t)F,D\u0001W\u0015\t9\u0006,\u0001\u0006b]:|G/\u0019;j_:T!!\u0017.\u0002\u000f5,GO]5dg*\u00111LF\u0001\tG>$\u0017\r[1mK&\u0011QL\u0016\u0002\u0006)&lW\r\u001a\u000b\u0003?\n\u0004\"a\u00071\n\u0005\u0005d\"\u0001B+oSRDQaY\u0003A\u0002y\nQbY8oM&<WO]1uS>t\u0007FA\u0003U\u0003\u0011\u0011X-\u00193\u0015\u0005y:\u0007\"B#\u0007\u0001\u00041\u0015AB3ySN$8\u000f\u0006\u0002k[B\u00111d[\u0005\u0003Yr\u0011qAQ8pY\u0016\fg\u000eC\u0003F\u000f\u0001\u0007a\t\u000b\u0002\b)\u00061A-\u001a7fi\u0016$\"aX9\t\u000b\u0015C\u0001\u0019\u0001$)\u0005!!\u0016\u0001E4fiRCW-\\3TKR$\u0018N\\4t+\u0005)\bC\u0001<y\u001b\u00059(BA2\u0013\u0013\tIxOA\u0007UQ\u0016lWmU3ui&twm\u001d\u0015\u0003\u0013Q\u000bacY8om\u0016\u0014HoQ8m_Jt\u0015-\\3U_\u000e{G-\u001a\u000b\u0003kvDQA \u0006A\u0002U\fQ\u0002\u001e5f[\u0016\u001cV\r\u001e;j]\u001e\u001c\u0018AD:bm\u0016\u001cUo\u001d;p[2{wm\u001c\u000b\u0005\u0003\u0007\tI\u0001E\u0002w\u0003\u000bI1!a\u0002x\u0005I\u0019Uo\u001d;p[2{wm\\*fiRLgnZ:\t\u000f\u0005-1\u00021\u0001\u0002\u0004\u0005\u00112-^:u_6dunZ8TKR$\u0018N\\4tQ\tYA+\u0001\nhKR4U-\u0019;ve\u0016\u001cV\r\u001e;j]\u001e\u001cHCAA\n!\u0019\t)\"a\b\u0002$5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0003vi&d'BAA\u000f\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0012q\u0003\u0002\u0005\u0019&\u001cH\u000fE\u0002w\u0003KI1!a\nx\u0005=1U-\u0019;ve\u0016\u001cV\r\u001e;j]\u001e\u001c\bF\u0001\u0007U)\u0011\t\u0019#!\f\t\r\u0005=R\u00021\u0001G\u0003-1W-\u0019;ve\u0016$\u0016\u0010]3)\u00055!\u0016aE:bm\u00164U-\u0019;ve\u0016\u001cV\r\u001e;j]\u001e\u001cHcA0\u00028!9\u0011\u0011\b\bA\u0002\u0005M\u0011\u0001\u00034fCR,(/Z:)\u00059!\u0006f\u0001\u0001\u0002@A!\u0011\u0011IA(\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013AC:uKJ,w\u000e^=qK*!\u0011\u0011JA&\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA'\u0003\ry'oZ\u0005\u0005\u0003#\n\u0019EA\u0004TKJ4\u0018nY3")
public class ConfigurationService
implements Logging {
    private final ConfigurationRepository configurationRepository;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ConfigurationService configurationService = this;
        synchronized (configurationService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public BaseConfiguration createOrUpdate(String id, BaseConfiguration configurationItem) {
        BaseConfiguration baseConfiguration = configurationItem;
        if (baseConfiguration instanceof ReportsSettings) {
            ReportsSettings reportsSettings = (ReportsSettings)baseConfiguration;
            reportsSettings.validate();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseConfiguration instanceof ArchivingSettings) {
            ArchivingSettings archivingSettings = (ArchivingSettings)baseConfiguration;
            archivingSettings.validate();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseConfiguration instanceof PollingSettings) {
            PollingSettings pollingSettings = (PollingSettings)baseConfiguration;
            pollingSettings.validate();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseConfiguration instanceof ThemeSettings) {
            ThemeSettings themeSettings = (ThemeSettings)baseConfiguration;
            themeSettings.setHeaderAccentColor(((Enum)ThemeColors$.MODULE$.themeColorFromCode().apply((Object)themeSettings.getHeaderAccentColor().toUpperCase())).name());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseConfiguration instanceof AuditReportSettings) {
            AuditReportSettings auditReportSettings = (AuditReportSettings)baseConfiguration;
            auditReportSettings.validate();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        configurationItem.setId(id);
        this.createOrUpdate(configurationItem);
        return this.read(id);
    }

    @Timed
    public void createOrUpdate(BaseConfiguration configuration) {
        if (!Ids.isNullId((String)configuration.getId()) && this.configurationRepository.exists(configuration.getId())) {
            Object original = this.configurationRepository.read(configuration.getId());
            PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)new Some(original), (ConfigurationItem)configuration);
            this.configurationRepository.update(configuration);
            this.eventBus.publish((XLReleaseEvent)new ConfigurationUpdatedEvent(configuration));
        } else {
            this.configurationRepository.create(configuration);
            this.eventBus.publish((XLReleaseEvent)new ConfigurationCreatedEvent(configuration));
        }
    }

    public BaseConfiguration read(String id) {
        Object object;
        Object baseConfiguration = this.configurationRepository.read(id);
        Object t = baseConfiguration;
        if (t instanceof ThemeSettings) {
            ThemeSettings themeSettings = (ThemeSettings)t;
            object = this.convertColorNameToCode(themeSettings);
        } else {
            object = t;
        }
        return object;
    }

    @Timed
    public boolean exists(String id) {
        return this.configurationRepository.exists(id);
    }

    @Timed
    public void delete(String id) {
        Object conf = this.configurationRepository.read(id);
        this.configurationRepository.delete(id);
        this.eventBus.publish((XLReleaseEvent)new ConfigurationDeletedEvent(conf));
    }

    @Timed
    public ThemeSettings getThemeSettings() {
        ThemeSettings themeSettings = this.configurationRepository.getThemeSettings();
        return this.convertColorNameToCode(themeSettings);
    }

    private ThemeSettings convertColorNameToCode(ThemeSettings themeSettings) {
        themeSettings.setHeaderAccentColor(ThemeColors$.MODULE$.colorCode(ThemeColor.valueOf((String)themeSettings.getHeaderAccentColor().toUpperCase())));
        return themeSettings;
    }

    @Timed
    public CustomLogoSettings saveCustomLogo(CustomLogoSettings customLogoSettings) {
        customLogoSettings.validateContentType();
        return (CustomLogoSettings)this.createOrUpdate("Configuration/settings/CustomLogoSettings", (BaseConfiguration)customLogoSettings);
    }

    @Timed
    public List<FeatureSettings> getFeatureSettings() {
        Buffer features = CollectionConverters$.MODULE$.ListHasAsScala(this.configurationRepository.findAllByType(Type.valueOf(FeatureSettings.class))).asScala();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(FeatureSettings.class))).asScala().map((Function1 & Serializable)featureType -> (FeatureSettings)features.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigurationService.$anonfun$getFeatureSettings$2(featureType, x$1))).getOrElse((Function0 & Serializable)() -> {
            void var1_1;
            FeatureSettings feature = (FeatureSettings)featureType.getDescriptor().newInstance("");
            feature.generateId();
            return var1_1;
        }))).toList().sortBy((Function1 & Serializable)x$2 -> x$2.getType().getDescriptor().getLabel(), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public FeatureSettings getFeatureSettings(String featureType) {
        void var2_2;
        Optional<void> optional = this.configurationRepository.findFirstByType(Type.valueOf((String)featureType));
        FeatureSettings feature = (FeatureSettings)Type.valueOf((String)featureType).getDescriptor().newInstance("");
        feature.generateId();
        return (FeatureSettings)optional.orElse(var2_2);
    }

    @Timed
    public void saveFeatureSettings(List<FeatureSettings> features) {
        CollectionConverters$.MODULE$.ListHasAsScala(features).asScala().foreach((Function1 & Serializable)configuration -> {
            this.createOrUpdate(configuration);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getFeatureSettings$2(Type featureType$1, FeatureSettings x$1) {
        Type type = x$1.getType();
        Type type2 = featureType$1;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public ConfigurationService(ConfigurationRepository configurationRepository, XLReleaseEventBus eventBus) {
        this.configurationRepository = configurationRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

