/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.domain.events.UserTokenCreatedEvent;
import com.xebialabs.xlrelease.domain.events.UserTokenDeletedEvent;
import com.xebialabs.xlrelease.domain.events.UserTokensDeletedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.UserTokenRepository;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import com.xebialabs.xlrelease.utils.TokenGenerator$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001\u0002\u0007\u000e\u0001YA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!)1\u0007\u0001C\u0001i!)\u0011\b\u0001C\u0001u!)1\f\u0001C\u00019\")1\r\u0001C\u0001I\")q\r\u0001C\u0001Q\")1\u0010\u0001C\u0001y\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u0011\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003c\u0001A\u0011BA\u001a\u0005A)6/\u001a:U_.,gnU3sm&\u001cWM\u0003\u0002\u000f\u001f\u000591/\u001a:wS\u000e,'B\u0001\t\u0012\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0013'\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002)\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aF\u000f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g!\tq2%D\u0001 \u0015\t\u0001\u0013%A\u0003tY\u001a$$NC\u0001#\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u0013 \u0005\u001daunZ4j]\u001e\f\u0001\"\u001a<f]R\u0014Uo\u001d\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S=\ta!\u001a<f]R\u001c\u0018BA\u0016)\u0005!)e/\u001a8u\u0005V\u001c\u0018aE;tKJ$vn[3o%\u0016\u0004xn]5u_JL\bC\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0010\u0003)\u0011X\r]8tSR|'/_\u0005\u0003e=\u00121#V:feR{7.\u001a8SKB|7/\u001b;pef\fa\u0001P5oSRtDcA\u001b8qA\u0011a\u0007A\u0007\u0002\u001b!)Qe\u0001a\u0001M!)Af\u0001a\u0001[\u0005y1M]3bi\u0016,6/\u001a:U_.,g\u000eF\u0002<\u0003:\u0003\"\u0001P \u000e\u0003uR!AP\b\u0002\r\u0011|W.Y5o\u0013\t\u0001UHA\u0005Vg\u0016\u0014Hk\\6f]\")!\t\u0002a\u0001\u0007\u0006AQo]3s]\u0006lW\r\u0005\u0002E\u0017:\u0011Q)\u0013\t\u0003\rfi\u0011a\u0012\u0006\u0003\u0011V\ta\u0001\u0010:p_Rt\u0014B\u0001&\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011A*\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)K\u0002\"B(\u0005\u0001\u0004\u0019\u0015!\u0003;pW\u0016tgj\u001c;fQ\t!\u0011\u000b\u0005\u0002S36\t1K\u0003\u0002U+\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005Y;\u0016aB7fiJL7m\u001d\u0006\u00031N\t\u0001bY8eC\"\fG.Z\u0005\u00035N\u0013Q\u0001V5nK\u0012\fq\u0002Z3mKR,Wk]3s)>\\WM\u001c\u000b\u0003;\u0002\u0004\"\u0001\u00070\n\u0005}K\"\u0001B+oSRDQ!Y\u0003A\u0002m\n\u0011\"^:feR{7.\u001a8)\u0005\u0015\t\u0016A\u00053fY\u0016$X-\u00117m+N,'\u000fV8lK:$\"!X3\t\u000b\t3\u0001\u0019A\")\u0005\u0019\t\u0016\u0001\u00024j]\u0012$2!\u001b;v!\rQ'oO\u0007\u0002W*\u0011a\b\u001c\u0006\u0003[:\fA\u0001Z1uC*\u0011q\u000e]\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0011/A\u0002pe\u001eL!a]6\u0003\tA\u000bw-\u001a\u0005\u0006\u0005\u001e\u0001\ra\u0011\u0005\u0006m\u001e\u0001\ra^\u0001\ta\u0006<W-\u00192mKB\u0011!\u000e_\u0005\u0003s.\u0014\u0001\u0002U1hK\u0006\u0014G.\u001a\u0015\u0003\u000fE\u000b1BZ5oI\nK8)[+jIR\u0019Q0!\u0001\u0011\u0007aq8(\u0003\u0002\u00003\t1q\n\u001d;j_:Dq!a\u0001\t\u0001\u0004\t)!A\u0003dSVKG\r\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001f\tAA[1wC&!\u00111CA\u0005\u0005\u001dIe\u000e^3hKJD#\u0001C)\u0002\u001f\u0019Lg\u000e\u001a\"z+N,'\u000fV8lK:$2!`A\u000e\u0011\u0019\ti\"\u0003a\u0001\u0007\u0006IAo\\6f]\"\u000b7\u000f\u001b\u0015\u0003\u0013E\u000bq\"^:feR{7.\u001a8Fq&\u001cHo\u001d\u000b\u0007\u0003K\tY#!\f\u0011\u0007a\t9#C\u0002\u0002*e\u0011qAQ8pY\u0016\fg\u000eC\u0003C\u0015\u0001\u00071\tC\u0003P\u0015\u0001\u00071\t\u000b\u0002\u000b#\u0006A\u0002/\u001e2mSNDGk\\6f]\u000e\u0013X-\u0019;fI\u00163XM\u001c;\u0015\u0007u\u000b)\u0004C\u0003b\u0017\u0001\u00071\b")
public class UserTokenService
implements Logging {
    private final EventBus eventBus;
    private final UserTokenRepository userTokenRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        UserTokenService userTokenService = this;
        synchronized (userTokenService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public UserToken createUserToken(String username, String tokenNote) {
        String token = TokenGenerator$.MODULE$.generate();
        UserToken userToken = new UserToken();
        userToken.tokenNote_$eq(tokenNote);
        userToken.username_$eq(username);
        userToken.createdDate_$eq(new Date());
        Integer ciUid = this.userTokenRepository.create(userToken, TokenGenerator$.MODULE$.hash(token));
        userToken.ciUid_$eq(ciUid);
        userToken.token_$eq(token);
        this.publishTokenCreatedEvent(userToken);
        return userToken;
    }

    @Timed
    public void deleteUserToken(UserToken userToken) {
        this.userTokenRepository.delete(userToken.ciUid());
        this.eventBus.publish((XLReleaseEvent)new UserTokenDeletedEvent(userToken));
    }

    @Timed
    public void deleteAllUserToken(String username) {
        if (!Strings.isNotBlank((String)username)) {
            throw new IllegalArgumentException("Username can't be blank");
        }
        this.userTokenRepository.delete(username);
        this.eventBus.publish((XLReleaseEvent)new UserTokensDeletedEvent(username));
    }

    @Timed
    public Page<UserToken> find(String username, Pageable pageable) {
        return this.userTokenRepository.query(username, pageable);
    }

    @Timed
    public Option<UserToken> findByCiUid(Integer ciUid) {
        return this.userTokenRepository.findByCiUid(ciUid);
    }

    @Timed
    public Option<UserToken> findByUserToken(String tokenHash) {
        return this.userTokenRepository.findByUserToken(tokenHash);
    }

    @Timed
    public boolean userTokenExists(String username, String tokenNote) {
        boolean bl;
        Option<UserToken> option = this.userTokenRepository.findByUserAndNote(username, tokenNote);
        if (option instanceof Some) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(54).append("Personal access token was found with user[").append(username).append("] and note[").append(tokenNote).append("]").toString());
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(58).append("Personal access token was not found with user[").append(username).append("] and note[").append(tokenNote).append("]").toString());
            bl = false;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    private void publishTokenCreatedEvent(UserToken userToken) {
        UserToken userTokenForEvent = CiCloneHelper.cloneCi(userToken);
        userTokenForEvent.token_$eq(PasswordVerificationUtils$.MODULE$.PASSWORD_MASK());
        this.eventBus.publish((XLReleaseEvent)new UserTokenCreatedEvent(userTokenForEvent));
    }

    public UserTokenService(EventBus eventBus, UserTokenRepository userTokenRepository) {
        this.eventBus = eventBus;
        this.userTokenRepository = userTokenRepository;
        Logging.$init$((Logging)this);
    }
}

