/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Environment {
    public static final String PLUGIN_WEB_FOLDER = "web/include";
    public static final String MAIN_RESOURCE_FOLDER = "src/main/resources";
    public static final String MAIN_WEB_FOLDER = "src/main/resources/web";
    public static final File WEB_PATH_SRC = new File("../core/xlr-ui/app/");
    public static final File WEB_PATH_BUILD = new File("../core/xlr-ui/build/web/");
    public static final File SERVER_RESOURCES_PATH = new File("../core/xlr-ui/resources/");
    public static final File DEV_PLUGINS_PATH = new File("src/main/resources/web");
    public static final File[] BUNDLED_PLUGIN_PATHS = Environment.collectPluginPaths("../plugins", "../modules").toArray(new File[16]);
    public static final File DEV_PLUGINS_CONVERTED_JS = new File("../core/xlr-ui/build/web/xlrelease-plugins.js");
    public static final File DEV_PLUGINS_CONVERTED_CSS = new File("../core/xlr-ui/build/web/xlrelease-plugins.css");
    public static final String PRD_PLUGINS_CONVERTED_JS = "web/xlrelease-plugins.js";
    public static final String PRD_PLUGINS_CONVERTED_CSS = "web/xlrelease-plugins.css";
    public static final String DEFAULT_SPRING_CONFIG = "classpath:spring/xlrelease-context.xml,classpath*:hotfix-context.xml";
    public static final String DEVMODE = "RELEASEITDEVMODE";

    public static boolean isProduction() {
        return System.getenv(DEVMODE) == null;
    }

    public static boolean isDevelopment() {
        return !Environment.isProduction();
    }

    public static String getSpringConfig() {
        return DEFAULT_SPRING_CONFIG;
    }

    private static List<File> collectPluginPaths(String ... basePaths) {
        if (Environment.isProduction()) {
            return Collections.emptyList();
        }
        ArrayList<File> paths = new ArrayList<File>();
        try {
            for (String basePath : basePaths) {
                try (Stream<File> fileStream = Files.find(Paths.get(basePath, new String[0]), 16, (path, attr) -> path.endsWith(MAIN_RESOURCE_FOLDER) || path.endsWith(MAIN_WEB_FOLDER), FileVisitOption.FOLLOW_LINKS).map(Path::toFile);){
                    paths.addAll(fileStream.collect(Collectors.toList()));
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to collect plugin paths.", e);
        }
        return paths;
    }
}

