/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Whitelist;

@Provider
@PreMatching
public class XSSContainerRequestFilter
implements ContainerRequestFilter {
    private static final Whitelist whitelist = Whitelist.basic();

    public void filter(ContainerRequestContext requestContext) throws IOException {
        this.cleanQueryParamsAndPath(requestContext);
        if (!this.isMediaTypeMultipartForm(requestContext)) {
            this.cleanBody(requestContext);
        }
    }

    private void cleanBody(ContainerRequestContext requestContext) throws IOException {
        String body = IOUtils.toString((InputStream)requestContext.getEntityStream(), (Charset)StandardCharsets.UTF_8);
        requestContext.setEntityStream(IOUtils.toInputStream((String)XSSContainerRequestFilter.sanitize(body), (Charset)StandardCharsets.UTF_8));
    }

    private void cleanQueryParamsAndPath(ContainerRequestContext requestContext) throws IOException {
        String clearPath;
        UriBuilder requestUriBuilder = requestContext.getUriInfo().getRequestUriBuilder();
        MultivaluedMap queries = requestContext.getUriInfo().getQueryParameters();
        String path = URLDecoder.decode(requestContext.getUriInfo().getPath(), StandardCharsets.UTF_8.name());
        if (!path.equals(clearPath = XSSContainerRequestFilter.sanitize(path))) {
            requestUriBuilder.replacePath(clearPath);
        }
        queries.forEach((key, values) -> {
            Object[] sanitizedQueryString = values.stream().map(XSSContainerRequestFilter::sanitize).toArray(Object[]::new);
            requestUriBuilder.replaceQueryParam(key, sanitizedQueryString);
        });
        requestContext.setRequestUri(requestUriBuilder.build(new Object[0]));
    }

    private boolean isMediaTypeMultipartForm(ContainerRequestContext requestContext) {
        return requestContext.getMediaType() != null && this.convertMediaTypeToString(requestContext.getMediaType()).equals("multipart/form-data");
    }

    private String convertMediaTypeToString(MediaType mediaType) {
        return String.format("%s/%s", mediaType.getType(), mediaType.getSubtype());
    }

    private static String sanitize(String input) {
        Document document = Jsoup.parseBodyFragment((String)input);
        document = new Cleaner(whitelist).clean(document);
        return document.body().wholeText();
    }
}

