package com.xebialabs.deployit.plumbing;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import javax.ws.rs.core.MediaType;

import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.serialization.MetadataIncludingCiConverter;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;

public abstract class AbstractConfigurationItemReaderWriter {
    protected static final String LEVEL = "level";

    protected XlrFormatFactory formats;
    protected Repository repository;
    protected ConfigurationRepository configurationRepository;

    public AbstractConfigurationItemReaderWriter(RepositoryFactory repositoryFactory, XlrFormatFactory formats, ConfigurationRepository configurationRepository) {
        this.repository = repositoryFactory.create();
        this.formats = formats;
        this.configurationRepository = configurationRepository;
    }

    protected ConfigurationItemConverter createConverter() {
        return new MetadataIncludingCiConverter(configurationRepository, null);
    }

    protected int getCiRefsFromLevel() {
        int level = 0;
        Object levelParam = RequestLocal.getMap().get(LEVEL);
        if (levelParam != null) {
            level = (Integer) levelParam;
        }

        return level;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = getClassFromGenericType(genericType);
        }
        return ConfigurationItem.class.isAssignableFrom(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return isReadable(type, genericType, annotations, mediaType);
    }

    static Class<?> getClassFromGenericType(Type genericType) {
        Type declaredType = ((ParameterizedType) genericType).getActualTypeArguments()[0];
        Class<?> type;
        if (declaredType instanceof WildcardType) {
            type = (Class<?>) ((WildcardType) declaredType).getUpperBounds()[0];
        } else {
            type = (Class<?>) declaredType;
        }
        return type;
    }
}
