package com.xebialabs.deployit.plumbing;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

import com.xebialabs.deployit.booter.local.utils.Strings;

public class IgnoreArrayEmptyValues extends JsonDeserializer<List<String>> {

    @Override
    @SuppressWarnings("unchecked")
    public List<String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        List<String> value = jsonParser.readValueAs(List.class);
        return value.stream().filter(Strings::isNotBlank).collect(Collectors.toList());
    }
}