package com.xebialabs.deployit.plumbing

import com.fasterxml.jackson.databind.ObjectMapper
import com.xebialabs.deployit.plumbing.ResteasyObjectMapperResolver.{MapperMapping, PackageNames}
import grizzled.slf4j.Logging

import java.util
import javax.ws.rs.core.MediaType
import javax.ws.rs.ext.{ContextResolver, Provider}
import javax.ws.rs.{Consumes, Produces}
import scala.jdk.CollectionConverters._

/**
 * Maps custom alternative object mappers for the list of packages provided as list of strings.
 */
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
@Consumes(Array(MediaType.APPLICATION_JSON))
class ResteasyObjectMapperResolver(objectMapper: ObjectMapper, customMapping: MapperMapping = Map[ObjectMapper, PackageNames]().asJava)
  extends ContextResolver[ObjectMapper] with Logging {

  private val packageNameMapping = customMapping.asScala.flatMap {
    case (k, v) => v.asScala.map(_ -> k)
  }

  override def getContext(typeClazz: Class[_]): ObjectMapper = {
    val packageName: String = typeClazz.getPackageName
    val alternativeMapper = for {
      e <- packageNameMapping.find { case (mappedPackage, _) => mappedPackage == packageName }
    } yield e._2
    val foundMapper = alternativeMapper.getOrElse(objectMapper)
    logger.trace(s"Using $foundMapper for $packageName")
    foundMapper
  }

}

object ResteasyObjectMapperResolver {
  type PackageNames = util.List[String]
  type MapperMapping = util.Map[ObjectMapper, PackageNames]
}