package com.xebialabs.deployit.plumbing.xltype.serialization.json;

import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Map;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;

import com.xebialabs.xlrelease.api.internal.InternalMetadata;
import com.xebialabs.xlrelease.serialization.json.utils.JsonWithCachedProvider;
import com.xebialabs.xlrelease.serialization.json.xltype.CiJson2Writer;
import com.xebialabs.xltype.serialization.SerializationException;

public class MetadataIncludingCiJsonWriter extends CiJson2Writer {

    private final ObjectMapper objectMapper;

    public MetadataIncludingCiJsonWriter(final Writer writer, ObjectMapper objectMapper) {
        super(writer);
        this.objectMapper = objectMapper;
    }

    public void writeInternalMetadata(Map<String, InternalMetadata> metadata) {
        if (metadata != null && !metadata.isEmpty()) {
            String metadataAsString = null;
            try {
                ObjectWriter ow = objectMapper.writer().withDefaultPrettyPrinter();
                metadataAsString = ow.writeValueAsString(metadata);
                try (Reader reader = new StringReader(metadataAsString);
                     JsonReader jsonReader = JsonWithCachedProvider.createReader(reader)) {
                    JsonObject metadataAsJsonObject = jsonReader.readObject();
                    json.write("$metadata", metadataAsJsonObject);
                }
            } catch (JsonProcessingException e) {
                throw new SerializationException("Could not serialize $metadata of a CI: " + metadata, e);
            } catch (Exception e) {
                throw new SerializationException("Could not serialize $metadata of a CI: " + metadataAsString, e);
            }
        }
    }
}
