package com.xebialabs.xlrelease.actors.kryoserializers

import com.esotericsoftware.kryo.io.{Input, Output}
import com.esotericsoftware.kryo.{Kryo, Serializer}
import com.xebialabs.xlrelease.repository.proxy.{CiReferenceProxyFactory, ResolvableConfigurationItemReference, ResolvableLazyConfigurationItem}
import com.xebialabs.xlrelease.serialization.json.repository.ResolverRepository
import com.xebialabs.xlrelease.service.ServiceStarter
import com.xebialabs.xlrelease.support.akka.spring.ScalaSpringSupport
import org.springframework.context.{ApplicationContext, ApplicationContextAware, SmartLifecycle}

import scala.beans.BeanProperty


object ResolvableLazyConfigurationItemSerializer extends Serializer[ResolvableLazyConfigurationItem]
  with ScalaSpringSupport with ApplicationContextAware with SmartLifecycle {

  private lazy val proxyFactory: CiReferenceProxyFactory = springBean[CiReferenceProxyFactory]
  private lazy val resolverRepository: ResolverRepository = springBean[ResolverRepository]

  @BeanProperty
  var applicationContext: ApplicationContext = _

  override def write(kryo: Kryo, output: Output, objectInstance: ResolvableLazyConfigurationItem): Unit = {
    val resolvableLazyConfigurationItem = objectInstance
    val resolvableLazyConfigurationItemReference = resolvableLazyConfigurationItem.get$resolvableConfigurationItemReference()
    kryo.writeObject(output, resolvableLazyConfigurationItemReference)
  }

  override def read(kryo: Kryo, input: Input, objectType: Class[ResolvableLazyConfigurationItem]): ResolvableLazyConfigurationItem = {
    val resolvableConfigurationItemReference = kryo.readObject(input, classOf[ResolvableConfigurationItemReference])
    proxyFactory.proxy(resolverRepository, resolvableConfigurationItemReference).asInstanceOf[ResolvableLazyConfigurationItem]
  }

  override def start(): Unit = ()

  override def stop(): Unit = ()

  override def isRunning: Boolean = true

  // make sure serializer has application context populated before we access it as a Scala object in KryoInit
  override def getPhase(): Int = ServiceStarter.LIFECYCLE_PHASE - 1
}
