package com.xebialabs.xlrelease.api.internal

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalAndFolderVariablesDecorator.GLOBAL_AND_FOLDER_VARIABLES
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.variables.{FolderVariables, GlobalVariables}
import com.xebialabs.xlrelease.repository.{FolderVariableRepository, Ids}
import com.xebialabs.xlrelease.service.VariableService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util
import scala.collection.mutable
import scala.jdk.CollectionConverters._

object ReleaseGlobalAndFolderVariablesDecorator {
  val GLOBAL_AND_FOLDER_VARIABLES = "globalAndFolderVariables"
}

case class ReleaseGlobalAndFolderVariablesDecoratorCache(globalVariables: GlobalVariables, folderVariables: mutable.Map[String, FolderVariables])

@Component
class ReleaseGlobalAndFolderVariablesDecorator @Autowired()(variableService: VariableService, folderVariableRepository: FolderVariableRepository)
  extends CachedInternalMetadataDecorator[Release, ReleaseGlobalAndFolderVariablesDecoratorCache] {

  override def isApplicableTo(ci: ConfigurationItem): Boolean = ci.isInstanceOf[Release]

  override val name: String = GLOBAL_AND_FOLDER_VARIABLES

  override def decorate(cis: util.Collection[Release], cache: DecoratorCache[ReleaseGlobalAndFolderVariablesDecoratorCache]): Unit = {
    val cached = cache.computeIfAbsent(() => {
      ReleaseGlobalAndFolderVariablesDecoratorCache(variableService.findGlobalVariablesOrEmpty(), mutable.Map[String, FolderVariables]())
    })
    val globalVariables: GlobalVariables = cached.globalVariables
    cis.asScala.foreach { release =>
      release.setGlobalVariables(globalVariables)
      // Folder variables
      val maybeFolderId: String = release.findFolderId
      if (Ids.isFolderId(maybeFolderId)) {
        if (!cached.folderVariables.contains(maybeFolderId)) {
          cached.folderVariables.put(maybeFolderId, new FolderVariables(maybeFolderId, folderVariableRepository.getAllFromAncestry(maybeFolderId)))
        }
        release.setFolderVariables(cached.folderVariables(maybeFolderId))
      }
    }
  }
}
