/**
 * <p>These are the public REST services exposed by the Digital.ai Release server.</p>
 *
 * <p>You can access the REST API via a URL of the form {@code http://[host]:[port]/[context-root]/[service-resource]}.</p>
 * <p>For example:</p>
 * <p>{@code GET http://localhost:5516/api/v1/templates/Applications/Release2994650}</p>
 * <p>{@code GET http://localhost:5516/api/v1/templates/Applications/Folder608123241/Folder283360226/Release482440157}</p>
 *
 * <h3>Identifiers</h3>
 * <p>You need to know the identifiers that releases, phases, and tasks have in the database.
 * Both templates and releases have an ID of the form <b>Applications/ReleaseXXXXXXX</b>, where <b>XXXXXXX</b> is a
 * seven-digit number (all IDs start with <b>Applications/</b> for technical reasons). If you have organized
 * templates and releases in folders, their IDs will be of the form
 * <b>Applications/FolderXXXXXXXXX-FolderXXXXXXXXX-ReleaseXXXXXXX</b>.</p>
 * <p>The fastest way to find the ID of a template or release is to open it in a browser and look at the URL in
 * the location bar. Take the last part of the URL and prefix it with <b>Applications</b>. If the template or
 * release is in a folder, you must also replace the hyphens (<b>-</b>) with forward slashes (<b>/</b>).</p>
 * <p>To get the identifiers of phases and tasks, first do a REST call to get the contents of a release, and then
 * inspect the results to find the IDs.</p>
 *
 * <h3>Authentication</h3>
 * <p>
 * Most resources require authentication. You can use HTTP Basic Authentication.
 * </p>
 *
 */
package com.xebialabs.xlrelease.api.internal;
