package com.xebialabs.xlrelease.builder;

import java.util.Date;

import com.xebialabs.xlrelease.domain.UserProfile;

public class UserProfileBuilder {

    private String id;
    private String fullName;
    private String email;
    private boolean loginAllowed;
    private String dateFormat;
    private String timeFormat;
    private Integer firstDayOfWeek;
    private Date lastActive;
    private boolean analyticsEnabled;

    private UserProfileBuilder() {
    }

    public static UserProfileBuilder newUserProfile() {
        return new UserProfileBuilder();
    }

    public UserProfileBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public UserProfileBuilder withFullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public UserProfileBuilder withEmail(String email) {
        this.email = email;
        return this;
    }

    public UserProfileBuilder withLoginAllowed(boolean loginAllowed) {
        this.loginAllowed = loginAllowed;
        return this;
    }

    public UserProfileBuilder withDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public UserProfileBuilder withTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
        return this;
    }

    public UserProfileBuilder withFirstDayOfWeek(int firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
        return this;
    }

    public UserProfileBuilder withLastActive(Date lastActive) {
        this.lastActive = lastActive;
        return this;
    }

    public UserProfileBuilder withAnalyticsEnabled(boolean analyticsEnabled) {
        this.analyticsEnabled = analyticsEnabled;
        return this;
    }

    public UserProfile build() {
        UserProfile profile = new UserProfile(id, email, fullName, loginAllowed, lastActive);
        profile.setTimeFormat(this.timeFormat);
        profile.setDateFormat(this.dateFormat);
        profile.setFirstDayOfWeek(this.firstDayOfWeek);
        profile.setAnalyticsEnabled(this.analyticsEnabled);

        return profile;
    }
}
