package com.xebialabs.xlrelease.export

import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.deployit.security.RoleService
import com.xebialabs.xlrelease.domain.{Release, Team}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.util.{List => JList}
import scala.jdk.CollectionConverters._

@Service
class MissingGlobalRolesImportProcessor @Autowired()(roleService: RoleService)
  extends TemplateImportProcessor with Logging {

  override def process(template: Release, destinationId: String): JList[String] = {
    logger.debug(s"Searching for missing global roles in template ${template.getTitle}")
    template.getTeams.asScala.flatMap {
      case team: Team =>
        val nonExistingRoles = team.getRoles.asScala.filter(role => !roleExists(role))
        if (nonExistingRoles.nonEmpty) {
          team.getRoles.removeAll(nonExistingRoles.asJava)
          Some(s"The following role(s) do not exist: ${nonExistingRoles.mkString(", ")}. They were removed from " +
            s"the ${team.getTeamName} team.")
        } else {
          None
        }
    }.asJava
  }

  private def roleExists(name: String): Boolean = {
    try {
      roleService.getRoleForRoleName(name)
      true
    } catch {
      case e: NotFoundException => false
    }
  }
}
