package com.xebialabs.xlrelease.script;

import java.lang.ref.SoftReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.xlrelease.domain.Task;

public class TaskSoftReference<U extends Task> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskSoftReference.class);
    private final Integer releaseCiUid;
    private SoftReference<U> softReference;

    /**
     * Note, this taskId may be with or without folder
     */
    private String taskId;
    private String executionId;
    private Supplier<U> supplier;

    public TaskSoftReference(final U task, final Supplier<U> supplier) {
        this(task.getId(), task.getExecutionId(), task.getRelease().getCiUid(), supplier);
        this.softReference = new SoftReference<>(task);
    }

    public TaskSoftReference(final String taskId, final String executionId, final Integer releaseCiUid, final Supplier<U> supplier) {
        this.softReference = new SoftReference<>(null);
        this.taskId = taskId;
        this.executionId = executionId;
        this.releaseCiUid = releaseCiUid;
        this.supplier = supplier;
    }

    public U get() {
        U task = softReference.get();
        if (task == null) {
            LOGGER.debug("Reference GCed, going to read from database {}", taskId);
            task = supplier.get();
            softReference = new SoftReference<>(task);
        } else {
            LOGGER.debug("Reference survived {}", taskId);
        }
        return task;
    }

    public String getTaskId() {
        return taskId;
    }

    public String getExecutionId() {
        return executionId;
    }

    public Integer getReleaseCiUid() {
        return releaseCiUid;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        final TaskSoftReference<?> that = (TaskSoftReference<?>) o;

        return taskId != null ? taskId.equals(that.taskId) : that.taskId == null;
    }

    @Override
    public int hashCode() {
        return taskId != null ? taskId.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "TaskSoftReference{" +
                "softReference=" + softReference +
                ", taskId='" + taskId + '\'' +
                ", executionId='" + executionId + '\'' +
                ", supplier=" + supplier +
                '}';
    }
}

