package com.xebialabs.xlrelease.variable

import com.xebialabs.deployit.plugin.api.reflect.{PropertyDescriptor, PropertyKind}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.domain.variables.Variable
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.repository.IdType._
import com.xebialabs.xlrelease.views.{VariableOrPasswordView, VariableOrValueView, VariableView}

import java.util.{Date, List => JList, Map => JMap}
import scala.jdk.CollectionConverters._


//noinspection ScalaStyle
// TODO: this class still unfinished, doesn't support LIST/SET_OF_CI etc..
object VariableViewHelper {
  def toView(pd: PropertyDescriptor, variable: String, value: AnyRef, useViewForStrings: Boolean = false): AnyRef = {
    pd.getKind match {
      case PropertyKind.STRING if pd.isPassword => new VariableOrPasswordView(variable, value.asInstanceOf[String])
      case PropertyKind.STRING if useViewForStrings => new VariableOrValueView(variable, value)
      case PropertyKind.STRING if !useViewForStrings => Option(variable).getOrElse(value)
      case PropertyKind.CI | PropertyKind.LIST_OF_CI | PropertyKind.SET_OF_CI if pd.isAsContainment => value // don't support variable mapping for contained CIs
      case PropertyKind.CI => Option(value).map(v => CONFIGURATION.convertToViewId(v.asInstanceOf[ConfigurationItem].getId)).orNull
      case _ => new VariableOrValueView(variable, value)
    }
  }

  def fromView(pd: PropertyDescriptor, viewValue: Any)(implicit configurationRepository: ConfigurationRepository): (String, AnyRef) = {
    pd.getKind match {
      case PropertyKind.CI | PropertyKind.LIST_OF_CI | PropertyKind.SET_OF_CI if pd.isAsContainment =>
        (null, viewValue.asInstanceOf[AnyRef])
      case PropertyKind.CI =>
        (null, if (viewValue != null) configurationRepository.read(CONFIGURATION.convertToInternalId(viewValue.asInstanceOf[String])) else null)
      case PropertyKind.STRING if pd.isPassword =>
        getVariableWithValue(new VariableOrPasswordView(viewValue.asInstanceOf[JMap[String, String]]))
      case PropertyKind.STRING if viewValue.isInstanceOf[JMap[_, _]] =>
        getVariableWithValue(new VariableOrValueView(viewValue.asInstanceOf[JMap[String, AnyRef]]))
      case PropertyKind.DATE =>
        val view = new VariableOrValueView(viewValue.asInstanceOf[JMap[String, AnyRef]])
        (view.getVariable, Option(view.getValue).map(value => new Date(value.toString.toLong)).orNull)
      case PropertyKind.STRING =>
        (null, viewValue.asInstanceOf[AnyRef])
      case _ =>
        getVariableWithValue(new VariableOrValueView(viewValue.asInstanceOf[JMap[String, AnyRef]]))
    }
  }

  private def getVariableWithValue(view: VariableOrValueView): (String, AnyRef) = {
    (view.getVariable, view.getValue)
  }

  def variableViewsToVariables(variableViews: JList[VariableView]): JList[Variable] =
    Option(variableViews).map(_.asScala.toList.map(_.toReleaseVariable)).getOrElse(Nil).asJava

}
