package com.xebialabs.xlrelease.views;

import java.util.Date;

import com.xebialabs.xlrelease.domain.Phase;

import static com.xebialabs.xlrelease.builder.PhaseBuilder.newPhase;
import static com.xebialabs.xlrelease.views.converters.DurationViewConverter.fromDurationView;

public class PhaseForm {
    private String title;
    private String description;
    private Date scheduledStartDate;
    private Date dueDate;
    private String color;
    private Long plannedDuration;

    public PhaseForm() {
    }

    public boolean hasDueDate() {
        return dueDate != null;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getScheduledStartDate() {
        return scheduledStartDate;
    }

    public void setScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Long getPlannedDuration() {
        return plannedDuration;
    }

    public void setPlannedDuration(Long plannedDuration) {
        this.plannedDuration = plannedDuration;
    }

    public Phase toPhase() {
        return newPhase()
                .withTitle(title)
                .withDescription(description)
                .withScheduledStartDate(scheduledStartDate)
                .withDueDate(dueDate)
                .withPlannedDuration(fromDurationView(plannedDuration))
                .withColor(color)
                .build();
    }
}
