package com.xebialabs.xlrelease.views.converters;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.views.DependencyNode;

import static com.xebialabs.xlrelease.repository.Ids.isTaskId;
import static com.xebialabs.xlrelease.views.converters.ReleaseViewConverter.RELEASE_WITH_EVERYTHING_DEPTH;
import static java.util.stream.Collectors.toList;

@Component
public class DependencyNodeConverter {

    private ReleaseService releaseService;
    private ReleaseViewConverter releaseViewConverter;

    @Autowired
    public DependencyNodeConverter(ReleaseService releaseService,
                                   ReleaseViewConverter releaseViewConverter
    ) {
        this.releaseService = releaseService;
        this.releaseViewConverter = releaseViewConverter;
    }

    public List<DependencyNode> toDependencyNodes(final List<String> planItemIds, List<String> properties, List<String> extensions) {
        return planItemIds.stream().map(node -> toDependencyNode(node, properties, extensions)).collect(toList());
    }

    private DependencyNode toDependencyNode(String planItemId, List<String> properties, List<String> extensions) {
        DependencyNode dependency = DependencyNodeFactory.fromTargetId(planItemId);
        if (!properties.isEmpty() || !extensions.isEmpty()) {
            // ENG-8022: it is better remove the need to load this data than to load it at all
            String releaseId = Ids.releaseIdFrom(planItemId);
            Release release = releaseService.findById(releaseId);
            dependency.setRelease(releaseViewConverter.toOverviewView(release, properties, extensions, RELEASE_WITH_EVERYTHING_DEPTH));
            if (isTaskId(planItemId)) {
                Task task = release.getTask(planItemId);
                if ((task instanceof CustomScriptTask)) {
                    PythonScript pythonScript = ((CustomScriptTask) task).getPythonScript();
                    dependency.setTaskColor(pythonScript.getTaskColor());
                    dependency.setTaskIconClass(pythonScript.getIconClass());
                    dependency.setTaskIconLocation(pythonScript.getIconLocation());
                }
            }

        }
        return dependency;
    }

}
