/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plumbing.IgnoreUrlFilter;
import com.xebialabs.deployit.plumbing.LogbackFilter;
import com.xebialabs.deployit.plumbing.MaintenanceModeAccessControlFilter;
import com.xebialabs.deployit.plumbing.ModifiedResourceFilter;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.deployit.plumbing.SlowdownFilter;
import com.xebialabs.deployit.plumbing.UrlRedirectRewriteFilter;
import com.xebialabs.deployit.plumbing.VersionEnforcerFilter;
import com.xebialabs.deployit.plumbing.XLRequestLogImpl;
import com.xebialabs.deployit.plumbing.XssSecurityHeadersFilter;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServlet;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServletInitializer;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry$;
import com.xebialabs.xlrelease.security.HttpSessionListenerWithTimeout;
import com.xebialabs.xlrelease.server.jetty.SSLConstants$;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.SessionTrackingMode;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001B\u000e\u001d\u0001\u001dB\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005s!A\u0001\t\u0001BC\u0002\u0013\u0005\u0011\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003C\u0011!I\u0005A!b\u0001\n\u0003Q\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u000bI\u0003A\u0011A*\t\u000be\u0003A\u0011\t.\t\u000b\u0005\u0004A\u0011\u000b2\t\u000bE\u0004A\u0011\u0002:\t\u000bQ\u0004A\u0011B;\t\u000b]\u0004A\u0011\u0002=\t\u000bi\u0004A\u0011B>\t\u000bu\u0004A\u0011\u0002@\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004!9\u0011q\u0001\u0001\u0005\n\u0005%\u0001bBA\u0007\u0001\u0011%\u0011q\u0002\u0005\b\u0003'\u0001A\u0011BA\u000b\u0011\u001d\tI\u0002\u0001C\u0005\u00037Aq!a\b\u0001\t\u0013\t\t\u0003C\u0004\u0002&\u0001!I!a\n\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.!9\u0011\u0011\u0007\u0001\u0005\n\u0005M\u0002bBA\"\u0001\u0011%\u0011Q\t\u0005\b\u0003\u0013\u0002A\u0011BA&\u0011\u001d\tY\u0007\u0001C\u0005\u0003[\u00121EU3mK\u0006\u001cXMS3uif\u001cVM\u001d<mKR<VMY*feZ,'OR1di>\u0014\u0018P\u0003\u0002\u001e=\u0005)!.\u001a;us*\u0011q\u0004I\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u0005\u0012\u0013!\u0003=me\u0016dW-Y:f\u0015\t\u0019C%A\u0005yK\nL\u0017\r\\1cg*\tQ%A\u0002d_6\u001c\u0001a\u0005\u0002\u0001QA\u0011\u0011&N\u0007\u0002U)\u0011Qd\u000b\u0006\u0003Y5\n\u0001\"Z7cK\u0012$W\r\u001a\u0006\u0003]=\n1a^3c\u0015\t\u0001\u0014'\u0001\u0003c_>$(B\u0001\u001a4\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001\u001b\u0002\u0007=\u0014x-\u0003\u00027U\ta\"*\u001a;usN+'O\u001e7fi^+'mU3sm\u0016\u0014h)Y2u_JL\u0018aE:feZ,'oQ8oM&<WO]1uS>tW#A\u001d\u0011\u0005ijT\"A\u001e\u000b\u0005q\u0012\u0013\u0001\u00033fa2|\u00170\u001b;\n\u0005yZ$aE*feZ,'oQ8oM&<WO]1uS>t\u0017\u0001F:feZ,'oQ8oM&<WO]1uS>t\u0007%A\u0005yYJ\u001cuN\u001c4jOV\t!\t\u0005\u0002D\r6\tAI\u0003\u0002FA\u000511m\u001c8gS\u001eL!a\u0012#\u0003\u0013ac'oQ8oM&<\u0017A\u0003=me\u000e{gNZ5hA\u0005\u0011\u0002/\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3s+\u0005Y\u0005C\u0001'P\u001b\u0005i%B\u0001(<\u0003!\u0019XmY;sSRL\u0018B\u0001)N\u0005I\u0001VM]7jgNLwN\\#oM>\u00148-\u001a:\u0002'A,'/\\5tg&|g.\u00128g_J\u001cWM\u001d\u0011\u0002\rqJg.\u001b;?)\u0011!fk\u0016-\u0011\u0005U\u0003Q\"\u0001\u000f\t\u000b]:\u0001\u0019A\u001d\t\u000b\u0001;\u0001\u0019\u0001\"\t\u000b%;\u0001\u0019A&\u00021%\u001c(+Z4jgR,'\u000fR3gCVdGoU3sm2,G\u000fF\u0001\\!\tav,D\u0001^\u0015\u0005q\u0016!B:dC2\f\u0017B\u00011^\u0005\u001d\u0011un\u001c7fC:\f\u0001\u0004]8tiB\u0013xnY3tg^+'-\u00119q\u0007>tG/\u001a=u)\t\u0019g\r\u0005\u0002]I&\u0011Q-\u0018\u0002\u0005+:LG\u000fC\u0003h\u0013\u0001\u0007\u0001.A\u0006d_:$X\r\u001f;S_>$\bCA5p\u001b\u0005Q'BA6m\u0003\u00199XMY1qa*\u0011Q$\u001c\u0006\u0003]N\nq!Z2mSB\u001cX-\u0003\u0002qU\niq+\u001a2BaB\u001cuN\u001c;fqR\f!b]3ukBTU\r\u001e;z)\t\u00197\u000fC\u0003h\u0015\u0001\u0007\u0001.\u0001\ntKR,\b\u000fT8hE\u0006\u001c7NR5mi\u0016\u0014HCA2w\u0011\u001597\u00021\u0001i\u0003-\u0019X\r^;q'B\u0014\u0018N\\4\u0015\u0005\rL\b\"B4\r\u0001\u0004A\u0017AD:fiV\u0004\u0018iY2fgNdun\u001a\u000b\u0003GrDQaZ\u0007A\u0002!\fqb]3ukB\u001cuN]:GS2$XM\u001d\u000b\u0003G~DQa\u001a\bA\u0002!\fQd]3ukBD6o]*fGV\u0014\u0018\u000e^=IK\u0006$WM]:GS2$XM\u001d\u000b\u0004G\u0006\u0015\u0001\"B4\u0010\u0001\u0004A\u0017AD:fiV\u0004XK\u001d7GS2$XM\u001d\u000b\u0004G\u0006-\u0001\"B4\u0011\u0001\u0004A\u0017aE:fiV\u00048\u000b\\8xI><hNR5mi\u0016\u0014HcA2\u0002\u0012!)q-\u0005a\u0001Q\u0006\t2/\u001a;va\u0016CH/\u001a8tS>t\u0017\t]5\u0015\u0007\r\f9\u0002C\u0003h%\u0001\u0007\u0001.\u0001\u000btKR,\bOV3sg&|g.\u00128g_J\u001cWM\u001d\u000b\u0004G\u0006u\u0001\"B4\u0014\u0001\u0004A\u0017!E:fiV\u0004(+Z9vKN$Hj\\2bYR\u00191-a\t\t\u000b\u001d$\u0002\u0019\u00015\u0002)\u0015t\u0017M\u00197f%\u0016\u001cx.\u001e:dKN\u001c\u0015m\u00195f)\r\u0019\u0017\u0011\u0006\u0005\u0006OV\u0001\r\u0001[\u0001\u0012K:\f'\r\\3Hu&\u0004\b*\u00198eY\u0016\u0014HcA2\u00020!)qM\u0006a\u0001Q\u0006\tb.Z<TKN\u001c\u0018n\u001c8IC:$G.\u001a:\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003\u007fi!!!\u000f\u000b\t\u0005m\u0012QH\u0001\bg\u0016\u001c8/[8o\u0015\tyB.\u0003\u0003\u0002B\u0005e\"AD*fgNLwN\u001c%b]\u0012dWM]\u0001\u001aK:\f'\r\\3J]N$(/^7f]R,G\rS1oI2,'\u000fF\u0002d\u0003\u000fBQa\u001a\rA\u0002!\f\u0011c]3u!J|\u0007/\u001a:us&3g*\u001e7m)\u0015\u0019\u0017QJA4\u0011\u001d\ty%\u0007a\u0001\u0003#\n1a[3z!\u0011\t\u0019&!\u0019\u000f\t\u0005U\u0013Q\f\t\u0004\u0003/jVBAA-\u0015\r\tYFJ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005}S,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003G\n)G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003?j\u0006bBA53\u0001\u0007\u0011\u0011K\u0001\u0006m\u0006dW/Z\u0001(g\u0016$X\u000f]'bS:$XM\\1oG\u0016lu\u000eZ3BG\u000e,7o]\"p]R\u0014x\u000e\u001c$jYR,'\u000fF\u0002d\u0003_BQa\u001a\u000eA\u0002!\u0004")
public class ReleaseJettyServletWebServerFactory
extends JettyServletWebServerFactory {
    private final ServerConfiguration serverConfiguration;
    private final XlrConfig xlrConfig;
    private final PermissionEnforcer permissionEnforcer;

    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public boolean isRegisterDefaultServlet() {
        return false;
    }

    public void postProcessWebAppContext(WebAppContext contextRoot) {
        this.setupJetty(contextRoot);
        this.setupLogbackFilter(contextRoot);
        this.setupSpring(contextRoot);
        this.setupAccessLog(contextRoot);
        this.setupCorsFilter(contextRoot);
        this.setupXssSecurityHeadersFilter(contextRoot);
        this.setupUrlFilter(contextRoot);
        this.setupSlowdownFilter(contextRoot);
        this.setupExtensionApi(contextRoot);
        this.setupVersionEnforcer(contextRoot);
        this.setupRequestLocal(contextRoot);
        this.setupMaintenanceModeAccessControlFilter(contextRoot);
    }

    private void setupJetty(WebAppContext contextRoot) {
        block2: {
            contextRoot.setSessionHandler(this.newSessionHandler());
            contextRoot.setSecurityHandler((SecurityHandler)new ConstraintSecurityHandler());
            if (this.xlrConfig().metrics().enabled()) {
                this.enableInstrumentedHandler(contextRoot);
            }
            if (this.xlrConfig().server_http_gzip_enabled()) {
                this.enableGzipHandler(contextRoot);
            }
            if (!this.xlrConfig().server_http_cache_enabled() || !Environment.isProduction()) break block2;
            this.enableResourcesCache(contextRoot);
        }
    }

    private void setupLogbackFilter(WebAppContext contextRoot) {
        contextRoot.addFilter(LogbackFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
    }

    private void setupSpring(WebAppContext contextRoot) {
        block0: {
            this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PROPERTY(), this.serverConfiguration().getKeyStorePath());
            this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getKeyStorePassword());
            this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PROPERTY(), this.serverConfiguration().getTrustStorePath());
            this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getTrustStorePassword());
            contextRoot.setInitParameter("contextClass", XmlWebApplicationContext.class.getName());
            contextRoot.addFilter(UrlRedirectRewriteFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
            FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
            filter.setName("springSecurityFilterChain");
            filter.setAsyncSupported(true);
            contextRoot.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
            FilterHolder encodingFilter = new FilterHolder(CharacterEncodingFilter.class);
            encodingFilter.setName("encodingFilter");
            encodingFilter.setInitParameter("encoding", "UTF-8");
            encodingFilter.setInitParameter("forceEncoding", "true");
            encodingFilter.setAsyncSupported(true);
            contextRoot.addFilter(encodingFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
            contextRoot.setResourceBase(".");
            if (this.xlrConfig().server_session_storage_enabled()) break block0;
            contextRoot.addEventListener((EventListener)((Object)new HttpSessionListenerWithTimeout()));
        }
    }

    private void setupAccessLog(WebAppContext contextRoot) {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        XLRequestLogImpl requestLogger = new XLRequestLogImpl("conf/logback-access.xml");
        requestLogHandler.setRequestLog((RequestLog)requestLogger);
        contextRoot.insertHandler((HandlerWrapper)requestLogHandler);
    }

    private void setupCorsFilter(WebAppContext contextRoot) {
        block0: {
            if (!this.xlrConfig().api_corsEnabled()) break block0;
            FilterHolder holder = new FilterHolder((Filter)new CrossOriginFilter());
            holder.setInitParameter("Access-Control-Allow-Origin", "*");
            holder.setInitParameter("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE, PUT");
            holder.setInitParameter("Access-Control-Allow-Headers", "3600");
            holder.setInitParameter("Access-Control-Max-Age", "x-requested-with, accept, origin, content-type");
            holder.setAsyncSupported(true);
            contextRoot.addFilter(holder, "/api/v1/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupXssSecurityHeadersFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new XssSecurityHeadersFilter());
        holder.setAsyncSupported(true);
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupUrlFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new IgnoreUrlFilter());
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSlowdownFilter(WebAppContext contextRoot) {
        block0: {
            long slowDownInMs;
            if (!Environment.isDevelopment() || (slowDownInMs = this.xlrConfig().development_restSlowDownDelay().toMillis()) <= 0L) break block0;
            this.logger.warn((Object)new StringBuilder(48).append("Configuring slow down filter with ").append(slowDownInMs).append(" milliseconds.").toString());
            FilterHolder slowdownFilter = new FilterHolder(SlowdownFilter.class);
            slowdownFilter.setInitParameter("ms", String.valueOf(slowDownInMs));
            slowdownFilter.setAsyncSupported(true);
            contextRoot.addFilter(slowdownFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupExtensionApi(WebAppContext contextRoot) {
        String apiExtensionRootPath = this.xlrConfig().serverExtension_rootPath();
        String apiExtensionContext = String.format("%s/*", apiExtensionRootPath);
        ServletHolder extensionApiServletHolder = new ServletHolder(AkkaStreamServlet.class);
        extensionApiServletHolder.setDisplayName("ExtensionApiConnectorServlet");
        extensionApiServletHolder.setAsyncSupported(true);
        contextRoot.addEventListener((EventListener)new AkkaStreamServletInitializer());
        contextRoot.addServlet(extensionApiServletHolder, apiExtensionContext);
    }

    private void setupVersionEnforcer(WebAppContext contextRoot) {
        block0: {
            if (Environment.isDevelopment()) break block0;
            contextRoot.addFilter(VersionEnforcerFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
        }
    }

    private void setupRequestLocal(WebAppContext contextRoot) {
        contextRoot.addFilter(RequestLocal.class, "*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
    }

    private void enableResourcesCache(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new ModifiedResourceFilter());
        holder.setInitParameter("startTimestamp", String.valueOf(System.currentTimeMillis()));
        holder.setAsyncSupported(true);
        contextRoot.addFilter(holder, "/static/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-module.js", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-plugins.js", EnumSet.of(DispatcherType.REQUEST));
    }

    private void enableGzipHandler(WebAppContext contextRoot) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setSyncFlush(true);
        gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT"});
        gzipHandler.setCompressionLevel(this.xlrConfig().server_http_gzip_compression());
        gzipHandler.setMinGzipSize(this.xlrConfig().server_http_gzip_minSize().intValue());
        gzipHandler.setExcludedPaths((String[])CollectionConverters$.MODULE$.ListHasAsScala(this.xlrConfig().server_http_gzip_excludedPaths()).asScala().toSeq().toArray(ClassTag$.MODULE$.apply(String.class)));
        contextRoot.insertHandler((HandlerWrapper)gzipHandler);
    }

    /*
     * WARNING - void declaration
     */
    private SessionHandler newSessionHandler() {
        void var1_1;
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
        sessionHandler.setHttpOnly(true);
        if (!this.serverConfiguration().isSsl()) {
            this.logger.debug((Object)new StringBuilder(38).append("Setting up Secure Cookie Enabled to - ").append(this.serverConfiguration().isSecureCookieEnabled()).toString());
            sessionHandler.getSessionCookieConfig().setSecure(this.serverConfiguration().isSecureCookieEnabled());
        }
        sessionHandler.setSameSite(HttpCookie.SameSite.valueOf((String)this.xlrConfig().server_http_cookie_sameSite().getAttributeValue().toUpperCase()));
        return var1_1;
    }

    private void enableInstrumentedHandler(WebAppContext contextRoot) {
        InstrumentedHandler handler = new InstrumentedHandler(XlrMetricRegistry$.MODULE$.metricRegistry());
        contextRoot.insertHandler((HandlerWrapper)handler);
    }

    private void setPropertyIfNull(String key, String value) {
        block1: {
            block2: {
                if (value == null) break block1;
                if (System.getProperty(key) != null) break block2;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)new StringBuilder(26).append("Setting system property - ").append(key).toString());
                }
                System.setProperty(key, value);
                break block1;
            }
            if (!this.logger.isDebugEnabled()) break block1;
            this.logger.debug((Object)new StringBuilder(51).append("Not overriding already specified system property - ").append(key).toString());
        }
    }

    private void setupMaintenanceModeAccessControlFilter(WebAppContext contextRoot) {
        block0: {
            if (!this.xlrConfig().maintenanceModeEnabled()) break block0;
            boolean restrictApiAccess = this.xlrConfig().maintenanceModeRestrictApiAccess();
            FilterHolder filterHolder = new FilterHolder((Filter)new MaintenanceModeAccessControlFilter(this.permissionEnforcer(), restrictApiAccess));
            contextRoot.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    public ReleaseJettyServletWebServerFactory(ServerConfiguration serverConfiguration, XlrConfig xlrConfig, PermissionEnforcer permissionEnforcer) {
        this.serverConfiguration = serverConfiguration;
        this.xlrConfig = xlrConfig;
        this.permissionEnforcer = permissionEnforcer;
    }
}

