/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.configuration;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plumbing.LogbackAccessSecurityAttributesSaveFilter;
import com.xebialabs.deployit.plumbing.authentication.CsrfSecurityRequestMatcher;
import com.xebialabs.deployit.plumbing.authentication.Http401AuthenticationEntryPoint;
import com.xebialabs.deployit.plumbing.authentication.LoginPermissionVoter;
import com.xebialabs.deployit.plumbing.authentication.ReleaseAuthenticationFailureHandler;
import com.xebialabs.deployit.plumbing.authentication.SessionExpiredLogoutHandler;
import com.xebialabs.deployit.plumbing.authentication.UsernamePasswordAuthenticationFilter;
import com.xebialabs.deployit.plumbing.authentication.WithoutRedirectLoginSuccessHandler;
import com.xebialabs.deployit.plumbing.authentication.WithoutRedirectLogoutSuccessHandler;
import com.xebialabs.xlrelease.authentication.XlPersistentTokenRememberMeServices;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.repository.CustomPersistentTokenRepository;
import com.xebialabs.xlrelease.security.filter.PATAuthenticationFilter;
import com.xebialabs.xlrelease.security.filter.RunnerAuthenticationFilter;
import com.xebialabs.xlrelease.security.web.csrf.ReleaseCookieCsrfTokenRepository;
import com.xebialabs.xlrelease.service.UserLastActiveActorService;
import com.xebialabs.xlrelease.service.UserProfileService;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.UnanimousBased;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessEventPublishingLogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationFilter;
import org.springframework.security.web.authentication.session.CompositeSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.ConcurrentSessionControlAuthenticationStrategy;
import org.springframework.security.web.authentication.session.RegisterSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CsrfLogoutHandler;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.firewall.HttpStatusRequestRejectedHandler;
import org.springframework.security.web.firewall.RequestRejectedHandler;
import org.springframework.security.web.session.ConcurrentSessionFilter;

@Configuration
public class ReleaseSecurityConfiguration {
    private final AuthenticationManager authenticationManager;
    private final AuthenticationManager runnerAuthenticationManager;
    private final UserDetailsService userDetailsService;
    private final UserProfileService userProfileService;
    private final UserLastActiveActorService userLastActiveActorService;
    private final CustomPersistentTokenRepository customPersistentTokenRepository;
    private final ServerConfiguration serverConfiguration;
    private final SessionRegistry sessionRegistry;
    private final XlrConfig xlrConfig;

    @Autowired
    public ReleaseSecurityConfiguration(AuthenticationManager authenticationManager, AuthenticationManager runnerAuthenticationManager, UserDetailsService userDetailsService, UserProfileService userProfileService, UserLastActiveActorService userLastActiveActorService, CustomPersistentTokenRepository customPersistentTokenRepository, ServerConfiguration serverConfiguration, SessionRegistry sessionRegistry, XlrConfig xlrConfig) {
        this.authenticationManager = authenticationManager;
        this.runnerAuthenticationManager = runnerAuthenticationManager;
        this.userDetailsService = userDetailsService;
        this.userProfileService = userProfileService;
        this.userLastActiveActorService = userLastActiveActorService;
        this.customPersistentTokenRepository = customPersistentTokenRepository;
        this.serverConfiguration = serverConfiguration;
        this.sessionRegistry = sessionRegistry;
        this.xlrConfig = xlrConfig;
    }

    @Bean
    public AuthenticatedVoter authenticatedVoter() {
        return new AuthenticatedVoter();
    }

    @Bean
    public LoginPermissionVoter loginPermissionVoter() {
        return new LoginPermissionVoter(this.userProfileService, this.userLastActiveActorService);
    }

    @Bean
    public UnanimousBased unanimousBased() {
        return new UnanimousBased(Arrays.asList(this.authenticatedVoter(), this.loginPermissionVoter()));
    }

    @Bean
    public Http401AuthenticationEntryPoint http401AuthenticationEntryPoint() {
        Http401AuthenticationEntryPoint authenticationEntryPoint = new Http401AuthenticationEntryPoint();
        authenticationEntryPoint.setRealmName("XLRelease");
        return authenticationEntryPoint;
    }

    @Bean
    public BasicAuthenticationFilter basicAuthenticationFilter() {
        return new BasicAuthenticationFilter(this.authenticationManager, (AuthenticationEntryPoint)this.http401AuthenticationEntryPoint());
    }

    @Bean
    public PATAuthenticationFilter patAuthenticationFilter() {
        return new PATAuthenticationFilter(this.authenticationManager, (AuthenticationEntryPoint)this.http401AuthenticationEntryPoint(), "x-release-personal-token");
    }

    @Bean
    @Profile(value={"defaultAuth"})
    public UsernamePasswordAuthenticationFilter formLoginFilter() {
        UsernamePasswordAuthenticationFilter authenticationFilter = new UsernamePasswordAuthenticationFilter();
        authenticationFilter.setAuthenticationManager(this.authenticationManager);
        authenticationFilter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)this.sessionAuthenticationStrategy());
        authenticationFilter.setRememberMeServices((RememberMeServices)this.rememberMeServices());
        authenticationFilter.setAuthenticationSuccessHandler(this.withoutRedirectLoginSuccessHandler());
        authenticationFilter.setAuthenticationFailureHandler(this.releaseAuthenticationFailureHandler());
        return authenticationFilter;
    }

    @Bean
    public ConcurrentSessionFilter concurrentSessionFilter() {
        ConcurrentSessionFilter sessionFilter = new ConcurrentSessionFilter(this.sessionRegistry);
        sessionFilter.setLogoutHandlers(Arrays.asList(this.securityContextLogoutHandler(), this.sessionExpiredLogoutHandler()));
        return sessionFilter;
    }

    @Bean
    public LogbackAccessSecurityAttributesSaveFilter logbackAccessSecurityAttributesSaveFilter() {
        return new LogbackAccessSecurityAttributesSaveFilter();
    }

    @Bean
    @Profile(value={"defaultAuth"})
    public RememberMeAuthenticationFilter rememberMeFilter() {
        return new RememberMeAuthenticationFilter(this.authenticationManager, (RememberMeServices)this.rememberMeServices());
    }

    @Bean
    @Profile(value={"defaultAuth"})
    public LogoutFilter logoutFilter() {
        return new LogoutFilter((LogoutSuccessHandler)this.withoutRedirectLogoutSuccessHandler(), new LogoutHandler[]{this.rememberMeServices(), this.csrfLogoutHandler(), this.logoutEventPublishingLogoutHandler()});
    }

    @Bean
    @Profile(value={"defaultAuth"})
    public XlPersistentTokenRememberMeServices rememberMeServices() {
        XlPersistentTokenRememberMeServices tokenRememberMeServices = new XlPersistentTokenRememberMeServices(this.xlrConfig.server_session_remember_me_key(), this.userDetailsService, this.customPersistentTokenRepository, this.serverConfiguration);
        tokenRememberMeServices.setParameter("rememberMe");
        tokenRememberMeServices.setCookieName("REMEMBER_ME_XLR");
        tokenRememberMeServices.setTokenValiditySeconds(this.xlrConfig.server_session_remember_me_token_validity_seconds());
        return tokenRememberMeServices;
    }

    @Bean
    public CompositeSessionAuthenticationStrategy sessionAuthenticationStrategy() {
        return new CompositeSessionAuthenticationStrategy(Arrays.asList(this.concurrentSessionControlAuthenticationStrategy(), this.sessionFixationProtectionStrategy(), this.registerSessionAuthenticationStrategy()));
    }

    @Bean
    public ConcurrentSessionControlAuthenticationStrategy concurrentSessionControlAuthenticationStrategy() {
        ConcurrentSessionControlAuthenticationStrategy authenticationStrategy = new ConcurrentSessionControlAuthenticationStrategy(this.sessionRegistry);
        authenticationStrategy.setMaximumSessions(this.xlrConfig.server_session_maximum_sessions());
        authenticationStrategy.setExceptionIfMaximumExceeded(this.xlrConfig.server_session_exception_if_maximum_exceeded());
        return authenticationStrategy;
    }

    @Bean
    public SessionFixationProtectionStrategy sessionFixationProtectionStrategy() {
        return new SessionFixationProtectionStrategy();
    }

    @Bean
    public RegisterSessionAuthenticationStrategy registerSessionAuthenticationStrategy() {
        return new RegisterSessionAuthenticationStrategy(this.sessionRegistry);
    }

    @Bean
    public SecurityContextLogoutHandler securityContextLogoutHandler() {
        return new SecurityContextLogoutHandler();
    }

    @Bean
    public SessionExpiredLogoutHandler sessionExpiredLogoutHandler() {
        return new SessionExpiredLogoutHandler();
    }

    @Bean
    @Profile(value={"defaultAuth"})
    public WithoutRedirectLogoutSuccessHandler withoutRedirectLogoutSuccessHandler() {
        return new WithoutRedirectLogoutSuccessHandler();
    }

    @Bean
    @Profile(value={"defaultAuth"})
    public WithoutRedirectLoginSuccessHandler withoutRedirectLoginSuccessHandler() {
        return new WithoutRedirectLoginSuccessHandler();
    }

    @Bean
    @Profile(value={"defaultAuth"})
    public ReleaseAuthenticationFailureHandler releaseAuthenticationFailureHandler() {
        return new ReleaseAuthenticationFailureHandler();
    }

    @Bean
    @Profile(value={"defaultAuth"})
    public LogoutSuccessEventPublishingLogoutHandler logoutEventPublishingLogoutHandler() {
        return new LogoutSuccessEventPublishingLogoutHandler();
    }

    @Bean
    public ReleaseCookieCsrfTokenRepository tokenRepository() {
        ReleaseCookieCsrfTokenRepository csrfTokenRepository = new ReleaseCookieCsrfTokenRepository();
        csrfTokenRepository.setCookieHttpOnly(false);
        csrfTokenRepository.setSameSite(this.xlrConfig.server_http_cookie_sameSite().getAttributeValue());
        if (!this.serverConfiguration.isSsl()) {
            csrfTokenRepository.setSecure(this.serverConfiguration.isSecureCookieEnabled());
        }
        return csrfTokenRepository;
    }

    @Bean
    public CsrfSecurityRequestMatcher csrfSecurityRequestMatcher() {
        return new CsrfSecurityRequestMatcher();
    }

    @Bean
    @Profile(value={"defaultAuth"})
    public CsrfLogoutHandler csrfLogoutHandler() {
        return new CsrfLogoutHandler((CsrfTokenRepository)this.tokenRepository());
    }

    @Bean
    public RequestRejectedHandler requestRejectedHandler() {
        return new HttpStatusRequestRejectedHandler();
    }

    @Bean
    public RunnerAuthenticationFilter runnerAuthenticationFilter() {
        return new RunnerAuthenticationFilter(this.runnerAuthenticationManager, (AuthenticationEntryPoint)this.http401AuthenticationEntryPoint(), "x-runner-auth-token");
    }
}

