/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextImpl;

public class MaintenanceModeAccessControlFilter
implements Filter {
    private final PermissionEnforcer permissionEnforcer;
    private final boolean isApiAccessRestricted;

    public MaintenanceModeAccessControlFilter(PermissionEnforcer permissionEnforcer, boolean isApiAccessRestricted) {
        this.permissionEnforcer = permissionEnforcer;
        this.isApiAccessRestricted = isApiAccessRestricted;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean isSessionlessAuthenticatedUser;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpSession session = httpServletRequest.getSession(false);
        Authentication currentUserAuthentication = Permissions.getAuthentication();
        boolean sessionExists = session != null;
        boolean isAnonymousUser = currentUserAuthentication instanceof AnonymousAuthenticationToken;
        boolean bl = isSessionlessAuthenticatedUser = currentUserAuthentication != null && !isAnonymousUser && !sessionExists;
        if (sessionExists) {
            boolean isUnsecuredResourceRequest;
            boolean isStaticResourceRequest = currentUserAuthentication == null;
            boolean bl2 = isUnsecuredResourceRequest = isStaticResourceRequest && session.getAttribute("SPRING_SECURITY_CONTEXT") == null;
            if (isUnsecuredResourceRequest) {
                chain.doFilter(request, response);
                return;
            }
            if (isStaticResourceRequest) {
                SecurityContextImpl sci = (SecurityContextImpl)session.getAttribute("SPRING_SECURITY_CONTEXT");
                currentUserAuthentication = sci.getAuthentication();
            }
            this.isAllowedAccessInMaintenanceMode(request, response, chain, currentUserAuthentication);
            return;
        }
        if (isSessionlessAuthenticatedUser) {
            if (this.isApiAccessRestricted) {
                this.isAllowedAccessInMaintenanceMode(request, response, chain, currentUserAuthentication);
                return;
            }
            chain.doFilter(request, response);
            return;
        }
        chain.doFilter(request, response);
    }

    private void isAllowedAccessInMaintenanceMode(ServletRequest request, ServletResponse response, FilterChain chain, Authentication currentUserAuthentication) throws IOException, ServletException {
        if (this.permissionEnforcer.isAdmin(currentUserAuthentication)) {
            chain.doFilter(request, response);
        } else {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setStatus(HttpStatus.SERVICE_UNAVAILABLE.value());
        }
    }
}

