/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.ArchivedReleasesSearch;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.AdaptiveReleaseId;
import com.xebialabs.xlrelease.domain.utils.FullReleaseId$;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicDataExt;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xlrelease.service.ArchivedReleaseDeserialization;
import com.xebialabs.xlrelease.service.ArchivedReleaseReader;
import com.xebialabs.xlrelease.service.ArchivingService$;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.CompletedReleaseExportService;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

@Service
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0005\u0011Ut!\u0002\u001e<\u0011\u0003!e!\u0002$<\u0011\u00039\u0005\"\u0002,\u0002\t\u00039\u0006\"\u0002-\u0002\t\u0003If\u0001\u0002$<\u0001ED\u0001\"\u001e\u0003\u0003\u0006\u0004%\tA\u001e\u0005\t{\u0012\u0011\t\u0011)A\u0005o\"Aa\u0010\u0002B\u0001B\u0003%q\u0010\u0003\u0006\u0002\u0006\u0011\u0011\t\u0011)A\u0005\u0003\u000fA!\"!\u0004\u0005\u0005\u000b\u0007I\u0011AA\b\u0011)\t\t\u0003\u0002B\u0001B\u0003%\u0011\u0011\u0003\u0005\u000b\u0003G!!\u0011!Q\u0001\n\u0005\u0015\u0002BCA\u0016\t\t\u0005\t\u0015!\u0003\u0002.!Q\u0011q\u0007\u0003\u0003\u0002\u0003\u0006I!!\u000f\t\u0015\u0005}BA!A!\u0002\u0013\t\t\u0005\u0003\u0006\u0002N\u0011\u0011\t\u0011)A\u0005\u0003\u001fB!\"!\u0016\u0005\u0005\u0003\u0005\u000b\u0011BA,\u0011)\ti\u0006\u0002B\u0001B\u0003%\u0011q\f\u0005\u000b\u0003K\"!\u0011!Q\u0001\n\u0005\u001d\u0004BCA7\t\t\u0005\t\u0015!\u0003\u0002p!1a\u000b\u0002C\u0001\u0003kBq!!,\u0005\t\u0003\ty\u000bC\u0004\u0002P\u0012!I!!5\t\u000f\u0005\u0015H\u0001\"\u0003\u0002h\"9\u00111\u001e\u0003\u0005\n\u00055\bbBAy\t\u0011\u0005\u00111\u001f\u0005\b\u0003\u007f$A\u0011\u0001B\u0001\u0011\u001d\u00119\u0001\u0002C\u0001\u0005\u0013AqA!\u0004\u0005\t\u0003\u0011y\u0001C\u0004\u0003\u000e\u0011!\tAa\u0005\t\u000f\tuA\u0001\"\u0001\u0003 !9!Q\u0005\u0003\u0005\u0002\t\u001d\u0002b\u0002B\u001b\t\u0011\u0005!q\u0007\u0005\b\u0005\u000b\"A\u0011\u0001B$\u0011\u001d\u0011Y\u0006\u0002C\u0001\u0005;BqA!\u001a\u0005\t\u0003\u00119\u0007C\u0004\u0003n\u0011!\tAa\u001c\t\u000f\t]D\u0001\"\u0001\u0003z!9!\u0011\u0011\u0003\u0005\u0002\t\r\u0005b\u0002BH\t\u0011\u0005!\u0011\u0013\u0005\b\u0005;#A\u0011\u0001BP\u0011\u001d\u0011i\n\u0002C\u0001\u0005\u0017DqAa8\u0005\t\u0003\u0011\t\u000fC\u0005\u00046\u0011\t\n\u0011\"\u0001\u00048!I11\n\u0003\u0012\u0002\u0013\u00051q\u0007\u0005\b\u0007\u001b\"A\u0011AB(\u0011\u001d\u0019i\u0007\u0002C\u0001\u0007_Bqa!\u001e\u0005\t\u0003\u00199\bC\u0004\u0004\u0018\u0012!\ta!'\t\u000f\r\u0005F\u0001\"\u0001\u0004$\"91\u0011\u0016\u0003\u0005\u0002\r-\u0006bBBY\t\u0011\u000511\u0017\u0005\b\u0005;#A\u0011BBa\u0011\u001d\u0019I\r\u0002C\u0001\u0007\u0017Dqaa5\u0005\t\u0003\u0019)\u000eC\u0004\u0004h\u0012!Ia!;\t\u000f\u0011]A\u0001\"\u0003\u0005\u001a!9Aq\u0004\u0003\u0005\n\u0011\u0005\u0012\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0015\taT(A\u0004tKJ4\u0018nY3\u000b\u0005yz\u0014!\u0003=me\u0016dW-Y:f\u0015\t\u0001\u0015)A\u0005yK\nL\u0017\r\\1cg*\t!)A\u0002d_6\u001c\u0001\u0001\u0005\u0002F\u00035\t1H\u0001\tBe\u000eD\u0017N^5oON+'O^5dKN\u0019\u0011\u0001\u0013(\u0011\u0005%cU\"\u0001&\u000b\u0003-\u000bQa]2bY\u0006L!!\u0014&\u0003\r\u0005s\u0017PU3g!\tyE+D\u0001Q\u0015\t\t&+A\u0003tY\u001a$$NC\u0001T\u0003!9'/\u001b>{Y\u0016$\u0017BA+Q\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u0001#\u0002\u0019\u001d,G/T8oi\"LV-\u0019:\u0015\u0005i+\u0007CA.c\u001d\ta\u0006\r\u0005\u0002^\u00156\taL\u0003\u0002`\u0007\u00061AH]8pizJ!!\u0019&\u0002\rA\u0013X\rZ3g\u0013\t\u0019GM\u0001\u0004TiJLgn\u001a\u0006\u0003C*CQAZ\u0002A\u0002\u001d\f\u0011b\u001d;beR$\u0015\r^3\u0011\u0005!|W\"A5\u000b\u0005)\\\u0017\u0001\u0002;j[\u0016T!\u0001\\7\u0002\t)|G-\u0019\u0006\u0002]\u0006\u0019qN]4\n\u0005AL'\u0001\u0003#bi\u0016$\u0016.\\3\u0014\t\u0011A%O\u0014\t\u0003\u000bNL!\u0001^\u001e\u0003+\u0005\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016\u0014V-\u00193fe\u0006\u0001\u0012M]2iSZ,GMU3mK\u0006\u001cXm]\u000b\u0002oB\u0011\u0001p_\u0007\u0002s*\u0011!0P\u0001\u0003I\nL!\u0001`=\u0003!\u0005\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\u0018!E1sG\"Lg/\u001a3SK2,\u0017m]3tA\u00051\u0012M]2iSZ,GMU3mK\u0006\u001cXm]*fCJ\u001c\u0007\u000eE\u0002y\u0003\u0003I1!a\u0001z\u0005Y\t%o\u00195jm\u0016$'+\u001a7fCN,7oU3be\u000eD\u0017AH1sG\"Lg/\u001a3BGRLg/\u001b;z\u0019><7oU3sS\u0006d\u0017N_3s!\r)\u0015\u0011B\u0005\u0004\u0003\u0017Y$AH!sG\"Lg/\u001a3BGRLg/\u001b;z\u0019><7oU3sS\u0006d\u0017N_3s\u0003E\u0011X\r]8tSR|'/_!eCB$XM]\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0006sKB|7/\u001b;pefT1!a\u0007@\u0003!!W\r\u001d7ps&$\u0018\u0002BA\u0010\u0003+\u0011\u0011CU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\u0003I\u0011X\r]8tSR|'/_!eCB$XM\u001d\u0011\u0002=\r|W\u000e\u001d7fi\u0016$'+\u001a7fCN,7/\u0012=q_J$8+\u001a:wS\u000e,\u0007cA#\u0002(%\u0019\u0011\u0011F\u001e\u0003;\r{W\u000e\u001d7fi\u0016$'+\u001a7fCN,W\t\u001f9peR\u001cVM\u001d<jG\u0016\f\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z!\u0011\ty#a\r\u000e\u0005\u0005E\"bAA\f{%!\u0011QGA\u0019\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\u0015I\u0016\u0004XM\u001c3f]\u000eL(+\u001a9pg&$xN]=\u0011\t\u0005=\u00121H\u0005\u0005\u0003{\t\tD\u0001\u000bEKB,g\u000eZ3oGf\u0014V\r]8tSR|'/_\u0001\u0014e\u0016dW-Y:f\u0003\u000e$xN]*feZL7-\u001a\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011qI\u001f\u0002\r\u0005\u001cGo\u001c:t\u0013\u0011\tY%!\u0012\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002\u001dQ,\u0017-\u001c*fa>\u001c\u0018\u000e^8ssB!\u0011qFA)\u0013\u0011\t\u0019&!\r\u0003\u001dQ+\u0017-\u001c*fa>\u001c\u0018\u000e^8ss\u0006Q1/Z2ve\u0016$7)[:\u0011\t\u0005=\u0012\u0011L\u0005\u0005\u00037\n\tD\u0001\u0006TK\u000e,(/\u001a3DSN\f1D]3mK\u0006\u001cX-\u0012=uK:\u001c\u0018n\u001c8t%\u0016\u0004xn]5u_JL\b\u0003BA\u0018\u0003CJA!a\u0019\u00022\tY\"+\u001a7fCN,W\t\u001f;f]NLwN\\:SKB|7/\u001b;pef\fabY8n[\u0016tGoU3sm&\u001cW\rE\u0002F\u0003SJ1!a\u001b<\u00059\u0019u.\\7f]R\u001cVM\u001d<jG\u0016\f\u0011DZ1dKR\u0014V\r]8tSR|'/\u001f#jgB\fGo\u00195feB!\u0011qFA9\u0013\u0011\t\u0019(!\r\u00033\u0019\u000b7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM\u001d\u000b\u001d\u0003o\nI(a\u001f\u0002~\u0005}\u0014\u0011QAB\u0003\u000b\u000b9)!#\u0002\f\u00065\u0015qRAI!\t)E\u0001C\u0003v)\u0001\u0007q\u000fC\u0003\u007f)\u0001\u0007q\u0010C\u0004\u0002\u0006Q\u0001\r!a\u0002\t\u000f\u00055A\u00031\u0001\u0002\u0012!9\u00111\u0005\u000bA\u0002\u0005\u0015\u0002bBA\u0016)\u0001\u0007\u0011Q\u0006\u0005\b\u0003o!\u0002\u0019AA\u001d\u0011\u001d\ty\u0004\u0006a\u0001\u0003\u0003Bq!!\u0014\u0015\u0001\u0004\ty\u0005C\u0004\u0002VQ\u0001\r!a\u0016\t\u000f\u0005uC\u00031\u0001\u0002`!9\u0011Q\r\u000bA\u0002\u0005\u001d\u0004bBA7)\u0001\u0007\u0011q\u000e\u0015\u0004)\u0005U\u0005\u0003BAL\u0003Sk!!!'\u000b\t\u0005m\u0015QT\u0001\u000bC:tw\u000e^1uS>t'\u0002BAP\u0003C\u000bqAZ1di>\u0014\u0018P\u0003\u0003\u0002$\u0006\u0015\u0016!\u00022fC:\u001c(bAAT[\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148.\u0003\u0003\u0002,\u0006e%!C!vi><\u0018N]3e\u00039\t'o\u00195jm\u0016\u0014V\r\\3bg\u0016$B!!-\u00028B\u0019\u0011*a-\n\u0007\u0005U&J\u0001\u0003V]&$\bBBA]+\u0001\u0007!,A\u0005sK2,\u0017m]3JI\"\u001aQ#!0\u0011\t\u0005}\u00161Z\u0007\u0003\u0003\u0003TA!a'\u0002D*!\u0011QYAd\u0003\u001diW\r\u001e:jGNT1!!3B\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BAg\u0003\u0003\u0014Q\u0001V5nK\u0012\fQ\u0002Z3mKR,'+\u001a7fCN,GCBAY\u0003'\f)\u000e\u0003\u0004\u0002:Z\u0001\rA\u0017\u0005\b\u0003/4\u0002\u0019AAm\u0003\u001d\u0011X\r\\3bg\u0016\u0004B!a7\u0002b6\u0011\u0011Q\u001c\u0006\u0004\u0003?l\u0014A\u00023p[\u0006Lg.\u0003\u0003\u0002d\u0006u'a\u0002*fY\u0016\f7/Z\u0001\u0013CJ\u001c\u0007.\u001b<f\u0003R$\u0018m\u00195nK:$8\u000f\u0006\u0003\u00022\u0006%\bbBAl/\u0001\u0007\u0011\u0011\\\u0001\u0014CJ\u001c\u0007.\u001b<f\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\u000b\u0005\u0003c\u000by\u000fC\u0004\u0002Xb\u0001\r!!7\u0002/\u0011,G.\u001a;f!J,\u0017I]2iSZ,'+\u001a7fCN,G\u0003BA{\u0003w\u00042!SA|\u0013\r\tIP\u0013\u0002\b\u0005>|G.Z1o\u0011\u0019\tI,\u0007a\u00015\"\u001a\u0011$!0\u0002#A\u0014X-\u0011:dQ&4XMU3mK\u0006\u001cX\r\u0006\u0003\u00022\n\r\u0001bBAl5\u0001\u0007\u0011\u0011\u001c\u0015\u00045\u0005u\u0016!D:i_VdG-\u0011:dQ&4X\r\u0006\u0003\u0002v\n-\u0001bBAl7\u0001\u0007\u0011\u0011\\\u0001\u000bO\u0016$(+\u001a7fCN,G\u0003BAm\u0005#Aa!!/\u001d\u0001\u0004QFCBAm\u0005+\u00119\u0002\u0003\u0004\u0002:v\u0001\rA\u0017\u0005\b\u00053i\u0002\u0019AA{\u0003IIgn\u00197vI\u0016\u0004&/Z!sG\"Lg/\u001a3)\u0007u\ti,A\bhKR\u0014V\r\\3bg\u0016$\u0016\u000e\u001e7f)\rQ&\u0011\u0005\u0005\u0007\u0003ss\u0002\u0019\u0001.)\u0007y\ti,\u0001\u0005hKR\u0004\u0006.Y:f)\u0011\u0011ICa\f\u0011\t\u0005m'1F\u0005\u0005\u0005[\tiNA\u0003QQ\u0006\u001cX\r\u0003\u0004\u00032}\u0001\rAW\u0001\ba\"\f7/Z%eQ\ry\u0012QX\u0001\bO\u0016$H+Y:l)\u0011\u0011IDa\u0010\u0011\t\u0005m'1H\u0005\u0005\u0005{\tiN\u0001\u0003UCN\\\u0007B\u0002B!A\u0001\u0007!,\u0001\u0004uCN\\\u0017\n\u001a\u0015\u0004A\u0005u\u0016aC4fiZ\u000b'/[1cY\u0016$BA!\u0013\u0003VA!!1\nB)\u001b\t\u0011iE\u0003\u0003\u0003P\u0005u\u0017!\u0003<be&\f'\r\\3t\u0013\u0011\u0011\u0019F!\u0014\u0003\u0011Y\u000b'/[1cY\u0016DaAa\u0016\"\u0001\u0004Q\u0016A\u0003<be&\f'\r\\3JI\"\u001a\u0011%!0\u0002\r\u0015D\u0018n\u001d;t)\u0011\t)Pa\u0018\t\r\t\u0005$\u00051\u0001[\u0003\u0011\u0019\u0017.\u00133)\u0007\t\ni,A\tfq&\u001cHo\u001d)sK\u0006\u00138\r[5wK\u0012$B!!>\u0003j!1!\u0011M\u0012A\u0002iC3aIA_\u00031)\u00070[:ug\nKh*Y7f)\u0011\t)P!\u001d\t\r\tMD\u00051\u0001[\u0003-\u0011X\r\\3bg\u0016t\u0015-\\3)\u0007\u0011\ni,\u0001\tbiR\f7\r[7f]R,\u00050[:ugR!\u0011Q\u001fB>\u0011\u0019\u0011i(\na\u00015\u0006a\u0011\r\u001e;bG\"lWM\u001c;JI\"\u001aQ%!0\u0002\u001b\u001d,G/\u0011;uC\u000eDW.\u001a8u)\u0011\u0011)Ia#\u0011\t\u0005m'qQ\u0005\u0005\u0005\u0013\u000biN\u0001\u0006BiR\f7\r[7f]RDaA! '\u0001\u0004Q\u0006f\u0001\u0014\u0002>\u0006\u0019r-\u001a;BiR\f7\r[7f]R|\u0005\u000f^5p]R!!1\u0013BM!\u0015I%Q\u0013BC\u0013\r\u00119J\u0013\u0002\u0007\u001fB$\u0018n\u001c8\t\r\tut\u00051\u0001[Q\r9\u0013QX\u0001\u000fg\u0016\f'o\u00195SK2,\u0017m]3t)\u0011\u0011\tK!-\u0011\r\t\r&QVAm\u001b\t\u0011)K\u0003\u0003\u0003(\n%\u0016\u0001B;uS2T!Aa+\u0002\t)\fg/Y\u0005\u0005\u0005_\u0013)K\u0001\u0003MSN$\bb\u0002BZQ\u0001\u0007!QW\u0001\bM&dG/\u001a:t!\u0011\u00119L!2\u000e\u0005\te&\u0002\u0002B^\u0005{\u000bQAZ8s[NTAAa0\u0003B\u0006\u0011a/\r\u0006\u0004\u0005\u0007l\u0014aA1qS&!!q\u0019B]\u0005=\u0011V\r\\3bg\u0016\u001ch)\u001b7uKJ\u001c\bf\u0001\u0015\u0002>RA!\u0011\u0015Bg\u0005\u001f\u0014I\u000eC\u0004\u00034&\u0002\rA!.\t\u000f\tE\u0017\u00061\u0001\u0003T\u0006)A.[7jiB\u0019\u0011J!6\n\u0007\t]'J\u0001\u0003M_:<\u0007b\u0002BnS\u0001\u0007!1[\u0001\u0007_\u001a47/\u001a;)\u0007%\ni,\u0001\u001agS:$7\u000b[8siJ+G.Z1tK&#7oV5uQ\u001a{G\u000eZ3s\u001d\u0006lW-\u00118e\u001fJ$WM]\"sSR,'/[8o))\u0011\u0019oa\u0003\u0004\"\r52\u0011\u0007\t\u0007\u0005K\u0014yOa=\u000f\t\t\u001d(1\u001e\b\u0004;\n%\u0018\"A&\n\u0007\t5(*A\u0004qC\u000e\\\u0017mZ3\n\t\t=&\u0011\u001f\u0006\u0004\u0005[T\u0005cB%\u0003v\ne8QA\u0005\u0004\u0005oT%A\u0002+va2,'\u0007\u0005\u0003\u0003|\u000e\u0005QB\u0001B\u007f\u0015\u0011\u0011y0!8\u0002\u000bU$\u0018\u000e\\:\n\t\r\r!Q \u0002\u0012\u0003\u0012\f\u0007\u000f^5wKJ+G.Z1tK&#\u0007cA%\u0004\b%\u00191\u0011\u0002&\u0003\u0007\u0005s\u0017\u0010C\u0004\u00034*\u0002\ra!\u0004\u0011\r\t\u00158qBB\n\u0013\u0011\u0019\tB!=\u0003\u0007M+\u0017\u000f\u0005\u0003\u0004\u0016\ruQBAB\f\u0015\u0011\u0011\u0019l!\u0007\u000b\u0007\rmQ(A\u0004sKB|'\u000f^:\n\t\r}1q\u0003\u0002\r%\u0016\u0004xN\u001d;GS2$XM\u001d\u0005\b\u0007GQ\u0003\u0019AB\u0013\u0003\u0015y'\u000fZ3s!\u0015I%QSB\u0014!\u0011\u00119l!\u000b\n\t\r-\"\u0011\u0018\u0002\u0011%\u0016dW-Y:f\u001fJ$WM]'pI\u0016D\u0011B!5+!\u0003\u0005\raa\f\u0011\u000b%\u0013)Ja5\t\u0013\tm'\u0006%AA\u0002\r=\u0002f\u0001\u0016\u0002>\u0006ad-\u001b8e'\"|'\u000f\u001e*fY\u0016\f7/Z%eg^KG\u000f\u001b$pY\u0012,'OT1nK\u0006sGm\u0014:eKJ\u001c%/\u001b;fe&|g\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019ID\u000b\u0003\u00040\rm2FAB\u001f!\u0011\u0019yda\u0012\u000e\u0005\r\u0005#\u0002BB\"\u0007\u000b\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m%*\u0003\u0003\u0004J\r\u0005#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006ad-\u001b8e'\"|'\u000f\u001e*fY\u0016\f7/Z%eg^KG\u000f\u001b$pY\u0012,'OT1nK\u0006sGm\u0014:eKJ\u001c%/\u001b;fe&|g\u000e\n3fM\u0006,H\u000e\u001e\u00135\u0003U\u0019w.\u001e8u%\u0016dW-Y:fg\nK8\u000b^1ukN$Ba!\u0015\u0004jA91la\u0015\u0004X\r\r\u0014bAB+I\n\u0019Q*\u00199\u0011\t\re3qL\u0007\u0003\u00077RAa!\u0018\u0002^\u000611\u000f^1ukNLAa!\u0019\u0004\\\ti!+\u001a7fCN,7\u000b^1ukN\u00042!SB3\u0013\r\u00199G\u0013\u0002\u0004\u0013:$\bb\u0002BZ[\u0001\u0007!Q\u0017\u0015\u0004[\u0005u\u0016!D2pk:$(+\u001a7fCN,7\u000f\u0006\u0003\u0004R\rE\u0004b\u0002BZ]\u0001\u00071Q\u0002\u0015\u0004]\u0005u\u0016\u0001\u00074j]\u0012\f%o\u00195jm\u0006\u0014G.\u001a*fY\u0016\f7/Z%egR11\u0011PB>\u0007\u000b\u0003RA!:\u0004\u0010iCqa! 0\u0001\u0004\u0019y(\u0001\u0003eCR,\u0007\u0003\u0002BR\u0007\u0003KAaa!\u0003&\n!A)\u0019;f\u0011\u001d\u00199i\fa\u0001\u0007\u0013\u000b\u0001\u0002]1hKNK'0\u001a\t\u0005\u0007\u0017\u001b\t*\u0004\u0002\u0004\u000e*!1q\u0012BU\u0003\u0011a\u0017M\\4\n\t\rM5Q\u0012\u0002\b\u0013:$XmZ3sQ\ry\u0013QX\u0001\u0017M&tG\rU;sO\u0006\u0014G.\u001a*fY\u0016\f7/Z%egR11\u0011PBN\u0007;Cqa! 1\u0001\u0004\u0019y\bC\u0004\u0004\bB\u0002\ra!#)\u0007A\ni,\u0001\u000bqkJ<W-\u0011:dQ&4X\r\u001a*fY\u0016\f7/\u001a\u000b\u0005\u0003c\u001b)\u000b\u0003\u0004\u0002:F\u0002\rA\u0017\u0015\u0004c\u0005u\u0016AH1sG\"Lg/Z!mY&s7m\\7j]\u001e$U\r]3oI\u0016t7-[3t)\u0011\t\tl!,\t\r\u0005e&\u00071\u0001[Q\r\u0011\u0014QX\u0001\u000bO\u0016$\u0018\t\u001c7UC\u001e\u001cH\u0003BB[\u0007w\u0003RAa)\u00048jKAa!/\u0003&\n\u00191+\u001a;\t\u000f\ru6\u00071\u0001\u0004d\u0005YA.[7ji:+XNY3sQ\r\u0019\u0014Q\u0018\u000b\t\u0005C\u001b\u0019m!2\u0004H\"9!1\u0017\u001bA\u0002\tU\u0006b\u0002Bii\u0001\u00071q\u0006\u0005\b\u00057$\u0004\u0019AB\u0018\u0003i\u0019X-\u0019:dQJ+G.Z1tKN\u0014\u0015PU3mK\u0006\u001cX-\u00133t)\u0011\u0019ima4\u0011\r\t\u00158qBAm\u0011\u001d\u0019\t.\u000ea\u0001\u0007s\n!B]3mK\u0006\u001cX-\u00133t\u0003\t\u001aX-\u0019:dQJ+G.Z1tKN\u0014\u0015m]5d\u000bb$()\u001f*fY\u0016\f7/Z%egR!1q[Bs!\u0019\u0011)oa\u0004\u0004ZB!11\\Bq\u001b\t\u0019iN\u0003\u0003\u0004`\u0006E\u0012!B9vKJL\u0018\u0002BBr\u0007;\u00141CU3mK\u0006\u001cXMQ1tS\u000e$\u0015\r^1FqRDqa!57\u0001\u0004\u0019I(\u0001\bhKR\u0014V\r\\3bg\u0016LE/Z7\u0016\t\r-8Q\u001f\u000b\u0005\u0007[$\u0019\u0002\u0006\u0003\u0004p\u0012\u001d\u0001#B%\u0003\u0016\u000eE\b\u0003BBz\u0007kd\u0001\u0001B\u0004\u0004x^\u0012\ra!?\u0003\u0003Q\u000bBaa?\u0005\u0002A\u0019\u0011j!@\n\u0007\r}(JA\u0004O_RD\u0017N\\4\u0011\t\u0005mG1A\u0005\u0005\t\u000b\tiN\u0001\u0005QY\u0006t\u0017\n^3n\u0011\u001d!Ia\u000ea\u0001\t\u0017\tqaZ3u\u0013R,W\u000eE\u0004J\t\u001b\tI\u000e\"\u0005\n\u0007\u0011=!JA\u0005Gk:\u001cG/[8ocA1\u0011\n\"\u0004[\u0007cDa\u0001\"\u00068\u0001\u0004Q\u0016AB5uK6LE-A\thKR4\u0016M]5bE2,w\n\u001d;j_:$B\u0001b\u0007\u0005\u001eA)\u0011J!&\u0003J!1!q\u000b\u001dA\u0002i\u000ba$\u0019:dQ&4X-\u00117m\u001fV$xm\\5oO\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\t\u0011\rB1\u0006\t\u0007\u0005K\u001cy\u0001\"\n\u0011\t\u0005mGqE\u0005\u0005\tS\tiN\u0001\u0006EKB,g\u000eZ3oGfDq!a6:\u0001\u0004\tI\u000eK\n\u0005\t_!i\u0004b\u0010\u0005D\u0011\u0015Cq\nC)\t7\"i\u0006\u0005\u0003\u00052\u0011eRB\u0001C\u001a\u0015\u0011\tY\n\"\u000e\u000b\t\u0011]\u0012QU\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0005<\u0011M\"!\u0004+sC:\u001c\u0018m\u0019;j_:\fG.A\u0003wC2,X-\t\u0002\u0005B\u0005Y\"/\u001a9peRLgn\u001a+sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJ\f1\u0002\u001d:pa\u0006<\u0017\r^5p]\u0012\u0012AqI\u0005\u0005\t\u0013\"Y%\u0001\u0005S\u000bF+\u0016JU#E\u0015\u0011!i\u0005b\r\u0002\u0017A\u0013x\u000e]1hCRLwN\\\u0001\nSN|G.\u0019;j_:$#\u0001b\u0015\n\t\u0011UCqK\u0001\u000f%\u0016\u000bEiX\"P\u001b6KE\u000bV#E\u0015\u0011!I\u0006b\r\u0002\u0013%\u001bx\u000e\\1uS>t\u0017a\u0003:pY2\u0014\u0017mY6G_Jd#\u0001b\u0018$\u0005\u0011\u0005\u0004\u0003\u0002Bs\tGJA\u0001\"\u001a\u0003r\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0015\u0004\t\u0011%\u0004\u0003\u0002C6\tcj!\u0001\"\u001c\u000b\t\u0011=\u0014QU\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002C:\t[\u0012qaU3sm&\u001cW\r")
public class ArchivingService
implements ArchivedReleaseReader {
    private final ArchivedReleases archivedReleases;
    private final ArchivedReleasesSearch archivedReleasesSearch;
    private final ArchivedActivityLogsSerializer archivedActivityLogsSerializer;
    private final RepositoryAdapter repositoryAdapter;
    private final CompletedReleaseExportService completedReleasesExportService;
    private final ReleaseRepository releaseRepository;
    private final DependencyRepository dependencyRepository;
    private final ReleaseActorService releaseActorService;
    private final TeamRepository teamRepository;
    private final SecuredCis securedCis;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final CommentService commentService;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String getMonthYear(DateTime startDate) {
        return ArchivingService$.MODULE$.getMonthYear(startDate);
    }

    @Override
    public Option<Release> getReleaseOption(String releaseId, boolean includePreArchived, ConfigurationItemConverter ciConverter) {
        return ArchivedReleaseReader.getReleaseOption$(this, releaseId, includePreArchived, ciConverter);
    }

    @Override
    public boolean getReleaseOption$default$2() {
        return ArchivedReleaseReader.getReleaseOption$default$2$(this);
    }

    @Override
    public ConfigurationItemConverter getReleaseOption$default$3() {
        return ArchivedReleaseReader.getReleaseOption$default$3$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Release deserializeArchivedRelease(String releaseJson, RepositoryAdapter repository, ConfigurationItemConverter ciConverter) {
        return ArchivedReleaseDeserialization.deserializeArchivedRelease$(this, releaseJson, repository, ciConverter);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingService archivingService = this;
        synchronized (archivingService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public RepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Timed
    public void archiveRelease(String releaseId) {
        Release release = (Release)this.repositoryAdapter().read(releaseId);
        if (release == null) {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(62).append("Release '").append(releaseId).append("' cannot be read from active database, not archiving.").toString());
            if (this.releaseRepository.exists(releaseId) || !this.existsPreArchived(releaseId)) return;
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(87).append("Setting Release '").append(releaseId).append("' preArchived flag to false as it is no longer in the active database.").toString());
            this.archivedReleases().setPreArchived(releaseId, false);
            return;
        } else if (!this.shouldArchive(release)) {
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(57).append("Removing non archive-able release '").append(releaseId).append("' from active database").toString());
            this.deleteRelease(releaseId, release);
            return;
        } else if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])ReleaseStatus.INACTIVE_STATUSES), (Object)release.getStatus())) {
            if (!this.existsPreArchived(releaseId)) throw new IllegalStateException("Only pre-archived releases can be archived");
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(29).append("Archiving dependencies for '").append(releaseId).append("'").toString());
            this.releaseExtensionsRepository.decorate(release);
            CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                this.commentService.decorate(task);
                return BoxedUnit.UNIT;
            });
            java.util.List<Team> updatedTeams = this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId()));
            release.setTeams(updatedTeams);
            scala.collection.immutable.Seq<Facet> facets = ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).genericRepository().findAllFacetsByRelease(release);
            CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                task.setFacets(new ArrayList(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveRelease$7(task, x$1)))).asJava()));
                return BoxedUnit.UNIT;
            });
            this.archiveAttachments(release);
            this.archiveDependencies(release);
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(45).append("Updating activity logs and releaseJson for '").append(releaseId).append("'").toString());
            String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
            String activityLogsJson = this.archivedActivityLogsSerializer.serializeActivityLogsOf(release.getId());
            if (!this.archivedReleases().update(releaseId, serializedRelease, activityLogsJson, false)) {
                this.logger().warn((Function0 & Serializable)() -> new StringBuilder(37).append("Could not update archived Release '").append(releaseId).append("'.").toString());
            } else {
                this.archivedReleases().updateViewers(releaseId, (scala.collection.immutable.Seq<Team>)CollectionConverters$.MODULE$.ListHasAsScala(updatedTeams).asScala().toSeq());
            }
            this.deleteRelease(releaseId, release);
            return;
        } else {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(52).append("Trying to pre-archive a release with invalid status ").append(release.getStatus()).toString());
            throw new IllegalStateException("Only inactive releases can be archived");
        }
    }

    private void deleteRelease(String releaseId, Release release) {
        block0: {
            if (!this.releaseRepository.exists(releaseId)) break block0;
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(32).append("Deleting '").append(releaseId).append("' from active database").toString());
            this.releaseRepository.delete(releaseId, this.releaseRepository.delete$default$2());
            ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).findAllFacetsByRelease(release).foreach((Function1 & Serializable)facet -> {
                ArchivingService.$anonfun$deleteRelease$2(this, facet);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void archiveAttachments(Release release) {
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(28).append("Archiving attachments for '").append(release.getId()).append("'").toString());
        Option previousWorkDirContext = Option$.MODULE$.apply((Object)WorkDirContext.get());
        WorkDirContext.initWorkdir();
        try {
            CollectionConverters$.MODULE$.ListHasAsScala(release.getAttachments()).asScala().foreach((Function1 & Serializable)attachment -> {
                ArchivingService.$anonfun$archiveAttachments$2(this, release, attachment);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            Option$.MODULE$.apply((Object)WorkDirContext.get()).foreach((Function1 & Serializable)x$2 -> {
                x$2.delete();
                return BoxedUnit.UNIT;
            });
            WorkDirContext.clear();
            previousWorkDirContext.foreach((Function1 & Serializable)x$1 -> {
                ArchivingService.$anonfun$archiveAttachments$6(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void archiveDependencies(Release release) {
        scala.collection.immutable.Seq<Dependency> archivedDependencies = this.archiveAllOutgoingDependencies(release);
        this.dependencyRepository.archive(release, archivedDependencies);
        this.archiveAllIncomingDependencies(release.getId());
    }

    @Timed
    public boolean deletePreArchiveRelease(String releaseId) {
        return this.archivedReleases().deleteReleaseFromArchive(releaseId);
    }

    @Timed
    public void preArchiveRelease(Release release) {
        if (this.existsPreArchived(release.getId())) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(39).append(release).append(" is already pre-archived, nothing to do").toString());
        } else {
            scala.collection.immutable.Seq<Facet> facets = ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).genericRepository().findAllFacetsByRelease(release);
            CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                task.setFacets(new ArrayList(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$preArchiveRelease$3(task, x$3)))).asJava()));
                return BoxedUnit.UNIT;
            });
            release.setTeams(this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId())));
            String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
            if (this.shouldArchive(release)) {
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(60).append("copying release ").append(release).append(" to archive database, marked as pre-archived").toString());
                this.archivedReleases().insert(release, serializedRelease, "", true);
                scala.collection.immutable.Set<Type> specialTypes = this.facetRepositoryDispatcher.supportedTypes();
                ((IterableOnceOps)((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).findAllFacetsByRelease(release).filter((Function1 & Serializable)facet -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$preArchiveRelease$5(specialTypes, facet)))).foreach((Function1 & Serializable)liveFacet -> $this.facetRepositoryDispatcher.archiveRepository().create((Facet)liveFacet));
                this.releaseRepository.setPreArchived(release.getId(), true);
            }
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(37).append("Running release ").append(release.getId()).append(" through export hooks").toString());
            this.completedReleasesExportService.sendThroughExportHooks(release, serializedRelease);
        }
    }

    public boolean shouldArchive(Release release) {
        return !release.isTutorial() && release.isArchiveRelease();
    }

    public Release getRelease(String releaseId) {
        return this.getRelease(releaseId, false);
    }

    @Timed
    public Release getRelease(String releaseId, boolean includePreArchived) {
        return (Release)this.getReleaseOption(releaseId, includePreArchived, this.getReleaseOption$default$3()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public String getReleaseTitle(String releaseId) {
        return (String)this.archivedReleases().getReleaseTitle(releaseId, this.archivedReleases().getReleaseTitle$default$2()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Phase getPhase(String phaseId) {
        return (Phase)this.getReleaseItem(phaseId, (Function1 & Serializable)x$4 -> (Function1 & Serializable)x$1 -> x$4.getPhase(x$1)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)phaseId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Task getTask(String taskId) {
        return (Task)this.getReleaseItem(taskId, (Function1 & Serializable)x$5 -> (Function1 & Serializable)x$1 -> x$5.getTask(x$1)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)taskId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Variable getVariable(String variableId) {
        return (Variable)this.getVariableOption(variableId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)variableId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public boolean exists(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().exists(ciId) : (Ids.isPhaseId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable)x$6 -> (Function1 & Serializable)x$1 -> x$6.getPhase(x$1)).isDefined() : (Ids.isTaskId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable)x$7 -> (Function1 & Serializable)x$1 -> x$7.getTask(x$1)).isDefined() : (Ids.isVariableId((String)ciId) ? this.getVariableOption(ciId).isDefined() : false)));
    }

    @Timed
    public boolean existsPreArchived(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().existsPreArchived(ciId) : false;
    }

    @Timed
    public boolean existsByName(String releaseName) {
        return this.archivedReleases().existsByName(releaseName);
    }

    @Timed
    public boolean attachmentExists(String attachmentId) {
        return this.archivedReleases().attachmentExists(attachmentId);
    }

    @Timed
    public Attachment getAttachment(String attachmentId) {
        return (Attachment)this.getAttachmentOption(attachmentId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(37).append("Could not find archived attachment [").append(attachmentId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Option<Attachment> getAttachmentOption(String attachmentId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)attachmentId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)release -> Option$.MODULE$.apply((Object)release.getAttachment(attachmentId)).flatMap((Function1 & Serializable)attachment -> this.archivedReleases().getAttachment(attachmentId).map((Function1 & Serializable)overthereFile -> {
            attachment.setFile(overthereFile);
            return attachment;
        })));
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters) {
        return this.searchReleases(filters, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters, long limit, long offset) {
        return this.searchReleases(filters, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)limit)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    @Timed
    public List<Tuple2<AdaptiveReleaseId, Object>> findShortReleaseIdsWithFolderNameAndOrderCriterion(scala.collection.immutable.Seq<ReportFilter> filters, Option<ReleaseOrderMode> order, Option<Object> limit, Option<Object> offset) {
        return this.archivedReleasesSearch.searchReleaseIdsAndOrderCriterion(filters, order, limit, offset);
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$4() {
        return None$.MODULE$;
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleasesByStatus(ReleasesFilters filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleases(scala.collection.immutable.Seq<ReportFilter> filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public scala.collection.immutable.Seq<String> findArchivableReleaseIds(Date date, Integer pageSize) {
        return this.archivedReleases().findArchivableReleaseIds(date, Predef$.MODULE$.Integer2int(pageSize));
    }

    @Timed
    public scala.collection.immutable.Seq<String> findPurgableReleaseIds(Date date, Integer pageSize) {
        return this.archivedReleases().findPurgableReleaseIds(date, Predef$.MODULE$.Integer2int(pageSize));
    }

    @Timed
    public void purgeArchivedRelease(String releaseId) {
        this.archivedReleases().deleteReleaseFromArchive(releaseId);
    }

    @Timed
    public void archiveAllIncomingDependencies(String releaseId) {
        scala.collection.immutable.Seq<Dependency> incomingDependencies = this.dependencyRepository.findAllIncomingDependencies((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{releaseId}))), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), true);
        incomingDependencies.groupBy((Function1 & Serializable)d -> Ids.normalizeId((String)Ids.releaseIdFrom((String)d.getId()))).foreach((Function1 & Serializable)x0$1 -> {
            ArchivingService.$anonfun$archiveAllIncomingDependencies$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.archivedReleases().findAllTags(limitNumber)).asJava();
    }

    private java.util.List<Release> searchReleases(ReleasesFilters filters, Option<Object> limit, Option<Object> offset) {
        List<String> releaseJsons = this.archivedReleasesSearch.searchReleases(filters, limit, offset);
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)releaseJsons.map((Function1 & Serializable)json -> this.deserializeArchivedRelease((String)json, this.repositoryAdapter(), CiSerializerHelper$.MODULE$.newEncryptingConverter()))).asJava();
    }

    public scala.collection.immutable.Seq<Release> searchReleasesByReleaseIds(scala.collection.immutable.Seq<String> releaseIds) {
        scala.collection.immutable.Seq<String> releaseJsons = this.archivedReleasesSearch.searchReleasesByIds(releaseIds);
        return (scala.collection.immutable.Seq)releaseJsons.map((Function1 & Serializable)json -> this.deserializeArchivedRelease((String)json, this.repositoryAdapter(), CiSerializerHelper$.MODULE$.newEncryptingConverter()));
    }

    public scala.collection.immutable.Seq<ReleaseBasicDataExt> searchReleasesBasicExtByReleaseIds(scala.collection.immutable.Seq<String> releaseIds) {
        return this.archivedReleasesSearch.searchReleasesBasicInfoByIds((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)releaseIds.map((Function1 & Serializable)x$9 -> FullReleaseId$.MODULE$.apply((String)x$9).withOnlyOneParentOrApplicationsForArchiveDb())));
    }

    private <T extends PlanItem> Option<T> getReleaseItem(String itemId, Function1<Release, Function1<String, T>> getItem) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)itemId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)r -> Option$.MODULE$.apply(((Function1)getItem.apply(r)).apply((Object)itemId)));
    }

    private Option<Variable> getVariableOption(String variableId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)variableId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)release -> CollectionConverters$.MODULE$.ListHasAsScala(release.getVariables()).asScala().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$getVariableOption$2(variableId, x$10))));
    }

    private scala.collection.immutable.Seq<Dependency> archiveAllOutgoingDependencies(Release release) {
        Buffer dependencies = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$11 -> CollectionConverters$.MODULE$.ListHasAsScala(x$11.getDependencies()).asScala())).filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveAllOutgoingDependencies$2(x$12)));
        dependencies.foreach((Function1 & Serializable)x$13 -> {
            x$13.archive();
            return BoxedUnit.UNIT;
        });
        return dependencies.toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$archiveRelease$7(Task task$1, Facet x$1) {
        String string = x$1.getTargetId();
        String string2 = task$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$deleteRelease$2(ArchivingService $this, Facet facet) {
        ((FacetRepository.FacetTypeDispatcher)((Object)$this.facetRepositoryDispatcher.liveRepository())).delete(facet.getId(), ((FacetRepository.FacetTypeDispatcher)((Object)$this.facetRepositoryDispatcher.liveRepository())).delete$default$2());
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$4(ArchivingService $this, Release release$2, Attachment attachment$1, InputStream data) {
        try {
            $this.archivedReleases().insertAttachment(release$2.getId(), new ArchivedReleases.AttachmentInfo(attachment$1.getId(), attachment$1.getFile().getName(), data));
        }
        finally {
            data.close();
        }
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$2(ArchivingService $this, Release release$2, Attachment attachment) {
        Try$.MODULE$.apply((Function0 & Serializable)() -> attachment.getFile().getInputStream()).foreach((Function1 & Serializable)data -> {
            ArchivingService.$anonfun$archiveAttachments$4($this, release$2, attachment, data);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$6(WorkDir x$1) {
        WorkDirContext.setWorkDir((WorkDir)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$preArchiveRelease$3(Task task$2, Facet x$3) {
        String string = x$3.getTargetId();
        String string2 = task$2.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$preArchiveRelease$5(scala.collection.immutable.Set specialTypes$1, Facet facet) {
        Type type = facet.getType();
        return specialTypes$1.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)type.instanceOf(x$1)));
    }

    public static final /* synthetic */ void $anonfun$archiveAllIncomingDependencies$2(ArchivingService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String referencingReleaseId = (String)tuple2._1();
        scala.collection.immutable.Seq rawDependenciesToArchive = (scala.collection.immutable.Seq)tuple2._2();
        $this.releaseActorService.archiveDependencies(referencingReleaseId, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)rawDependenciesToArchive.map((Function1 & Serializable)x$8 -> x$8.getId())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getVariableOption$2(String variableId$2, Variable x$10) {
        String string = x$10.getId();
        String string2 = variableId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$archiveAllOutgoingDependencies$2(Dependency x$12) {
        return !x$12.isArchived();
    }

    @Autowired
    public ArchivingService(ArchivedReleases archivedReleases, ArchivedReleasesSearch archivedReleasesSearch, ArchivedActivityLogsSerializer archivedActivityLogsSerializer, RepositoryAdapter repositoryAdapter, CompletedReleaseExportService completedReleasesExportService, ReleaseRepository releaseRepository, DependencyRepository dependencyRepository, ReleaseActorService releaseActorService, TeamRepository teamRepository, SecuredCis securedCis, ReleaseExtensionsRepository releaseExtensionsRepository, CommentService commentService, FacetRepositoryDispatcher facetRepositoryDispatcher) {
        this.archivedReleases = archivedReleases;
        this.archivedReleasesSearch = archivedReleasesSearch;
        this.archivedActivityLogsSerializer = archivedActivityLogsSerializer;
        this.repositoryAdapter = repositoryAdapter;
        this.completedReleasesExportService = completedReleasesExportService;
        this.releaseRepository = releaseRepository;
        this.dependencyRepository = dependencyRepository;
        this.releaseActorService = releaseActorService;
        this.teamRepository = teamRepository;
        this.securedCis = securedCis;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.commentService = commentService;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        ArchivedReleaseDeserialization.$init$(this);
        Logging.$init$((Logging)this);
        ArchivedReleaseReader.$init$(this);
        facetRepositoryDispatcher.setupGenericFacetArchiveRepository(this);
    }
}

