/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.DependencyBuilder;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseRepository;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyCandidateCollector;
import com.xebialabs.xlrelease.service.IdAndStatus;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseTreeBuilder;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.ReleaseTreeItem;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\tef\u0001\u0002\u0016,\u0001QB\u0001B\u0013\u0001\u0003\u0006\u0004%\ta\u0013\u0005\t%\u0002\u0011\t\u0011)A\u0005\u0019\"A1\u000b\u0001BC\u0002\u0013\u0005A\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003V\u0011!I\u0006A!b\u0001\n\u0003Q\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011}\u0003!Q1A\u0005\u0002\u0001D\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tK\u0002\u0011)\u0019!C\u0001M\"AQ\u000e\u0001B\u0001B\u0003%q\r\u0003\u0005o\u0001\t\u0015\r\u0011\"\u0001p\u0011!\u0019\bA!A!\u0002\u0013\u0001\b\u0002\u0003;\u0001\u0005\u000b\u0007I\u0011A;\t\u0011e\u0004!\u0011!Q\u0001\nYD\u0001B\u001f\u0001\u0003\u0006\u0004%\ta\u001f\u0005\t\u007f\u0002\u0011\t\u0011)A\u0005y\"Q\u0011\u0011\u0001\u0001\u0003\u0006\u0004%\t!a\u0001\t\u0015\u0005-\u0001A!A!\u0002\u0013\t)\u0001C\u0004\u0002\u000e\u0001!\t!a\u0004\t\u0013\u0005\r\u0003A1A\u0005\u0002\u0005\u0015\u0003\u0002CA8\u0001\u0001\u0006I!a\u0012\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!9\u00111\u0015\u0001\u0005\u0002\u0005\u0015\u0006bBAX\u0001\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003\u0013\u0004A\u0011AAf\u0011\u001d\ty\u000e\u0001C\u0001\u0003CDq!!?\u0001\t\u0003\tY\u0010C\u0004\u0003\u0004\u0001!IA!\u0002\t\u000f\t%\u0001\u0001\"\u0001\u0003\f!9!1\u0003\u0001\u0005\n\tU\u0001\"\u0003B\u0015\u0001E\u0005I\u0011\u0002B\u0016\u0011%\u0011y\u0004AI\u0001\n\u0013\u0011\t\u0005C\u0004\u0003F\u0001!\tAa\u0012\t\u000f\t5\u0003\u0001\"\u0003\u0003P!9!Q\u000b\u0001\u0005\u0002\t]\u0003b\u0002B5\u0001\u0011\u0005!1\u000e\u0005\b\u0005{\u0002A\u0011\u0001B@\u0011\u001d\u0011I\t\u0001C\u0001\u0005\u0017CqA!'\u0001\t\u0013\u0011Y\nC\u0004\u0003 \u0002!\tB!)\t\u000f\t\u0015\u0006\u0001\"\u0005\u0003(\n\tB)\u001a9f]\u0012,gnY=TKJ4\u0018nY3\u000b\u00051j\u0013aB:feZL7-\u001a\u0006\u0003]=\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005A\n\u0014!\u0003=fE&\fG.\u00192t\u0015\u0005\u0011\u0014aA2p[\u000e\u00011#\u0002\u00016w}\u0012\u0005C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$AB!osJ+g\r\u0005\u0002={5\t1&\u0003\u0002?W\t\u0011\"+\u001a7fCN,GK]3f\u0005VLG\u000eZ3s!\ta\u0004)\u0003\u0002BW\taB)\u001a9f]\u0012,gnY=DC:$\u0017\u000eZ1uK\u000e{G\u000e\\3di>\u0014\bCA\"I\u001b\u0005!%BA#G\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00059\u0015\u0001C4sSjTH.\u001a3\n\u0005%#%a\u0002'pO\u001eLgnZ\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JLX#\u0001'\u0011\u00055\u0003V\"\u0001(\u000b\u0005=k\u0013A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011\u0011K\u0014\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018A\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0002\nAC]3mK\u0006\u001cXmU3be\u000eD7+\u001a:wS\u000e,W#A+\u0011\u0005q2\u0016BA,,\u0005Q\u0011V\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dK\u0006)\"/\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\u0004\u0013A\u00059mC:LE/Z7SKB|7/\u001b;pef,\u0012a\u0017\t\u0003\u001brK!!\u0018(\u0003%Ac\u0017M\\%uK6\u0014V\r]8tSR|'/_\u0001\u0014a2\fg.\u0013;f[J+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0015I\u0016\u0004XM\u001c3f]\u000eL(+\u001a9pg&$xN]=\u0016\u0003\u0005\u0004\"!\u00142\n\u0005\rt%\u0001\u0006#fa\u0016tG-\u001a8dsJ+\u0007o\\:ji>\u0014\u00180A\u000beKB,g\u000eZ3oGf\u0014V\r]8tSR|'/\u001f\u0011\u0002\u0011\u00154XM\u001c;CkN,\u0012a\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003U6\na!\u001a<f]R\u001c\u0018B\u00017j\u0005!)e/\u001a8u\u0005V\u001c\u0018!C3wK:$()^:!\u00039!\u0018m]6SKB|7/\u001b;pef,\u0012\u0001\u001d\t\u0003\u001bFL!A\u001d(\u0003\u001dQ\u000b7o\u001b*fa>\u001c\u0018\u000e^8ss\u0006yA/Y:l%\u0016\u0004xn]5u_JL\b%A\bqQ\u0006\u001cXMU3q_NLGo\u001c:z+\u00051\bCA'x\u0013\tAhJA\bQQ\u0006\u001cXMU3q_NLGo\u001c:z\u0003A\u0001\b.Y:f%\u0016\u0004xn]5u_JL\b%A\u0006dS&#7+\u001a:wS\u000e,W#\u0001?\u0011\u0005qj\u0018B\u0001@,\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002\u0019\rL\u0017\nZ*feZL7-\u001a\u0011\u0002!\u0005\u00148\r[5wS:<7+\u001a:wS\u000e,WCAA\u0003!\ra\u0014qA\u0005\u0004\u0003\u0013Y#\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0003E\t'o\u00195jm&twmU3sm&\u001cW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015)\u0005E\u00111CA\u000b\u0003/\tI\"a\u0007\u0002\u001e\u0005}\u0011\u0011EA\u0012!\ta\u0004\u0001C\u0003K'\u0001\u0007A\nC\u0003T'\u0001\u0007Q\u000bC\u0003Z'\u0001\u00071\fC\u0003`'\u0001\u0007\u0011\rC\u0003f'\u0001\u0007q\rC\u0003o'\u0001\u0007\u0001\u000fC\u0003u'\u0001\u0007a\u000fC\u0003{'\u0001\u0007A\u0010C\u0004\u0002\u0002M\u0001\r!!\u0002)\u0007M\t9\u0003\u0005\u0003\u0002*\u0005}RBAA\u0016\u0015\u0011\ti#a\f\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u00022\u0005M\u0012a\u00024bGR|'/\u001f\u0006\u0005\u0003k\t9$A\u0003cK\u0006t7O\u0003\u0003\u0002:\u0005m\u0012aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005u\u0012aA8sO&!\u0011\u0011IA\u0016\u0005%\tU\u000f^8xSJ,G-\u0001\rbGRLg/\u001a#fa\u0016tG-\u001a8dsN#\u0018\r^;tKN,\"!a\u0012\u0011\r\u0005%\u0013\u0011LA0\u001d\u0011\tY%!\u0016\u000f\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u00154\u0003\u0019a$o\\8u}%\t\u0001(C\u0002\u0002X]\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\\\u0005u#aA*fc*\u0019\u0011qK\u001c\u0011\t\u0005\u0005\u0014\u0011\u000e\b\u0005\u0003G\n)\u0007E\u0002\u0002N]J1!a\u001a8\u0003\u0019\u0001&/\u001a3fM&!\u00111NA7\u0005\u0019\u0019FO]5oO*\u0019\u0011qM\u001c\u00023\u0005\u001cG/\u001b<f\t\u0016\u0004XM\u001c3f]\u000eL8\u000b^1ukN,7\u000fI\u0001\u0007GJ,\u0017\r^3\u0015\r\u0005U\u0014\u0011QAF!\u0011\t9(! \u000e\u0005\u0005e$bAA>[\u00051Am\\7bS:LA!a \u0002z\tQA)\u001a9f]\u0012,gnY=\t\u000f\u0005\re\u00031\u0001\u0002\u0006\u0006!q-\u0019;f!\u0011\t9(a\"\n\t\u0005%\u0015\u0011\u0010\u0002\t\u000f\u0006$X\rV1tW\"9\u0011Q\u0012\fA\u0002\u0005}\u0013A\u0005;be\u001e,G/\u00133PeZ\u000b'/[1cY\u0016D3AFAI!\u0011\t\u0019*a(\u000e\u0005\u0005U%\u0002BA\u0017\u0003/SA!!'\u0002\u001c\u00069Q.\u001a;sS\u000e\u001c(bAAOc\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002\"\u0006U%!\u0002+j[\u0016$\u0017\u0001D;qI\u0006$X\rV1sO\u0016$HCBA;\u0003O\u000bY\u000bC\u0004\u0002*^\u0001\r!a\u0018\u0002\u0019\u0011,\u0007/\u001a8eK:\u001c\u00170\u00133\t\u000f\u00055u\u00031\u0001\u0002`!\u001aq#!%\u0002\r\u0011,G.\u001a;f)\u0019\t\u0019,!/\u0002DB\u0019a'!.\n\u0007\u0005]vG\u0001\u0003V]&$\bbBA^1\u0001\u0007\u0011QX\u0001\be\u0016dW-Y:f!\u0011\t9(a0\n\t\u0005\u0005\u0017\u0011\u0010\u0002\b%\u0016dW-Y:f\u0011\u001d\t)\r\u0007a\u0001\u0003?\n!!\u001b3)\u0007a\t\t*A\u000bhKR\u001cu.\u001c9mKR\f'\r\\3HCR,\u0017\nZ:\u0015\t\u0005\u001d\u0013Q\u001a\u0005\b\u0003\u001fL\u0002\u0019AAi\u0003\u001d!\u0018M]4fiN\u0004b!!\u0019\u0002T\u0006]\u0017\u0002BAk\u0003[\u00121aU3u!\u0011\t9(!7\n\t\u0005m\u0017\u0011\u0010\u0002\t!2\fg.\u0013;f[\"\u001a\u0011$!%\u00023\u0019Lg\u000eZ!di&4X-\u00138d_6LgnZ$bi\u0016LEm\u001d\u000b\u0005\u0003G\f\u0019\u0010\u0005\u0004\u0002f\u0006=\u0018qL\u0007\u0003\u0003OTA!!;\u0002l\u0006!Q\u000f^5m\u0015\t\ti/\u0001\u0003kCZ\f\u0017\u0002BAy\u0003O\u0014A\u0001T5ti\"9\u0011Q\u001f\u000eA\u0002\u0005}\u0013!\u0003:fY\u0016\f7/Z%eQ\rQ\u0012\u0011S\u0001,M&tG-Q2uSZ,\u0017J\\2p[&twmR1uK&#7oV5uQ>,H/\u0012=jgR\u001c8\t[3dWR!\u0011qIA\u007f\u0011\u001d\typ\u0007a\u0001\u0003?\n\u0001\u0002]1sK:$\u0018\n\u001a\u0015\u00047\u0005E\u0015a\u00073p\r&tG-Q2uSZ,\u0017J\\2p[&twmR1uK&#7\u000f\u0006\u0003\u0002H\t\u001d\u0001bBA\u00009\u0001\u0007\u0011qL\u0001\u0013O\u0016$h)Y5mC\ndWmR1uK&#7\u000f\u0006\u0003\u0002H\t5\u0001b\u0002B\b;\u0001\u0007\u0011\u0011[\u0001\u000fC\n|'\u000f^3e)\u0006\u0014x-\u001a;tQ\ri\u0012\u0011S\u0001\u001dM&tG-\u00117m\u0013:\u001cw.\\5oO\u0012+\u0007/\u001a8eK:\u001c\u00170\u00133t)!\t9Ea\u0006\u0003\u001c\t}\u0001b\u0002B\r=\u0001\u0007\u0011qI\u0001\ni\u0006\u0014x-\u001a;JIND\u0011B!\b\u001f!\u0003\u0005\r!a\u0012\u0002\u0011M$\u0018\r^;tKND\u0011B!\t\u001f!\u0003\u0005\rAa\t\u0002'I,g-\u001a:f]\u000eLgnZ\"iS2$'/\u001a8\u0011\u0007Y\u0012)#C\u0002\u0003(]\u0012qAQ8pY\u0016\fg.\u0001\u0014gS:$\u0017\t\u001c7J]\u000e|W.\u001b8h\t\u0016\u0004XM\u001c3f]\u000eL\u0018\nZ:%I\u00164\u0017-\u001e7uII*\"A!\f+\t\u0005\u001d#qF\u0016\u0003\u0005c\u0001BAa\r\u0003<5\u0011!Q\u0007\u0006\u0005\u0005o\u0011I$A\u0005v]\u000eDWmY6fI*\u0019\u0011QF\u001c\n\t\tu\"Q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\n4j]\u0012\fE\u000e\\%oG>l\u0017N\\4EKB,g\u000eZ3oGfLEm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\t\u0016\u0005\u0005G\u0011y#A\u000egS:$\u0017i\u0019;jm\u0016|U\u000f^4pS:<G+\u0019:hKRLEm\u001d\u000b\u0005\u0003G\u0014I\u0005C\u0004\u0002v\u0006\u0002\r!a\u0018)\u0007\u0005\n\t*A\rgS:$\u0017i\u0019;jm\u0016|U\u000f^4pS:<G+\u0019:hKR\u001cH\u0003\u0002B)\u0005'\u0002b!!\u0013\u0002Z\u0005]\u0007bBA{E\u0001\u0007\u0011qL\u0001\u000fO\u0016$(+\u001a7fCN,GK]3f)\u0011\u0011IF!\u001a\u0011\t\tm#\u0011M\u0007\u0003\u0005;R1Aa\u0018.\u0003\u00151\u0018.Z<t\u0013\u0011\u0011\u0019G!\u0018\u0003\u0017I+G.Z1tKR\u0013X-\u001a\u0005\b\u0003k\u001c\u0003\u0019AA0Q\r\u0019\u0013\u0011S\u0001\u001ckB$\u0017\r^3HCR,'+\u001a4fe\u0016t7-\u001b8h!\"\f7/Z:\u0015\r\u0005M&Q\u000eB9\u0011\u001d\u0011y\u0007\na\u0001\u0003?\naaZ1uK&#\u0007b\u0002B:I\u0001\u0007!QO\u0001\u0011_JLw-\u001b8U_J+7\u000f^8sK\u0012\u0004\u0002\"!:\u0003x\u0005]\u0017q[\u0005\u0005\u0005s\n9OA\u0002NCBD3\u0001JAI\u0003M\t'o\u00195jm\u0016$U\r]3oI\u0016t7-[3t)\u0019\t\u0019L!!\u0003\u0004\"9\u0011Q_\u0013A\u0002\u0005}\u0003b\u0002BCK\u0001\u0007\u0011qI\u0001\u000eI\u0016\u0004XM\u001c3f]\u000eL\u0018\nZ:)\u0007\u0015\n\t*\u0001\u0010gS:$G)\u001a9f]\u0012,gnY=UCJ<W\r\u001e\"z)\u0006\u0014x-\u001a;JIR!!Q\u0012BJ!\ra$qR\u0005\u0004\u0005#[#aC%e\u0003:$7\u000b^1ukNDqA!&'\u0001\u0004\ty&\u0001\u0005uCJ<W\r^%eQ\r1\u0013\u0011S\u0001\nO\u0016$8\u000b^1ukN$B!a\u0018\u0003\u001e\"9!QS\u0014A\u0002\u0005}\u0013!\b4j]\u0012Le\u000e\u0015:pOJ,7o]%oG>l\u0017N\\4HCR,\u0017\nZ:\u0015\t\u0005\u001d#1\u0015\u0005\b\u00053A\u0003\u0019AA$\u0003)I7\u000fV3na2\fG/\u001a\u000b\u0005\u0005G\u0011I\u000bC\u0004\u0002*&\u0002\r!a\u0018)\u0007\u0001\u0011i\u000b\u0005\u0003\u00030\nUVB\u0001BY\u0015\u0011\u0011\u0019,a\u000e\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u00038\nE&aB*feZL7-\u001a")
public class DependencyService
implements ReleaseTreeBuilder,
DependencyCandidateCollector,
Logging {
    private final ReleaseRepository releaseRepository;
    private final ReleaseSearchService releaseSearchService;
    private final PlanItemRepository planItemRepository;
    private final DependencyRepository dependencyRepository;
    private final EventBus eventBus;
    private final TaskRepository taskRepository;
    private final PhaseRepository phaseRepository;
    private final CiIdService ciIdService;
    private final ArchivingService archivingService;
    private final scala.collection.immutable.Seq<String> activeDependencyStatuses;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public List<Dependency> findByReleaseId(String releaseId) {
        return DependencyCandidateCollector.findByReleaseId$(this, releaseId);
    }

    @Override
    @Timed
    public List<Release> findAllDependencyCandidates(String gateId) {
        return DependencyCandidateCollector.findAllDependencyCandidates$(this, gateId);
    }

    @Override
    @Timed
    public Release getDependencyCandidate(String gateId, String targetReleaseId) {
        return DependencyCandidateCollector.getDependencyCandidate$(this, gateId, targetReleaseId);
    }

    @Override
    public scala.collection.immutable.Seq<String> getReferencedCis(String gateReleaseId) {
        return DependencyCandidateCollector.getReferencedCis$(this, gateReleaseId);
    }

    @Override
    public boolean isReferencable(PlanItem planItem, scala.collection.immutable.Seq<String> referencedIds) {
        return DependencyCandidateCollector.isReferencable$(this, planItem, referencedIds);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, PlanItem item) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, item);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, TaskGroup taskGroup) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, taskGroup);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, GateTask gateTask) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, gateTask);
    }

    @Override
    public Object loadDependentRelease(Dependency dependency, String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.loadDependentRelease$(this, dependency, releaseId, dependentReleases);
    }

    @Override
    public PartialFunction<Task, ReleaseTreeItem> taskMatcher(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.taskMatcher$(this, releaseId, dependentReleases);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    public PlanItemRepository planItemRepository() {
        return this.planItemRepository;
    }

    @Override
    public DependencyRepository dependencyRepository() {
        return this.dependencyRepository;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public PhaseRepository phaseRepository() {
        return this.phaseRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public scala.collection.immutable.Seq<String> activeDependencyStatuses() {
        return this.activeDependencyStatuses;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dependency create(GateTask gate, String targetIdOrVariable) {
        void var3_3;
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't add a dependency to a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkCreateDependency((Task)gate);
        Dependency dependency = DependencyBuilder.newDependency().withId(this.ciIdService().getUniqueId(Type.valueOf(Dependency.class), gate.getId())).build();
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
        } else {
            Object target = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTarget(target);
        }
        gate.addDependency(dependency);
        dependency.setGateTask(gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().create(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyCreatedEvent(dependency));
        return var3_3;
    }

    @Timed
    public Dependency updateTarget(String dependencyId, String targetIdOrVariable) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't edit a dependency on a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkUpdateDependency((Task)gate);
        Dependency dependency = gate.getDependencies().stream().filter(d -> {
            String string = dependencyId;
            String string2 = d.getId();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).findFirst().orElseThrow(() -> new NotFoundException(String.format("Dependency with Id '%s' not found.", dependencyId), new Object[0]));
        Dependency original = CiCloneHelper.cloneCi(dependency);
        Checks.checkArgument((!dependency.isDone() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be updated", (Object[])new Object[0]);
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(null);
        } else {
            Object newTarget = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(newTarget);
        }
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().update(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, dependency));
        return dependency;
    }

    @Timed
    public void delete(Release release, String id) {
        Option maybeDependency = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(x$2.getDependencies()).asScala())).find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DependencyService.$anonfun$delete$2(id, x$3)));
        Dependency dependency = (Dependency)maybeDependency.getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(id).append("] not found").toString(), new Object[0]);
        });
        GateTask gate = dependency.getGateTask();
        LockedTaskOperationChecks$.MODULE$.checkDeleteDependency((Task)gate);
        Checks.checkArgument((!dependency.isDone() || gate.isPlanned() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be deleted", (Object[])new Object[0]);
        this.dependencyRepository().delete(dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyDeletedEvent(dependency));
    }

    @Timed
    public scala.collection.immutable.Seq<String> getCompletableGateIds(Set<PlanItem> targets) {
        scala.collection.immutable.Seq doneTargetIds = ((IterableOnceOps)((IterableOps)targets.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDone()))).map((Function1 & Serializable)x$5 -> x$5.getId())).toSeq();
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(37).append("getCompletableGateIds doneTargetIds: ").append(doneTargetIds.mkString(", ")).toString());
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)doneTargetIds).map((Function1 & Serializable)id -> {
            void var2_2;
            GateTask item = (GateTask)this.taskRepository().findById((String)id);
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(87).append("getCompletableGateIds item ").append(item.getId()).append(": hasConditions = ").append(item.hasConditions()).append(", hasDependencies = ").append(item.hasDependencies()).append(", isOpen = ").append(item.isOpen()).append(", status = ").append(item.getStatus()).toString());
            return var2_2;
        })).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isCompletable()))).map((Function1 & Serializable)x$7 -> x$7.getId());
    }

    @Timed
    public List<String> findActiveIncomingGateIds(String releaseId) {
        Seq seq;
        if (this.releaseRepository().exists(releaseId)) {
            seq = this.doFindActiveIncomingGateIds(releaseId);
        } else {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(87).append("Release ").append(releaseId).append(" not found. It is either archived, or does not exist. Returning no dependencies").toString());
            seq = (Seq)package$.MODULE$.Seq().empty();
        }
        return CollectionConverters$.MODULE$.SeqHasAsJava(seq).asJava();
    }

    @Timed
    public scala.collection.immutable.Seq<String> findActiveIncomingGateIdsWithoutExistsCheck(String parentId) {
        return this.doFindActiveIncomingGateIds(parentId);
    }

    private scala.collection.immutable.Seq<String> doFindActiveIncomingGateIds(String parentId) {
        return (scala.collection.immutable.Seq)((SeqOps)((IterableOps)this.findAllIncomingDependencyIds((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{parentId}))), this.activeDependencyStatuses(), true).filterNot((Function1 & Serializable)dependencyId -> BoxesRunTime.boxToBoolean((boolean)this.isTemplate(dependencyId)))).map((Function1 & Serializable)x$1 -> Ids.getParentId((String)x$1))).distinct();
    }

    @Timed
    public scala.collection.immutable.Seq<String> getFailableGateIds(Set<PlanItem> abortedTargets) {
        return this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)((IterableOnceOps)abortedTargets.map((Function1 & Serializable)x$8 -> x$8.getId())).toSeq());
    }

    private scala.collection.immutable.Seq<String> findAllIncomingDependencyIds(scala.collection.immutable.Seq<String> targetIds, scala.collection.immutable.Seq<String> statuses, boolean referencingChildren) {
        return (scala.collection.immutable.Seq)this.dependencyRepository().findAllIncomingDependencies(targetIds, statuses, referencingChildren).map((Function1 & Serializable)x$9 -> x$9.getId());
    }

    private scala.collection.immutable.Seq<String> findAllIncomingDependencyIds$default$2() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private boolean findAllIncomingDependencyIds$default$3() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public List<String> findActiveOutgoingTargetIds(String releaseId) {
        void var2_2;
        List targetIds = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.findActiveOutgoingTargets(releaseId).map((Function1 & Serializable)x$10 -> x$10.getId())).asJava();
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<PlanItem> findActiveOutgoingTargets(String releaseId) {
        void var3_3;
        List<Dependency> dependencies = this.findByReleaseId(releaseId);
        scala.collection.immutable.Seq targets = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(dependencies).asScala().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Dependency, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                Object object = A12 != null && (A1 = A12).hasResolvedTarget() && !A1.isDone() ? A1.getTarget() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Dependency x1) {
                Dependency dependency;
                Dependency dependency2 = x1;
                boolean bl = dependency2 != null && (dependency = dependency2).hasResolvedTarget() && !dependency.isDone();
                return bl;
            }
        })).toSeq();
        return var3_3;
    }

    @Timed
    public ReleaseTree getReleaseTree(String releaseId) {
        ReleaseTree releaseTree;
        if (this.archivingService().exists(releaseId)) {
            releaseTree = new ReleaseTree();
        } else {
            scala.collection.mutable.Map dependentReleases = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            Release release = this.releaseRepository().findById(releaseId);
            this.toTreeItem(releaseId, (scala.collection.mutable.Map<String, ReleaseTreeItem>)dependentReleases, (PlanItem)release);
            ReleaseTree tree = new ReleaseTree();
            tree.releaseId_$eq(releaseId);
            tree.dependentReleases_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)dependentReleases.values().toList()).asJava());
            releaseTree = tree;
        }
        return releaseTree;
    }

    @Timed
    public void updateGateReferencingPhases(String gateId, Map<PlanItem, PlanItem> originToRestored) {
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Release release = gate.getRelease();
        gate.getDependencies().forEach(dependency -> {
            block0: {
                PlanItem target = dependency.getTarget();
                if (!originToRestored.containsKey(target)) break block0;
                Dependency original = CiCloneHelper.cloneCi(dependency);
                dependency.setTarget((PlanItem)originToRestored.get(target));
                Dependency updatedDependency = this.dependencyRepository().update(release, (Dependency)dependency);
                this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, updatedDependency));
            }
        });
    }

    @Timed
    public void archiveDependencies(String releaseId, scala.collection.immutable.Seq<String> dependencyIds) {
        Release referencingRelease = this.releaseRepository().findById(releaseId);
        Buffer dependenciesToArchive = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(referencingRelease.getAllGates()).asScala().flatMap((Function1 & Serializable)x$11 -> CollectionConverters$.MODULE$.ListHasAsScala(x$11.getDependencies()).asScala())).filter((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)dependencyIds.contains((Object)d.getId())));
        dependenciesToArchive.foreach((Function1 & Serializable)x$12 -> {
            x$12.archive();
            return BoxedUnit.UNIT;
        });
        this.dependencyRepository().archive(referencingRelease, (scala.collection.immutable.Seq<Dependency>)dependenciesToArchive.toSeq());
    }

    @Timed
    public IdAndStatus findDependencyTargetByTargetId(String targetId) {
        return new IdAndStatus(targetId, this.getStatus(targetId));
    }

    private String getStatus(String targetId) {
        Option option;
        Option option2;
        String string;
        Option option3;
        String string2 = targetId;
        if (string2 != null && !(option3 = IdMatchers.ReleaseId$.MODULE$.unapply(string2)).isEmpty()) {
            string = (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.releaseRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = A1 != null ? this.$outer.archivingService().getRelease(this.targetId$1).getStatus().toString() : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = throwable != null;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException(new StringBuilder(20).append("Release [").append(targetId).append("] not found").toString(), new Object[0]);
            });
        } else if (string2 != null && !(option2 = IdMatchers.PhaseId$.MODULE$.unapply(string2)).isEmpty()) {
            string = (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.phaseRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    Object object = A1 != null ? this.$outer.archivingService().getPhase(this.targetId$1).getStatus().toString() : function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Throwable throwable = x2;
                    boolean bl = throwable != null;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException(new StringBuilder(18).append("Phase [").append(targetId).append("] not found").toString(), new Object[0]);
            });
        } else if (string2 != null && !(option = IdMatchers.TaskId$.MODULE$.unapply(string2)).isEmpty()) {
            string = (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.taskRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    Object object = A1 != null ? this.$outer.archivingService().getTask(this.targetId$1).getStatus().toString() : function1.apply(x3);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x3) {
                    Throwable throwable = x3;
                    boolean bl = throwable != null;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException(new StringBuilder(17).append("Task [").append(targetId).append("] not found").toString(), new Object[0]);
            });
        } else {
            throw new NotFoundException(new StringBuilder(35).append("Target is not plan item, targetId= ").append(targetId).toString(), new Object[0]);
        }
        return string;
    }

    public scala.collection.immutable.Seq<String> findInProgressIncomingGateIds(scala.collection.immutable.Seq<String> targetIds) {
        return (scala.collection.immutable.Seq)((SeqOps)this.findAllIncomingDependencyIds(targetIds, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{TaskStatus.IN_PROGRESS.name()}))), this.findAllIncomingDependencyIds$default$3()).map((Function1 & Serializable)x$1 -> Ids.getParentId((String)x$1))).distinct();
    }

    public boolean isTemplate(String dependencyId) {
        return this.releaseRepository().isTemplate(Ids.releaseIdFrom((String)dependencyId));
    }

    public static final /* synthetic */ boolean $anonfun$delete$2(String id$1, Dependency x$3) {
        String string = x$3.getId();
        String string2 = Ids.normalizeId((String)id$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public DependencyService(ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, PlanItemRepository planItemRepository, DependencyRepository dependencyRepository, EventBus eventBus, TaskRepository taskRepository, PhaseRepository phaseRepository, CiIdService ciIdService, ArchivingService archivingService) {
        this.releaseRepository = releaseRepository;
        this.releaseSearchService = releaseSearchService;
        this.planItemRepository = planItemRepository;
        this.dependencyRepository = dependencyRepository;
        this.eventBus = eventBus;
        this.taskRepository = taskRepository;
        this.phaseRepository = phaseRepository;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        ReleaseTreeBuilder.$init$(this);
        DependencyCandidateCollector.$init$(this);
        Logging.$init$((Logging)this);
        this.activeDependencyStatuses = (scala.collection.immutable.Seq)((IterableOps)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])TaskStatus.ACTIVE_STATUSES)).$colon$plus((Object)TaskStatus.PLANNED)).map((Function1 & Serializable)x$1 -> x$1.name());
    }
}

