/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.DependencyTarget;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.repository.DependencyTargetLoader;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.views.DependencyNode;
import com.xebialabs.xlrelease.views.Flag;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DependencyNodeFactory {
    private static final AtomicReference<DependencyTargetLoader> DEPENDENCY_TARGET_LOADER = new AtomicReference();

    @Autowired
    public void setDependencyTargetLoader(DependencyTargetLoader dependencyTargetLoader) {
        DEPENDENCY_TARGET_LOADER.set(dependencyTargetLoader);
    }

    public static DependencyNode fromArchivedDependency(Dependency dependency) {
        DependencyNode node = new DependencyNode();
        if (dependency.hasValidArchiveTargetId()) {
            node.setId(dependency.getArchivedTargetId());
        }
        node.setArchived(dependency.isArchived());
        node.setReleaseTitle(dependency.getArchivedTargetTitle());
        return node;
    }

    public static DependencyNode fromTarget(PlanItem item) {
        return DependencyNodeFactory.fromTargetId(item.getId());
    }

    public static DependencyNode fromTargetId(String itemId) {
        DependencyTarget target = DEPENDENCY_TARGET_LOADER.get().getDependencyNodeData(itemId);
        return DependencyNodeFactory.fromDependencyTarget(target);
    }

    private static DependencyNode fromDependencyTarget(DependencyTarget item) {
        DependencyNode dependencyNode = new DependencyNode();
        String itemId = item.targetId();
        dependencyNode.setId(itemId);
        dependencyNode.setReleaseId(Ids.releaseIdFrom((String)itemId));
        dependencyNode.setReleaseTitle(item.releaseTitle());
        dependencyNode.setPhaseId(item.phaseId());
        dependencyNode.setPhaseTitle(item.resolvedPhaseTitle());
        dependencyNode.setTaskId(item.taskId());
        dependencyNode.setTaskTitle(item.resolvedTaskTitle());
        dependencyNode.setStartDate(item.startDate());
        dependencyNode.setEndDate(item.endDate());
        dependencyNode.setScheduledStartDate(item.scheduledStartDate());
        dependencyNode.setDueDate(item.dueDate());
        Flag releaseFlag = new Flag(item.releaseFlagStatus(), item.releaseFlagComment());
        dependencyNode.setFlag(releaseFlag);
        return dependencyNode;
    }
}

