/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import akka.actor.Address;
import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobRow$;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.JobType;
import com.xebialabs.xlrelease.scheduler.NodeId;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.converters.TaskJobConverter;
import com.xebialabs.xlrelease.scheduler.domain.LocalJobRunner$;
import com.xebialabs.xlrelease.scheduler.events.JobCreatedEvent;
import com.xebialabs.xlrelease.scheduler.events.JobFinishedEvent;
import com.xebialabs.xlrelease.scheduler.events.JobReservedEvent;
import com.xebialabs.xlrelease.scheduler.repository.ConfirmJobExecution;
import com.xebialabs.xlrelease.scheduler.repository.DeleteById;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.scheduler.repository.ReserveJob;
import com.xebialabs.xlrelease.script.TaskSoftReference;
import com.xebialabs.xlrelease.service.BroadcastService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.slf4j.Marker;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@ScalaSignature(bytes="\u0006\u0005\tma\u0001\u0002\u000f\u001e\u0001\u0019B\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005w!A!\t\u0001BC\u0002\u0013\u00051\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003E\u0011!Y\u0005A!A!\u0002\u0013a\u0005\u0002\u0003*\u0001\u0005\u000b\u0007I\u0011A*\t\u0011i\u0003!\u0011!Q\u0001\nQCQa\u0017\u0001\u0005\u0002qCqa\u001c\u0001C\u0002\u0013%\u0001\u000f\u0003\u0004\u007f\u0001\u0001\u0006I!\u001d\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002!A\u0011q\u0002\u0001!\u0002\u0013\t\u0019\u0001C\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011\u0019\t\t\u0006\u0001C\u0001a\"9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003\"CA:\u0001E\u0005I\u0011AA;\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017Cq!a1\u0001\t\u0003\t)\rC\u0004\u0002L\u0002!\t!!4\t\u000f\u0005=\u0007\u0001\"\u0001\u0002N\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005M\u0007bBAs\u0001\u0011\u0005\u0011q\u001d\u0005\b\u0003_\u0004A\u0011BAy\u0005=!UMZ1vYRTuNY)vKV,'B\u0001\u0010 \u0003%\u00198\r[3ek2,'O\u0003\u0002!C\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003E\r\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0011\n1aY8n\u0007\u0001\u0019B\u0001A\u0014.kA\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\u0004\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\u000bMdg\r\u000e6\u000b\u0003I\n\u0001b\u001a:jujdW\rZ\u0005\u0003i=\u0012q\u0001T8hO&tw\r\u0005\u00027o5\tQ$\u0003\u00029;\t1aj\u001c3f\u0013\u0012\f\u0001\u0003^1tW*{'mQ8om\u0016\u0014H/\u001a:\u0016\u0003m\u0002\"\u0001P \u000e\u0003uR!AP\u000f\u0002\u0015\r|gN^3si\u0016\u00148/\u0003\u0002A{\t\u0001B+Y:l\u0015>\u00147i\u001c8wKJ$XM]\u0001\u0012i\u0006\u001c8NS8c\u0007>tg/\u001a:uKJ\u0004\u0013!\u00046pEJ+\u0007o\\:ji>\u0014\u00180F\u0001E!\t)\u0005*D\u0001G\u0015\t9U$\u0001\u0006sKB|7/\u001b;pefL!!\u0013$\u0003\u001b){'MU3q_NLGo\u001c:z\u00039QwN\u0019*fa>\u001c\u0018\u000e^8ss\u0002\n\u0001C\u0019:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0011\u00055\u0003V\"\u0001(\u000b\u0005={\u0012aB:feZL7-Z\u0005\u0003#:\u0013\u0001C\u0011:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0002#\u0005\u001cGo\u001c:TsN$X-\u001c%pY\u0012,'/F\u0001U!\t)\u0006,D\u0001W\u0015\t9v$\u0001\u0004bGR|'o]\u0005\u00033Z\u0013\u0011#Q2u_J\u001c\u0016p\u001d;f[\"{G\u000eZ3s\u0003I\t7\r^8s'f\u001cH/Z7I_2$WM\u001d\u0011\u0002\rqJg.\u001b;?)\u0015ifl\u00181b!\t1\u0004\u0001C\u0003:\u0011\u0001\u00071\bC\u0003C\u0011\u0001\u0007A\tC\u0003L\u0011\u0001\u0007A\nC\u0003S\u0011\u0001\u0007A\u000b\u000b\u0002bGB\u0011A-\\\u0007\u0002K*\u0011amZ\u0001\u000bC:tw\u000e^1uS>t'B\u00015j\u0003\u001d\u0019wN\u001c;fqRT!A[6\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001\\\u0001\u0004_J<\u0017B\u00018f\u0005\u0011a\u0015M_=\u0002\u0015}cwnY1m\u0015>\u00147/F\u0001r!\r\u0011\u0018p_\u0007\u0002g*\u0011A/^\u0001\u000bG>t7-\u001e:sK:$(B\u0001<x\u0003\u0011)H/\u001b7\u000b\u0003a\fAA[1wC&\u0011!p\u001d\u0002\u000b\t\u0016d\u0017-_)vKV,\u0007C\u0001\u001c}\u0013\tiXDA\u0002K_\n\f1b\u00187pG\u0006d'j\u001c2tA\u0005Qq,[:Sk:t\u0017N\\4\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%1/\u0001\u0004bi>l\u0017nY\u0005\u0005\u0003\u001b\t9AA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\f?&\u001c(+\u001e8oS:<\u0007%\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\u0005\u0003+\tY\u0002E\u0002)\u0003/I1!!\u0007*\u0005\u0011)f.\u001b;\t\r\u0005uQ\u00021\u0001|\u0003\rQwN\u0019\u0015\u0004\u001b\u0005\u0005\u0002\u0003BA\u0012\u0003_i!!!\n\u000b\u0007\u0019\f9C\u0003\u0003\u0002*\u0005-\u0012aB7fiJL7m\u001d\u0006\u0004\u0003[\u0019\u0013\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005E\u0012Q\u0005\u0002\u0006)&lW\rZ\u0001\u000fgV\u0014W.\u001b;Fq&\u001cH/\u001b8h)\u0011\t)\"a\u000e\t\r\u0005ua\u00021\u0001|\u0003E\u0019XOY7ji\n\u0013x.\u00193dCN$X\r\u001a\u000b\u0005\u0003+\ti\u0004\u0003\u0004\u0002\u001e=\u0001\ra_\u0001\be\u0016\u0004H.Y2f)\u0011\t)\"a\u0011\t\r\u0005u\u0001\u00031\u0001|Q\r\u0001\u0012\u0011E\u0001\nSN\u0014VO\u001c8j]\u001e$\"!a\u0013\u0011\u0007!\ni%C\u0002\u0002P%\u0012qAQ8pY\u0016\fg.A\u0005m_\u000e\fGNS8cg\u00069!/Z:feZ,G#B>\u0002X\u0005e\u0003BBA\u000f'\u0001\u00071\u0010C\u0005\u0002\\M\u0001\n\u00111\u0001\u0002^\u0005A!/\u001e8oKJLE\r\u0005\u0003\u0002`\u00055d\u0002BA1\u0003S\u00022!a\u0019*\u001b\t\t)GC\u0002\u0002h\u0015\na\u0001\u0010:p_Rt\u0014bAA6S\u00051\u0001K]3eK\u001aLA!a\u001c\u0002r\t11\u000b\u001e:j]\u001eT1!a\u001b*\u0003E\u0011Xm]3sm\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0003oRC!!\u0018\u0002z-\u0012\u00111\u0010\t\u0005\u0003{\n))\u0004\u0002\u0002\u0000)!\u0011\u0011QAB\u0003%)hn\u00195fG.,GM\u0003\u0002gS%!\u0011qQA@\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\bG>tg-\u001b:n)\u0019\tY%!$\u0002:\"9\u00111L\u000bA\u0002\u0005=\u0005\u0003BAI\u0003gsA!a%\u0002.:!\u0011QSAT\u001d\u0011\t9*a)\u000f\t\u0005e\u0015\u0011\u0015\b\u0005\u00037\u000byJ\u0004\u0003\u0002d\u0005u\u0015\"\u0001\u0013\n\u0005\t\u001a\u0013B\u0001\u0011\"\u0013\r\t)kH\u0001\u0007eVtg.\u001a:\n\t\u0005%\u00161V\u0001\u0007I>l\u0017-\u001b8\u000b\u0007\u0005\u0015v$\u0003\u0003\u00020\u0006E\u0016a\u00029bG.\fw-\u001a\u0006\u0005\u0003S\u000bY+\u0003\u0003\u00026\u0006]&\u0001\u0003*v]:,'/\u00133\u000b\t\u0005=\u0016\u0011\u0017\u0005\b\u0003w+\u0002\u0019AA_\u0003\u0015QwNY%e!\u0011\t\t*a0\n\t\u0005\u0005\u0017q\u0017\u0002\u0006\u0015>\u0014\u0017\nZ\u0001\u0007M&t\u0017n\u001d5\u0015\t\u0005U\u0011q\u0019\u0005\b\u0003w3\u0002\u0019AA_Q\r1\u0012\u0011E\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003+\tAa\u001d;pa\u0006A1-\u00198dK2Le\r\u0006\u0003\u0002\u0016\u0005U\u0007bBAl3\u0001\u0007\u0011\u0011\\\u0001\naJ,G-[2bi\u0016\u0004R!a7\u0002bnl!!!8\u000b\u0007\u0005}W/\u0001\u0005gk:\u001cG/[8o\u0013\u0011\t\u0019/!8\u0003\u0013A\u0013X\rZ5dCR,\u0017\u0001B:ju\u0016$\"!!;\u0011\u0007!\nY/C\u0002\u0002n&\u00121!\u00138u\u00039\tG\r\u001a+p\u0019>\u001c\u0017\r\u001c&pEN$b!!\u0006\u0002t\u0006U\bBBA\u000f7\u0001\u00071\u0010C\u0004\u0002xn\u0001\r!a\u0013\u0002\u0019\t\u0014x.\u00193dCN$(j\u001c2)\u000f\u0001\tYP!\u0001\u0003\u0004A\u0019A-!@\n\u0007\u0005}XMA\u0003TG>\u0004X-A\u0005qe>D\u00180T8eK\u0012\u0012!QA\u0005\u0005\u0005\u000f\u0011I!\u0001\u0007U\u0003J;U\tV0D\u0019\u0006\u001b6KC\u0002\u0003\f\u0015\fqbU2pa\u0016$\u0007K]8ys6{G-\u001a\u0015\u0004\u0001\t=\u0001\u0003\u0002B\t\u0005/i!Aa\u0005\u000b\u0007\tU\u0011.\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAA!\u0007\u0003\u0014\tI1i\\7q_:,g\u000e\u001e")
public class DefaultJobQueue
implements Logging,
NodeId {
    private final TaskJobConverter taskJobConverter;
    private final JobRepository jobRepository;
    private final BroadcastService broadcastService;
    private final ActorSystemHolder actorSystemHolder;
    private final DelayQueue<Job> _localJobs;
    private final AtomicBoolean _isRunning;
    private String nodeId;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    @Override
    public String convertAddressToNodeId(Address address) {
        return NodeId.convertAddressToNodeId$(this, address);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private String nodeId$lzycompute() {
        DefaultJobQueue defaultJobQueue = this;
        synchronized (defaultJobQueue) {
            if (!this.bitmap$0) {
                this.nodeId = NodeId.nodeId$(this);
                this.bitmap$0 = true;
            }
        }
        return this.nodeId;
    }

    @Override
    public String nodeId() {
        return !this.bitmap$0 ? this.nodeId$lzycompute() : this.nodeId;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultJobQueue defaultJobQueue = this;
        synchronized (defaultJobQueue) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public TaskJobConverter taskJobConverter() {
        return this.taskJobConverter;
    }

    public JobRepository jobRepository() {
        return this.jobRepository;
    }

    @Override
    public ActorSystemHolder actorSystemHolder() {
        return this.actorSystemHolder;
    }

    private DelayQueue<Job> _localJobs() {
        return this._localJobs;
    }

    private AtomicBoolean _isRunning() {
        return this._isRunning;
    }

    @Timed
    public void submit(Job job) {
        this.logger().debug((Function0 & Serializable)() -> "submitted job " + job);
        Job job2 = job;
        if (job2 instanceof TaskJob) {
            TaskJob taskJob = (TaskJob)job2;
            JobRow qual$1 = JobRow$.MODULE$.apply(taskJob);
            String x$1 = this.nodeId();
            long x$2 = qual$1.copy$default$1();
            JobType x$3 = qual$1.copy$default$3();
            JobStatus x$4 = qual$1.copy$default$4();
            long x$5 = qual$1.copy$default$5();
            Instant x$6 = qual$1.copy$default$6();
            Instant x$7 = qual$1.copy$default$7();
            Instant x$8 = qual$1.copy$default$8();
            Instant x$9 = qual$1.copy$default$9();
            String x$10 = qual$1.copy$default$10();
            Integer x$11 = qual$1.copy$default$11();
            String x$12 = qual$1.copy$default$12();
            String x$13 = qual$1.copy$default$13();
            taskJob.setId(this.jobRepository().create(qual$1.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13)).id());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.addToLocalJobs(job, job.broadcast());
    }

    public void submitExisting(Job job) {
        this.logger().debug((Function0 & Serializable)() -> "submitted existing job " + job);
        this.cancelIf(x$1 -> x$1.id() == job.id());
        this.addToLocalJobs(job, job.broadcast());
    }

    public void submitBroadcasted(Job job) {
        this.logger().debug((Function0 & Serializable)() -> "submitted broadcasted job " + job);
        this.cancelIf(x$2 -> x$2.id() == job.id());
        this.addToLocalJobs(job, false);
    }

    @Timed
    public void replace(Job job) {
        this.logger().debug((Function0 & Serializable)() -> "replaced job " + job);
        JobRow qual$1 = JobRow$.MODULE$.apply(job);
        String x$1 = this.nodeId();
        Object x$2 = null;
        long x$3 = qual$1.copy$default$1();
        JobType x$4 = qual$1.copy$default$3();
        JobStatus x$5 = qual$1.copy$default$4();
        long x$6 = qual$1.copy$default$5();
        Instant x$7 = qual$1.copy$default$6();
        Instant x$8 = qual$1.copy$default$7();
        Instant x$9 = qual$1.copy$default$8();
        Instant x$10 = qual$1.copy$default$9();
        String x$11 = qual$1.copy$default$10();
        Integer x$12 = qual$1.copy$default$11();
        String x$13 = qual$1.copy$default$12();
        job.id_$eq(this.jobRepository().replace(qual$1.copy(x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, null)).id());
        this.localJobs().add(job);
    }

    public boolean isRunning() {
        return this._isRunning().get();
    }

    public DelayQueue<Job> localJobs() {
        return this._localJobs();
    }

    public Job reserve(Job job, String runnerId) {
        TaskJob<?> taskJob;
        Try<JobRow> lockAttempt = this.jobRepository().update(new ReserveJob(JobRow$.MODULE$.apply(job), this.nodeId(), runnerId));
        Try<JobRow> try_ = lockAttempt;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw exception;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            JobRow row = (JobRow)success.value();
            Job job2 = job;
            if (job2 instanceof TaskJob) {
                TaskJob taskJob2 = (TaskJob)job2;
                taskJob = this.taskJobConverter().fromJobRow(row, (Option<TaskSoftReference<? extends Task>>)new Some(taskJob2.taskRef()));
            } else {
                taskJob = this.taskJobConverter().fromJobRow(row, this.taskJobConverter().fromJobRow$default$2());
            }
        } else {
            throw new MatchError(try_);
        }
        TaskJob<?> lockedJob = taskJob;
        this.broadcastService.broadcast(new JobReservedEvent(lockedJob.id()), false);
        this.localJobs().remove(job);
        TaskJob<?> taskJob3 = lockedJob;
        return taskJob3;
    }

    public String reserve$default$2() {
        return LocalJobRunner$.MODULE$.getId();
    }

    public boolean confirm(String runnerId, long jobId) {
        boolean bl;
        Try confirmationResult = Try$.MODULE$.apply((Function0 & Serializable)() -> (JobRow)this.jobRepository().read(jobId).get()).flatMap((Function1 & Serializable)jobRow -> this.jobRepository().update(new ConfirmJobExecution((JobRow)jobRow, runnerId)).map((Function1 & Serializable)confirmedRow -> confirmedRow));
        Try try_ = confirmationResult;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            this.logger().warn((Function0 & Serializable)() -> "Unable to confirm job " + jobId, (Function0 & Serializable)() -> ex);
            bl = false;
        } else if (try_ instanceof Success) {
            bl = true;
        } else {
            throw new MatchError((Object)try_);
        }
        return bl;
    }

    @Timed
    public void finish(long jobId) {
        this.logger().debug((Function0 & Serializable)() -> "finishing job " + jobId);
        this.jobRepository().read(jobId).foreach((Function1 & Serializable)job -> {
            DefaultJobQueue.$anonfun$finish$2(this, job);
            return BoxedUnit.UNIT;
        });
    }

    public void start() {
        this.logger().debug((Function0 & Serializable)() -> "starting job queue");
        this._isRunning().set(true);
    }

    public void stop() {
        this.logger().debug((Function0 & Serializable)() -> "stopping job queue");
        this._isRunning().set(false);
    }

    public void cancelIf(Predicate<Job> predicate) {
        this.localJobs().removeIf(predicate);
    }

    public int size() {
        return this.localJobs().size();
    }

    private void addToLocalJobs(Job job, boolean broadcastJob) {
        block0: {
            this.localJobs().add(job);
            if (!broadcastJob) break block0;
            this.broadcastService.broadcast(new JobCreatedEvent(job), false);
        }
    }

    public static final /* synthetic */ void $anonfun$finish$2(DefaultJobQueue $this, JobRow job) {
        $this.jobRepository().delete(new DeleteById(job.id()));
        $this.broadcastService.broadcast(new JobFinishedEvent(job.executionId(), job.id()), true);
    }

    public DefaultJobQueue(TaskJobConverter taskJobConverter, JobRepository jobRepository, BroadcastService broadcastService, @Lazy ActorSystemHolder actorSystemHolder) {
        this.taskJobConverter = taskJobConverter;
        this.jobRepository = jobRepository;
        this.broadcastService = broadcastService;
        this.actorSystemHolder = actorSystemHolder;
        Logging.$init$((Logging)this);
        NodeId.$init$(this);
        this._localJobs = new DelayQueue();
        this._isRunning = new AtomicBoolean(true);
    }
}

