/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.logs;

import akka.actor.ActorRef;
import com.xebialabs.xlrelease.domain.events.TaskJobExecutedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.scheduler.events.JobFinishedEvent;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatchActor;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatcherSupervisor;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntry;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLog;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService$;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionRepository;
import com.xebialabs.xlrelease.scheduler.logs.TaskLogCreated;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.storage.domain.LogEntry;
import com.xebialabs.xlrelease.storage.domain.StorageEntry;
import com.xebialabs.xlrelease.storage.service.StorageService;
import com.xebialabs.xlrelease.support.akka.spring.SpringExtension;
import com.xebialabs.xlrelease.views.TaskExecutionLogView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseEventSink;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\t=a\u0001B\n\u0015\u0001}A\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\ts\u0001\u0011\t\u0011)A\u0005u!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011\u0015i\u0005\u0001\"\u0001O\u0011!!\u0006\u0001#b\u0001\n\u0013)\u0006\"B/\u0001\t\u0003q\u0006bBA\u0004\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u00037\u0002A\u0011AA/\u0011\u001d\tI\b\u0001C\u0001\u0003wBq!a#\u0001\t\u0003\ti\tC\u0004\u0002 \u0002!\t!!)\t\u000f\u0005}\u0006\u0001\"\u0001\u0002B\"9\u0011q\u001a\u0001\u0005\u0002\u0005Ewa\u0002B\u0001)!\u0005!1\u0001\u0004\u0007'QA\tA!\u0002\t\r5\u0003B\u0011\u0001B\u0004\u0011\u001d\u0011I\u0001\u0005C\u0001\u0005\u0017\u0011q\u0003V1tW\u0016CXmY;uS>tGj\\4TKJ4\u0018nY3\u000b\u0005U1\u0012\u0001\u00027pONT!a\u0006\r\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\r\u001b\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001c9\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002;\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\t\u0014\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g!\t9C&D\u0001)\u0015\tI#&A\u0003tY\u001a$$NC\u0001,\u0003!9'/\u001b>{Y\u0016$\u0017BA\u0017)\u0005\u001daunZ4j]\u001e\fqb\u001d9sS:<W\t\u001f;f]NLwN\u001c\t\u0003a]j\u0011!\r\u0006\u0003eM\naa\u001d9sS:<'B\u0001\u001b6\u0003\u0011\t7n[1\u000b\u0005YB\u0012aB:vaB|'\u000f^\u0005\u0003qE\u0012qb\u00159sS:<W\t\u001f;f]NLwN\\\u0001\u0011EJ|\u0017\rZ2bgR\u001cVM\u001d<jG\u0016\u0004\"a\u000f \u000e\u0003qR!!\u0010\r\u0002\u000fM,'O^5dK&\u0011q\b\u0010\u0002\u0011\u0005J|\u0017\rZ2bgR\u001cVM\u001d<jG\u0016\fab\u001d;pe\u0006<WmU3sm&\u001cW\r\u0005\u0002C\r6\t1I\u0003\u0002>\t*\u0011Q\tG\u0001\bgR|'/Y4f\u0013\t95I\u0001\bTi>\u0014\u0018mZ3TKJ4\u0018nY3\u0002/Q\f7o[#yK\u000e,H/[8o%\u0016\u0004xn]5u_JL\bC\u0001&L\u001b\u0005!\u0012B\u0001'\u0015\u0005]!\u0016m]6Fq\u0016\u001cW\u000f^5p]J+\u0007o\\:ji>\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0006\u001fB\u000b&k\u0015\t\u0003\u0015\u0002AQAL\u0003A\u0002=BQ!O\u0003A\u0002iBQ\u0001Q\u0003A\u0002\u0005CQ\u0001S\u0003A\u0002%\u000b1$\u001a=fGV$\u0018n\u001c8M_\u001e<\u0016\r^2iKJ\f5\r^8s%\u00164W#\u0001,\u0011\u0005][V\"\u0001-\u000b\u0005eS\u0016!B1di>\u0014(\"\u0001\u001b\n\u0005qC&\u0001C!di>\u0014(+\u001a4\u0002\u000b]\fGo\u00195\u0015\u000b}\u0013w.]@\u0011\u0005\u0005\u0002\u0017BA1#\u0005\u0011)f.\u001b;\t\u000b\r<\u0001\u0019\u00013\u0002\rQ\f7o[%e!\t)GN\u0004\u0002gUB\u0011qMI\u0007\u0002Q*\u0011\u0011NH\u0001\u0007yI|w\u000e\u001e \n\u0005-\u0014\u0013A\u0002)sK\u0012,g-\u0003\u0002n]\n11\u000b\u001e:j]\u001eT!a\u001b\u0012\t\u000bA<\u0001\u0019\u00013\u0002\u0017\u0015DXmY;uS>t\u0017\n\u001a\u0005\u0006e\u001e\u0001\ra]\u0001\u0005g&t7\u000e\u0005\u0002u{6\tQO\u0003\u0002wo\u0006\u00191o]3\u000b\u0005aL\u0018A\u0001:t\u0015\tQ80\u0001\u0002xg*\tA0A\u0003kCZ\f\u00070\u0003\u0002\u007fk\na1k]3Fm\u0016tGoU5oW\"1ao\u0002a\u0001\u0003\u0003\u00012\u0001^A\u0002\u0013\r\t)!\u001e\u0002\u0004'N,\u0017!\u00024fi\u000eDGcC0\u0002\f\u00055\u0011qBA\u0012\u0003#BQa\u0019\u0005A\u0002\u0011DQ\u0001\u001d\u0005A\u0002\u0011Dq!!\u0005\t\u0001\u0004\t\u0019\"\u0001\u0007pkR\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\u0005%|'BAA\u000f\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0012q\u0003\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003KA\u0001\u0019AA\u0014\u0003\u001da\u0017m\u001d;K_\n\u0004B!!\u000b\u0002L9!\u00111FA#\u001d\u0011\ti#a\u0010\u000f\t\u0005=\u00121\b\b\u0005\u0003c\tID\u0004\u0003\u00024\u0005]bbA4\u00026%\tQ$\u0003\u0002\u001c9%\u0011\u0011DG\u0005\u0004\u0003{A\u0012A\u0002:v]:,'/\u0003\u0003\u0002B\u0005\r\u0013A\u00023p[\u0006LgNC\u0002\u0002>aIA!a\u0012\u0002J\u00059\u0001/Y2lC\u001e,'\u0002BA!\u0003\u0007JA!!\u0014\u0002P\t)!j\u001c2JI*!\u0011qIA%\u0011\u001d\t\u0019\u0006\u0003a\u0001\u0003+\n\u0011\u0002\\1ti\u000eCWO\\6\u0011\u0007\u0005\n9&C\u0002\u0002Z\t\u0012A\u0001T8oO\u0006\u0011b-\u001a;dQ\u0006cG.\u0012=fGV$\u0018n\u001c8t)\u0011\ty&a\u001e\u0011\r\u0005\u0005\u0014qMA6\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005m\u0011\u0001B;uS2LA!!\u001b\u0002d\t!A*[:u!\u0011\ti'a\u001d\u000e\u0005\u0005=$bAA91\u0005)a/[3xg&!\u0011QOA8\u0005Q!\u0016m]6Fq\u0016\u001cW\u000f^5p]2{wMV5fo\")1-\u0003a\u0001I\u0006\u0019An\\4\u0015\u0007}\u000bi\bC\u0004\u0002\u0000)\u0001\r!!!\u0002\u00111|w-\u00128uef\u0004B!a!\u0002\b6\u0011\u0011Q\u0011\u0006\u0004\u0003\u0003\"\u0015\u0002BAE\u0003\u000b\u0013\u0001\u0002T8h\u000b:$(/_\u0001\u0016O\u0016$H+Y:l\u000bb,7-\u001e;j_:,e\u000e\u001e:z)\u0019\ty)a'\u0002\u001eB)\u0011%!%\u0002\u0016&\u0019\u00111\u0013\u0012\u0003\r=\u0003H/[8o!\rQ\u0015qS\u0005\u0004\u00033#\"A\u0005+bg.,\u00050Z2vi&|g.\u00128uefDQaY\u0006A\u0002\u0011DQ\u0001]\u0006A\u0002\u0011\fQb\u001c8K_\n4\u0015N\\5tQ\u0016$GcA0\u0002$\"9\u0011Q\u0015\u0007A\u0002\u0005\u001d\u0016!B3wK:$\b\u0003BAU\u0003_k!!a+\u000b\u0007\u00055f#\u0001\u0004fm\u0016tGo]\u0005\u0005\u0003c\u000bYK\u0001\tK_\n4\u0015N\\5tQ\u0016$WI^3oi\"\u001aA\"!.\u0011\t\u0005]\u00161X\u0007\u0003\u0003sS1!!,\u0019\u0013\u0011\ti,!/\u0003\u0013M+(m]2sS\n,\u0017\u0001E8o)\u0006\u001c8\u000eT8h\u0007J,\u0017\r^3e)\ry\u00161\u0019\u0005\b\u0003\u000bl\u0001\u0019AAd\u00031!\u0018m]6M_\u001e,e/\u001a8u!\rQ\u0015\u0011Z\u0005\u0004\u0003\u0017$\"A\u0004+bg.dunZ\"sK\u0006$X\r\u001a\u0015\u0004\u001b\u0005U\u0016aE8o)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8E_:,GcA0\u0002T\"9\u0011Q\u0015\bA\u0002\u0005U\u0007\u0003BAl\u0003;l!!!7\u000b\t\u00055\u00161\u001c\u0006\u0004\u0003\u0003B\u0012\u0002BAp\u00033\u0014A\u0003V1tW*{'-\u0012=fGV$X\rZ#wK:$\bf\u0001\b\u00026\"\u001a\u0001!!:\u0011\t\u0005]\u0016q]\u0005\u0005\u0003S\fILA\u0007Fm\u0016tG\u000fT5ti\u0016tWM\u001d\u0015\u0004\u0001\u00055\b\u0003BAx\u0003{l!!!=\u000b\t\u0005M\u0018Q_\u0001\u000bgR,'/Z8usB,'\u0002BA|\u0003s\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003w\f1a\u001c:h\u0013\u0011\ty0!=\u0003\u000fM+'O^5dK\u00069B+Y:l\u000bb,7-\u001e;j_:dunZ*feZL7-\u001a\t\u0003\u0015B\u0019\"\u0001\u0005\u0011\u0015\u0005\t\r\u0011\u0001\u00025bg\"$2\u0001\u001aB\u0007\u0011\u0015\u0019'\u00031\u0001e\u0001")
public class TaskExecutionLogService
implements Logging {
    private ActorRef executionLogWatcherActorRef;
    private final SpringExtension springExtension;
    private final BroadcastService broadcastService;
    private final StorageService storageService;
    private final TaskExecutionRepository taskExecutionRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static String hash(String taskId) {
        return TaskExecutionLogService$.MODULE$.hash(taskId);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private ActorRef executionLogWatcherActorRef$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if (!this.bitmap$0) {
                this.executionLogWatcherActorRef = this.springExtension.actorOf(ExecutionLogWatcherSupervisor.class, "execution-log-watchers", this.springExtension.actorOf$default$3(), this.springExtension.actorOf$default$4());
                this.bitmap$0 = true;
            }
        }
        return this.executionLogWatcherActorRef;
    }

    private ActorRef executionLogWatcherActorRef() {
        return !this.bitmap$0 ? this.executionLogWatcherActorRef$lzycompute() : this.executionLogWatcherActorRef;
    }

    public void watch(String taskId, String executionId, SseEventSink sink, Sse sse) {
        ExecutionLogWatchActor.StartWatch x$1 = new ExecutionLogWatchActor.StartWatch(taskId, executionId, sink, sse);
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    public void fetch(String taskId, String executionId, OutputStream outputStream, long lastJob, long lastChunk) {
        new TaskExecutionLog(taskId, executionId).fetch(this.storageService, outputStream, lastJob, lastChunk);
    }

    public List<TaskExecutionLogView> fetchAllExecutions(String taskId) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)this.taskExecutionRepository.find(new TaskExecutionRepository.ByTaskId(taskId)).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            long l;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            TaskExecutionEntry row = (TaskExecutionEntry)tuple2._1();
            int index = tuple2._2$mcI$sp();
            TaskExecutionLogView view = new TaskExecutionLogView();
            view.setId(row.executionId());
            view.setExecutionNo(Predef$.MODULE$.int2Integer(index + 1));
            view.setLastJob(Predef$.MODULE$.long2Long((long)row.lastJob()));
            view.setLastChunk(Predef$.MODULE$.int2Integer(row.lastChunk()));
            Option option = Option$.MODULE$.apply((Object)row.lastModifiedDate());
            if (option instanceof Some) {
                Some some = (Some)option;
                Instant date2 = (Instant)some.value();
                l = date2.toEpochMilli();
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                l = Instant.now().toEpochMilli();
            }
            long modifiedDate = l;
            view.setModifiedDate(Predef$.MODULE$.long2Long(modifiedDate));
            Option$.MODULE$.apply((Object)row.endDate()).foreach((Function1 & Serializable)date -> {
                view.setEndDate(Predef$.MODULE$.long2Long(date.toEpochMilli()));
                return BoxedUnit.UNIT;
            });
            return view;
        })).asJava();
    }

    public void log(LogEntry logEntry) {
        String x$1 = "xlr-local";
        String x$2 = logEntry.copy$default$1();
        String x$3 = logEntry.copy$default$2();
        long x$4 = logEntry.copy$default$3();
        long x$5 = logEntry.copy$default$4();
        String x$6 = logEntry.copy$default$5();
        byte[] x$7 = logEntry.copy$default$6();
        LogEntry workerLogEntry = logEntry.copy(x$2, x$3, x$4, x$5, x$6, x$7, "xlr-local");
        URI storedEntryUri = this.storageService.store((StorageEntry)workerLogEntry);
        this.taskExecutionRepository.update(new TaskExecutionRepository.UpdateWithLogEntry(workerLogEntry));
        this.broadcastService.broadcast(new TaskLogCreated(logEntry.taskId(), logEntry.executionId(), storedEntryUri), true);
    }

    public Option<TaskExecutionEntry> getTaskExecutionEntry(String taskId, String executionId) {
        return this.taskExecutionRepository.read(taskId, executionId);
    }

    @Subscribe
    public void onJobFinished(JobFinishedEvent event) {
        long jobId = event.jobId();
        String executionId = event.executionId();
        this.logger().debug((Function0 & Serializable)() -> "finishing job " + jobId);
        ExecutionLogWatchActor.Check x$1 = new ExecutionLogWatchActor.Check(executionId);
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    @Subscribe
    public void onTaskLogCreated(TaskLogCreated taskLogEvent) {
        this.logger().debug((Function0 & Serializable)() -> "processing log event " + taskLogEvent);
        ExecutionLogWatchActor.NewEntry x$1 = new ExecutionLogWatchActor.NewEntry(taskLogEvent.executionId(), taskLogEvent.uri());
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    @Subscribe
    public void onTaskExecutionDone(TaskJobExecutedEvent event) {
        TaskExecutionRepository.FinishExecution finishExecution = new TaskExecutionRepository.FinishExecution(event.taskId(), event.executionId(), Instant.now());
        this.taskExecutionRepository.update(finishExecution);
    }

    public TaskExecutionLogService(SpringExtension springExtension, BroadcastService broadcastService, StorageService storageService, TaskExecutionRepository taskExecutionRepository) {
        this.springExtension = springExtension;
        this.broadcastService = broadcastService;
        this.storageService = storageService;
        this.taskExecutionRepository = taskExecutionRepository;
        Logging.$init$((Logging)this);
    }
}

