/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseVersion;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.utils.CiHelper;
import java.io.Serializable;
import java.util.List;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class PhaseRestart$ {
    public static final PhaseRestart$ MODULE$ = new PhaseRestart$();

    @VisibleForTesting
    public String computePhaselessTaskId(String taskId) {
        return taskId.substring(Ids.phaseIdFrom((String)taskId).length() + 1);
    }

    public Map<PlanItem, PlanItem> buildOriginToRestored(Seq<Phase> phasesToRestore, Seq<Phase> restoredPhases) {
        return ((IterableOnceOps)((IterableOps)phasesToRestore.zip(restoredPhases)).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Phase original = (Phase)tuple2._1();
            Phase restored = (Phase)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)original), (Object)restored);
            Seq seq = (Seq)PhaseRestart$.originToRestoredTasks$1(original, restored).$plus$colon((Object)tuple22);
            return seq;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @VisibleForTesting
    public List<Phase> getPhasesToRestore(Release release, String phaseId, PhaseVersion phaseVersion) {
        Predef$.MODULE$.require(release.hasPhase(phaseId), (Function0 & Serializable)() -> "Phase with id " + phaseId + " not found in release '" + release.getTitle() + "'.");
        Predef$.MODULE$.require(release.hasCurrentPhase(), (Function0 & Serializable)() -> "Release '" + release.getTitle() + "' must have a current phase in order to restart phases");
        Tuple2<Object, Object> tuple2 = this.getPhasesRangeToRestore(release, phaseId, phaseVersion);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int from = tuple2._1$mcI$sp();
        int until = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(from, until);
        Tuple2.mcII.sp sp3 = sp2;
        int from2 = sp3._1$mcI$sp();
        int until2 = sp3._2$mcI$sp();
        Predef$.MODULE$.require(from2 <= until2, (Function0 & Serializable)() -> "Can't restore a phase that is after the current phase.");
        Buffer phasesToRestore = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(release.getPhases()).asScala().slice(from2, until2 + 1);
        PhaseVersion phaseVersion2 = phaseVersion;
        Buffer buffer = PhaseVersion.LATEST.equals(phaseVersion2) ? (Buffer)phasesToRestore.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PhaseRestart$.$anonfun$getPhasesToRestore$4(p))) : (PhaseVersion.ORIGINAL.equals(phaseVersion2) ? (Buffer)phasesToRestore.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isOriginal())) : phasesToRestore);
        return CollectionConverters$.MODULE$.BufferHasAsJava(buffer).asJava();
    }

    @VisibleForTesting
    public Tuple2<Object, Object> getPhasesRangeToRestore(Release release, String phaseId, PhaseVersion phaseVersion) {
        Phase firstPhaseToRestore = release.getPhase(phaseId);
        int from = release.getPhases().indexOf(firstPhaseToRestore);
        Phase currentPhase = release.getCurrentPhase();
        int until = release.getPhases().indexOf(currentPhase);
        PhaseVersion phaseVersion2 = phaseVersion;
        PhaseVersion phaseVersion3 = PhaseVersion.ORIGINAL;
        if (!(phaseVersion2 != null ? !phaseVersion2.equals(phaseVersion3) : phaseVersion3 != null) && !currentPhase.isOriginal()) {
            until = from;
            Phase phase = firstPhaseToRestore;
            while (true) {
                String string = phase.getId();
                String string2 = currentPhase.getOriginId();
                if (!(string == null ? string2 != null : !string.equals(string2))) break;
                phase = release.getNextPhase(phase);
                ++until;
            }
        }
        return new Tuple2.mcII.sp(from, until);
    }

    public void checkIfPhaseCanBeRestartedFrom(Task task, Phase phase, PermissionChecker permissions) {
        block0: {
            if (task == null) break block0;
            Preconditions.checkState((task.isDone() || task.isActive() ? 1 : 0) != 0, (String)"You can not restart from a task that hasn't been started", null);
            int taskIndexToRestartFrom = ((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(phase.getTasks()).asScala().map((Function1 & Serializable)x$4 -> (String)CiHelper.TO_ID.apply(x$4))).indexOf((Object)task.getId());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), taskIndexToRestartFrom).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                Task taskToSkip = (Task)phase.getTasks().get(i);
                permissions.checkHasPermissionsToUpdateTask(taskToSkip);
            });
        }
    }

    private static final Seq originToRestoredTasks$1(Phase originalPhase, Phase restoredPhase) {
        Map phaselessTaskIdsToOriginalTasks = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(originalPhase.getAllTasks()).asScala().map((Function1 & Serializable)task -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.computePhaselessTaskId(task.getId())), task))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(restoredPhase.getAllTasks()).asScala().flatMap((Function1 & Serializable)restoredTask -> {
            String phaselessTaskId = MODULE$.computePhaselessTaskId(restoredTask.getId());
            return phaselessTaskIdsToOriginalTasks.get((Object)phaselessTaskId).map((Function1 & Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$1), restoredTask));
        })).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$getPhasesToRestore$4(Phase p) {
        return !p.isPhaseCopied() && p.isLatestCopy();
    }

    private PhaseRestart$() {
    }
}

