/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.support;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlplatform.support.api.SupportService;
import com.xebialabs.xlplatform.support.rest.SupportAcceleratorConfiguration;
import com.xebialabs.xlplatform.support.rest.SupportResource;
import com.xebialabs.xlrelease.api.utils.ResponseHelper;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.support.report.SystemInformationService;
import com.xebialabs.xlrelease.support.report.TaskManagerInformationService;
import com.xebialabs.xlrelease.support.tools.SupportUtilities;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.Variant;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Controller
@Path(value="/support")
@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001B\u0007\u000f\u0001]A\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!\u0011\u0005A!A!\u0002\u0013\u0019\u0005\"\u0002$\u0001\t\u00039\u0005\"\u00020\u0001\t\u0003z\u0006\"\u00027\u0001\t\u0003i\u0007bBA!\u0001\u0011\u0005\u00111\t\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\t\t\b\u0001C\u0001\u0003gBq!!#\u0001\t\u0003\tYI\u0001\nYYJ\u001cV\u000f\u001d9peR\u0014Vm]8ve\u000e,'BA\b\u0011\u0003\u001d\u0019X\u000f\u001d9peRT!!\u0005\n\u0002\u0013ad'/\u001a7fCN,'BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0001$\t\t\u00033}i\u0011A\u0007\u0006\u00037q\tAA]3ti*\u0011q\"\b\u0006\u0003=I\t!\u0002\u001f7qY\u0006$hm\u001c:n\u0013\t\u0001#DA\bTkB\u0004xN\u001d;SKN|WO]2f!\t\u0011s%D\u0001$\u0015\t!S%A\u0003tY\u001a$$NC\u0001'\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u0015$\u0005\u001daunZ4j]\u001e\fab];qa>\u0014HoU3sm&\u001cW\r\u0005\u0002,]5\tAF\u0003\u0002.9\u0005\u0019\u0011\r]5\n\u0005=b#AD*vaB|'\u000f^*feZL7-Z\u0001\u0011gV\u0004\bo\u001c:u+RLG.\u001b;jKN\u0004\"AM\u001b\u000e\u0003MR!\u0001\u000e\b\u0002\u000bQ|w\u000e\\:\n\u0005Y\u001a$\u0001E*vaB|'\u000f^+uS2LG/[3t\u0003a\u0019\u0018p\u001d;f[&sgm\u001c:nCRLwN\\*feZL7-\u001a\t\u0003sqj\u0011A\u000f\u0006\u0003w9\taA]3q_J$\u0018BA\u001f;\u0005a\u0019\u0016p\u001d;f[&sgm\u001c:nCRLwN\\*feZL7-Z\u0001 gV\u0004\bo\u001c:u\u0003\u000e\u001cW\r\\3sCR|'oQ8oM&<WO]1uS>t\u0007CA\rA\u0013\t\t%DA\u0010TkB\u0004xN\u001d;BG\u000e,G.\u001a:bi>\u00148i\u001c8gS\u001e,(/\u0019;j_:\fQ\u0004^1tW6\u000bg.Y4fe&sgm\u001c:nCRLwN\\*feZL7-\u001a\t\u0003s\u0011K!!\u0012\u001e\u0003;Q\u000b7o['b]\u0006<WM]%oM>\u0014X.\u0019;j_:\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtDC\u0002%K\u00172ke\n\u0005\u0002J\u00015\ta\u0002C\u0003*\r\u0001\u0007!\u0006C\u00031\r\u0001\u0007\u0011\u0007C\u00038\r\u0001\u0007\u0001\bC\u0003?\r\u0001\u0007q\bC\u0003C\r\u0001\u00071\t\u000b\u0002\u0007!B\u0011\u0011\u000bX\u0007\u0002%*\u00111\u000bV\u0001\u000bC:tw\u000e^1uS>t'BA+W\u0003\u001d1\u0017m\u0019;pefT!a\u0016-\u0002\u000b\t,\u0017M\\:\u000b\u0005eS\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003m\u000b1a\u001c:h\u0013\ti&KA\u0005BkR|w/\u001b:fI\u0006\u0011r-\u001a8fe\u0006$XmU;qa>\u0014HOW5q)\u0005\u0001\u0007CA1k\u001b\u0005\u0011'BA2e\u0003\u0011\u0019wN]3\u000b\u0005\u00154\u0017A\u0001:t\u0015\t9\u0007.\u0001\u0002xg*\t\u0011.A\u0003kCZ\f\u00070\u0003\u0002lE\nA!+Z:q_:\u001cX-\u0001\u000bhKR\u001c\u0016p\u001d;f[&sgm\u001c:nCRLwN\u001c\u000b\u0005A:\fI\u0001C\u0003p\u0011\u0001\u0007\u0001/A\u0004sKB|'\u000f^:\u0011\u0005EThB\u0001:y!\t\u0019h/D\u0001u\u0015\t)h#\u0001\u0004=e>|GO\u0010\u0006\u0002o\u0006)1oY1mC&\u0011\u0011P^\u0001\u0007!J,G-\u001a4\n\u0005md(AB*ue&twM\u0003\u0002zm\"2aN`A\u0003\u0003\u000f\u00012a`A\u0001\u001b\u0005!\u0017bAA\u0002I\nQ\u0011+^3ssB\u000b'/Y7\u0002\u000bY\fG.^3\"\u0003=Dq!a\u0003\t\u0001\u0004\ti!A\u0004sKF,Xm\u001d;\u0011\u0007\u0005\fy!C\u0002\u0002\u0012\t\u0014qAU3rk\u0016\u001cH\u000f\u000b\u0003\u0002\n\u0005U\u0001cA1\u0002\u0018%\u0019\u0011\u0011\u00042\u0003\u000f\r{g\u000e^3yi\":\u0001\"!\b\u0002\u0006\u0005\r\u0002cA@\u0002 %\u0019\u0011\u0011\u00053\u0003\u0011A\u0013x\u000eZ;dKNdC!!\n\u0002*\u0005\u0012\u0011qE\u0001\u0011CB\u0004H.[2bi&|gn\f6t_:\f#!a\u000b\u0002\u0013Q,\u0007\u0010^\u0018ii6d\u0007f\u0002\u0005\u00020\u0005\u0015\u0011Q\u0007\t\u0004\u007f\u0006E\u0012bAA\u001aI\n!\u0001+\u0019;iC\t\t9$A\n0gf\u001cH/Z7.S:4wN]7bi&|g\u000eK\u0002\t\u0003w\u00012a`A\u001f\u0013\r\ty\u0004\u001a\u0002\u0004\u000f\u0016#\u0016aC1dG\u0016\u0004Ho\u001d&t_:$B!!\u0012\u0002NA!\u0011qIA%\u001b\u00051\u0018bAA&m\n9!i\\8mK\u0006t\u0007bBA\u0006\u0013\u0001\u0007\u0011QB\u0001\u0010I><h\u000e\\8bIJ+G.Z1tKR\u0019\u0001-a\u0015\t\r\u0005U#\u00021\u0001q\u0003%\u0011X\r\\3bg\u0016LE\r\u000b\u0005\u0002T\u0005e\u0013QAA0!\ry\u00181L\u0005\u0004\u0003;\"'!\u0003)bi\"\u0004\u0016M]1nC\t\t)\u0006K\u0004\u000b\u0003;\t)!a\u0019-\u0005\u0005\u0015\u0014EAA4\u0003a\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c80_\u000e$X\r^\u0017tiJ,\u0017-\u001c\u0015\b\u0015\u0005=\u0012QAA6C\t\ti'\u0001\u00130e\u0016dW-Y:fg>Z(/\u001a7fCN,\u0017\n\u001a\u001e/UI+G.Z1tKnsv&\u0018\u0016~Q\rQ\u00111H\u0001\u000eI\u0016dW\r^3SK2,\u0017m]3\u0015\t\u0005U\u00141\u0010\t\u0005\u0003\u000f\n9(C\u0002\u0002zY\u0014A!\u00168ji\"1\u0011QK\u0006A\u0002AD\u0003\"a\u001f\u0002Z\u0005\u0015\u0011q\f\u0015\b\u0017\u0005=\u0012QAA6Q\rY\u00111\u0011\t\u0004\u007f\u0006\u0015\u0015bAADI\n1A)\u0012'F)\u0016\u000b\u0001#\u001e9eCR,G+Y:l'R\fG/^:\u0015\r\u0005U\u0014QRAK\u0011\u0019\ty\t\u0004a\u0001a\u00061A/Y:l\u0013\u0012D\u0003\"!$\u0002Z\u0005\u0015\u00111S\u0011\u0003\u0003\u001fCq!a&\r\u0001\u0004\tI*A\u0005oK^\u001cF/\u0019;vgB!\u00111TAS\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016AB:uCR,8OC\u0002\u0002$B\ta\u0001Z8nC&t\u0017\u0002BAT\u0003;\u0013!\u0002V1tWN#\u0018\r^;tQ\u001d\t)J`A\u0003\u0003W\u000b#!a&)\u000f1\ty#!\u0002\u00020\u0006\u0012\u0011\u0011W\u0001\u001c_Q\f7o[:0wR\f7o[%eu9RC+Y:l7z{SLK?)\u00071\t)\fE\u0002\u0000\u0003oK1!!/e\u0005\u0011\u0001vj\u0015+)\u000f\u0001\ty#!\u0002\u0002>\u0006\u0012\u0011qX\u0001\t_M,\b\u000f]8si\"\u001a\u0001!a1\u0011\t\u0005\u0015\u00171Z\u0007\u0003\u0003\u000fT1!!3Y\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003\u001b\f9M\u0001\u0006D_:$(o\u001c7mKJ\u0004")
public class XlrSupportResource
extends SupportResource
implements Logging {
    private final SupportUtilities supportUtilities;
    private final SystemInformationService systemInformationService;
    private final TaskManagerInformationService taskManagerInformationService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        XlrSupportResource xlrSupportResource = this;
        synchronized (xlrSupportResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Response generateSupportZip() {
        this.checkPermission(PlatformPermissions.ADMIN);
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.systemInformationService.writeSystemInformationReport()).recover((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ XlrSupportResource $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.logger().warn((Function0 & Serializable)() -> "Unable to generate system information report due to error", (Function0 & Serializable)() -> A1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2(java.lang.Throwable )}, serializedLambda);
            }
        });
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.systemInformationService.writeThreadDump()).recover((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ XlrSupportResource $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                this.$outer.logger().warn((Function0 & Serializable)() -> "Unable to generate thread dump due to error", (Function0 & Serializable)() -> A1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(), $anonfun$applyOrElse$4(java.lang.Throwable )}, serializedLambda);
            }
        });
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.taskManagerInformationService.writeTaskManagerReport()).recover((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ XlrSupportResource $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                this.$outer.logger().warn((Function0 & Serializable)() -> "Unable to generate task manager information report due to error", (Function0 & Serializable)() -> A1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Throwable x3) {
                Throwable throwable = x3;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(), $anonfun$applyOrElse$6(java.lang.Throwable )}, serializedLambda);
            }
        });
        return super.generateSupportZip();
    }

    @GET
    @Path(value="/system-information")
    @Produces(value={"application/json", "text/html"})
    public Response getSystemInformation(@QueryParam(value="reports") String reports, @Context Request request) {
        this.checkPermission(PlatformPermissions.ADMIN);
        Seq requestedReports = reports != null ? ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])reports.toLowerCase().split(","))) : (Seq)package$.MODULE$.Seq().empty();
        return this.acceptsJson(request) ? Response.ok(this.systemInformationService.generateJsonReport((Seq<String>)requestedReports), (String)"application/json").build() : Response.ok((Object)this.systemInformationService.generateHtmlReport((Seq<String>)requestedReports), (String)"text/html").build();
    }

    public boolean acceptsJson(Request request) {
        List variants = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.TEXT_HTML_TYPE}).build();
        Variant variant = request.selectVariant(variants);
        return variant != null && variant.getMediaType().isCompatible(MediaType.APPLICATION_JSON_TYPE);
    }

    @GET
    @Path(value="/releases/{releaseId:.*Release[^/]*}")
    @Produces(value={"application/octet-stream"})
    public Response downloadRelease(@PathParam(value="releaseId") String releaseId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        String content = this.supportUtilities.getReleaseContent(releaseId);
        StreamingOutput output = outputStream -> {
            WorkDirContext.initWorkdir((String)"download");
            try {
                outputStream.write(content.getBytes("UTF-8"));
            }
            finally {
                WorkDirContext.get().delete();
                WorkDirContext.clear();
            }
        };
        String fileName = Ids.getName((String)releaseId) + ".json";
        return ResponseHelper.streamFile(fileName, output, "application/json");
    }

    @DELETE
    @Path(value="/releases/{releaseId:.*Release[^/]*}")
    public void deleteRelease(@PathParam(value="releaseId") String releaseId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        Checks.checkTrue((boolean)Ids.isReleaseId((String)releaseId), (String)("ID " + releaseId + " is not a valid release ID"), (Object[])new Object[0]);
        this.supportUtilities.deleteRelease(releaseId);
    }

    @POST
    @Path(value="/tasks/{taskId:.*Task[^/]*}")
    public void updateTaskStatus(@PathParam(value="taskId") String taskId, @QueryParam(value="newStatus") TaskStatus newStatus) {
        this.checkPermission(PlatformPermissions.ADMIN);
        Checks.checkTrue((boolean)Ids.isTaskId((String)taskId), (String)("ID " + taskId + " is not a valid task ID"), (Object[])new Object[0]);
        Checks.checkTrue((Ids.releaseIdFrom((String)taskId) != null ? 1 : 0) != 0, (String)("ID " + taskId + " does not contain the release ID"), (Object[])new Object[0]);
        this.supportUtilities.updateTaskStatus(taskId, newStatus);
    }

    @Autowired
    public XlrSupportResource(SupportService supportService, SupportUtilities supportUtilities, SystemInformationService systemInformationService, SupportAcceleratorConfiguration supportAcceleratorConfiguration, TaskManagerInformationService taskManagerInformationService) {
        this.supportUtilities = supportUtilities;
        this.systemInformationService = systemInformationService;
        this.taskManagerInformationService = taskManagerInformationService;
        super(supportService, supportAcceleratorConfiguration);
        Logging.$init$((Logging)this);
    }
}

