/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.forms.CreatePersonalAccessTokenForm;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.UserTokenService;
import com.xebialabs.xlrelease.service.Users;
import com.xebialabs.xlrelease.user.User;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@Path(value="/tokens")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001\u0002\u0006\f\u0001YA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A1\u0007\u0001B\u0001B\u0003%A\u0007C\u00038\u0001\u0011\u0005\u0001\bC\u0003N\u0001\u0011\u0005a\nC\u0004\u0002 \u0001!\t!!\t\t\u000f\u0005m\u0003\u0001\"\u0001\u0002^!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0005BB'\u0001\t\u0013\t\tLA\tVg\u0016\u0014Hk\\6f]J+7o\\;sG\u0016T!\u0001D\u0007\u0002\u0011%tG/\u001a:oC2T!AD\b\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0011#\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003%M\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003Q\t1aY8n\u0007\u0001\u00192\u0001A\f\u001e!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fMB\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0006g24GG\u001b\u0006\u0002E\u0005AqM]5{u2,G-\u0003\u0002%?\t9Aj\\4hS:<\u0017a\u00039fe6L7o]5p]N\u0004\"a\n\u0016\u000e\u0003!R!!K\b\u0002\u0011M,7-\u001e:jifL!a\u000b\u0015\u0003#A+'/\\5tg&|gn\u00115fG.,'/\u0001\u0007u_.,gnU3sm&\u001cW\r\u0005\u0002/c5\tqF\u0003\u00021\u001f\u000591/\u001a:wS\u000e,\u0017B\u0001\u001a0\u0005A)6/\u001a:U_.,gnU3sm&\u001cW-A\u0003vg\u0016\u00148\u000f\u0005\u0002/k%\u0011ag\f\u0002\u0006+N,'o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\teZD(\u0010\t\u0003u\u0001i\u0011a\u0003\u0005\u0006K\u0011\u0001\rA\n\u0005\u0006Y\u0011\u0001\r!\f\u0005\u0006g\u0011\u0001\r\u0001\u000e\u0015\u0003\t}\u0002\"\u0001Q&\u000e\u0003\u0005S!AQ\"\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002E\u000b\u00069a-Y2u_JL(B\u0001$H\u0003\u0015\u0011W-\u00198t\u0015\tA\u0015*A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005Q\u0015aA8sO&\u0011A*\u0011\u0002\n\u0003V$xn^5sK\u0012\fQbZ3u+N,'\u000fV8lK:\u001cHcA(]iB\u0019\u0001+V,\u000e\u0003ES!AU*\u0002\r\u0011|W.Y5o\u0015\t!v)\u0001\u0003eCR\f\u0017B\u0001,R\u0005\u0011\u0001\u0016mZ3\u0011\u0005aSV\"A-\u000b\u0005I{\u0011BA.Z\u0005%)6/\u001a:U_.,g\u000eC\u0003^\u000b\u0001\u0007a,\u0001\u0003qC\u001e,\u0007C\u0001\r`\u0013\t\u0001\u0017DA\u0002J]RDC\u0001\u00182m[B\u00111M[\u0007\u0002I*\u0011QMZ\u0001\u0003eNT!a\u001a5\u0002\u0005]\u001c(\"A5\u0002\u000b)\fg/\u0019=\n\u0005-$'AC)vKJL\b+\u0019:b[\u0006)a/\u00197vK\u0006\nQ\f\u000b\u0003]_2\u0014\bCA2q\u0013\t\tHM\u0001\u0007EK\u001a\fW\u000f\u001c;WC2,X-I\u0001t\u0003\u0005\u0001\u0004\"B;\u0006\u0001\u0004q\u0016A\u0004:fgVdGo\u001d)feB\u000bw-\u001a\u0015\u0005i\ndw/I\u0001vQ\u0011!x\u000e\\=\"\u0003i\f1!\r\u00191Q\t)A\u0010E\u0002~\u0003\u000fi\u0011A \u0006\u0003\u0005~TA!!\u0001\u0002\u0004\u00059Q.\u001a;sS\u000e\u001c(bAA\u0003'\u0005A1m\u001c3bQ\u0006dW-C\u0002\u0002\ny\u0014Q\u0001V5nK\u0012Dc!BA\u0007Y\u0006M\u0001cA2\u0002\u0010%\u0019\u0011\u0011\u00033\u0003\tA\u000bG\u000f[\u0011\u0003\u0003+\taaL;tKJ\u001c\bfA\u0003\u0002\u001aA\u00191-a\u0007\n\u0007\u0005uAMA\u0002H\u000bR\u000bAcZ3u)>\\WM\\:G_J,6/\u001a:oC6,GcB(\u0002$\u0005\u001d\u0013Q\n\u0005\b\u0003K1\u0001\u0019AA\u0014\u0003!)8/\u001a:oC6,\u0007\u0003BA\u0015\u0003oqA!a\u000b\u00024A\u0019\u0011QF\r\u000e\u0005\u0005=\"bAA\u0019+\u00051AH]8pizJ1!!\u000e\u001a\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011HA\u001e\u0005\u0019\u0019FO]5oO*\u0019\u0011QG\r)\u000f\u0005\r\u0012q\b7\u0002FA\u00191-!\u0011\n\u0007\u0005\rCMA\u0005QCRD\u0007+\u0019:b[\u0006\u0012\u0011Q\u0005\u0005\u0006;\u001a\u0001\rA\u0018\u0015\u0006\u0003\u000f\u0012G.\u001c\u0015\u0006\u0003\u000fzGN\u001d\u0005\u0006k\u001a\u0001\rA\u0018\u0015\u0006\u0003\u001b\u0012Gn\u001e\u0015\u0006\u0003\u001bzG.\u001f\u0015\u0007\r\u00055A.!\u0016\"\u0005\u0005]\u0013!E\u0018vg\u0016\u00148oL>vg\u0016\u0014h.Y7f{\"\u001aa!!\u0007\u0002#\u001d,g.\u001a:bi\u0016,6/\u001a:U_.,g\u000eF\u0002X\u0003?Bq!!\u0019\b\u0001\u0004\t\u0019'A\u0007vg\u0016\u0014Hk\\6f]\u001a{'/\u001c\t\u0005\u0003K\ny'\u0004\u0002\u0002h)!\u0011\u0011NA6\u0003\u00151wN]7t\u0015\r\ti'D\u0001\u0003mFJA!!\u001d\u0002h\ti2I]3bi\u0016\u0004VM]:p]\u0006d\u0017iY2fgN$vn[3o\r>\u0014X\u000e\u000b\u0002\by\"2q!!\u0004m\u0003'A3aBA=!\r\u0019\u00171P\u0005\u0004\u0003{\"'\u0001\u0002)P'R\u000bq\u0002Z3mKR,Wk]3s)>\\WM\u001c\u000b\u0005\u0003\u0007\u000bI\tE\u0002\u0019\u0003\u000bK1!a\"\u001a\u0005\u0011)f.\u001b;\t\u000f\u0005-\u0005\u00021\u0001\u0002\u000e\u0006)1-[+jIB!\u0011qRAM\u001b\t\t\tJ\u0003\u0003\u0002\u0014\u0006U\u0015\u0001\u00027b]\u001eT!!a&\u0002\t)\fg/Y\u0005\u0005\u00037\u000b\tJA\u0004J]R,w-\u001a:)\u000f\u0005%\u0015q\b7\u0002 \u0006\u0012\u00111\u0012\u0015\u0003\u0011qDc\u0001CA\u0007Y\u0006\u0015\u0016EAAT\u00039ySo]3sg>Z8-[+jIvD3\u0001CAV!\r\u0019\u0017QV\u0005\u0004\u0003_#'A\u0002#F\u0019\u0016#V\tF\u0004P\u0003g\u000b),a.\t\u000f\u0005\u0015\u0012\u00021\u0001\u0002(!)Q,\u0003a\u0001=\")Q/\u0003a\u0001=\"\u001a\u0001!a/\u0011\t\u0005u\u00161Y\u0007\u0003\u0003\u007fS1!!1H\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003\u000b\fyL\u0001\u0006D_:$(o\u001c7mKJDc\u0001AAeY\u0006=\u0007cA2\u0002L&\u0019\u0011Q\u001a3\u0003\u0011A\u0013x\u000eZ;dKNd#!!5\"\u0005\u0005M\u0017\u0001E1qa2L7-\u0019;j_:|#n]8oQ\u0019\u0001\u0011q\u001b7\u0002^B\u00191-!7\n\u0007\u0005mGM\u0001\u0005D_:\u001cX/\\3tY\t\t\t\u000e\u000b\u0004\u0001\u0003\u001ba\u0017\u0011]\u0011\u0003\u0003G\fqa\f;pW\u0016t7\u000f")
public class UserTokenResource
implements Logging {
    private final PermissionChecker permissions;
    private final UserTokenService tokenService;
    private final Users users;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        UserTokenResource userTokenResource = this;
        synchronized (userTokenResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @GET
    @Path(value="/users")
    @Timed
    public Page<UserToken> getUserTokens(@DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage) {
        return this.getUserTokens(User.AUTHENTICATED_USER.getName(), page, resultsPerPage);
    }

    @GET
    @Path(value="/users/{username}")
    public Page<UserToken> getTokensForUsername(@PathParam(value="username") String username, @DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.getUserTokens(username, page, resultsPerPage);
    }

    @POST
    @Path(value="/users")
    @Timed
    public UserToken generateUserToken(CreatePersonalAccessTokenForm userTokenForm) {
        String username = User.AUTHENTICATED_USER.getName();
        Checks.checkArgument((boolean)this.users.userExistsInRepository(username), (String)"Personal access tokens are only supported for internal users", (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)userTokenForm.getTokenNote()), (String)"Note can't be blank", (Object[])new Object[0]);
        Checks.checkArgument((userTokenForm.getExpiryDate() == null || userTokenForm.getExpiryDate().getTime() > System.currentTimeMillis() ? 1 : 0) != 0, (String)"Expiry date is not valid", (Object[])new Object[0]);
        String tokenNote = userTokenForm.getTokenNote().trim();
        userTokenForm.setTokenNote(tokenNote);
        Checks.checkArgument((tokenNote.length() < 256 ? 1 : 0) != 0, (String)"Note must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!this.tokenService.userTokenExists(username, tokenNote) ? 1 : 0) != 0, (String)"Note has already been taken", (Object[])new Object[0]);
        return this.tokenService.createUserToken(username, tokenNote, userTokenForm.getExpiryDate());
    }

    @DELETE
    @Path(value="/users/{ciUid}")
    @Timed
    public void deleteUserToken(@PathParam(value="ciUid") Integer ciUid) {
        Option<UserToken> userToken = this.tokenService.findByCiUid(ciUid);
        Option<UserToken> option = userToken;
        if (option instanceof Some) {
            Some some = (Some)option;
            UserToken token = (UserToken)some.value();
            if (token.username().equalsIgnoreCase(User.AUTHENTICATED_USER.getName()) || this.permissions.isCurrentUserAdmin()) {
                this.tokenService.deleteUserToken(token);
                return;
            }
            throw new PermissionDeniedException("You don't have the permissions required to delete this personal access token.");
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Personal access token ciUid[" + ciUid + "] is not valid");
        }
        throw new MatchError(option);
    }

    private Page<UserToken> getUserTokens(String username, int page, int resultsPerPage) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage);
        return this.tokenService.find(username, (Pageable)pageable);
    }

    @Autowired
    public UserTokenResource(PermissionChecker permissions, UserTokenService tokenService, Users users) {
        this.permissions = permissions;
        this.tokenService = tokenService;
        this.users = users;
        Logging.$init$((Logging)this);
    }
}

