/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.converters;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.scheduler.ContainerTaskJob;
import com.xebialabs.xlrelease.scheduler.CreateReleaseTaskJob;
import com.xebialabs.xlrelease.scheduler.CustomScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.FacetCheckJob;
import com.xebialabs.xlrelease.scheduler.FailureHandlerJob;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobType;
import com.xebialabs.xlrelease.scheduler.NextCustomScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.NotificationTaskJob;
import com.xebialabs.xlrelease.scheduler.PreconditionJob;
import com.xebialabs.xlrelease.scheduler.ScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.script.TaskSoftReference;
import com.xebialabs.xlrelease.script.TaskSoftReferenceFactory;
import com.xebialabs.xlrelease.service.ReleaseService;
import java.io.Serializable;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u000554A!\u0002\u0004\u0001#!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004C\u0003 \u0001\u0011\u0005\u0001\u0005C\u0003%\u0001\u0011\u0005Q\u0005C\u0004R\u0001E\u0005I\u0011\u0001*\u0003!Q\u000b7o\u001b&pE\u000e{gN^3si\u0016\u0014(BA\u0004\t\u0003)\u0019wN\u001c<feR,'o\u001d\u0006\u0003\u0013)\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005-a\u0011!\u0003=me\u0016dW-Y:f\u0015\tia\"A\u0005yK\nL\u0017\r\\1cg*\tq\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\faB]3mK\u0006\u001cXmU3sm&\u001cW\r\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d\u0015\u000591/\u001a:wS\u000e,\u0017B\u0001\u0010\u001c\u00059\u0011V\r\\3bg\u0016\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtDCA\u0011$!\t\u0011\u0003!D\u0001\u0007\u0011\u0015A\"\u00011\u0001\u001a\u0003)1'o\\7K_\n\u0014vn\u001e\u000b\u0004MYZ\u0004GA\u0014.!\rA\u0013fK\u0007\u0002\u0011%\u0011!\u0006\u0003\u0002\b)\u0006\u001c8NS8c!\taS\u0006\u0004\u0001\u0005\u00139\u001a\u0011\u0011!A\u0001\u0006\u0003y#aA0%eE\u0011\u0001g\r\t\u0003'EJ!A\r\u000b\u0003\u000f9{G\u000f[5oOB\u00111\u0003N\u0005\u0003kQ\u00111!\u00118z\u0011\u001594\u00011\u00019\u0003\u0019QwN\u0019*poB\u0011\u0001&O\u0005\u0003u!\u0011aAS8c%><\bb\u0002\u001f\u0004!\u0003\u0005\r!P\u0001\u0012i\u0006\u001c8nU8giJ+g-\u001a:f]\u000e,\u0007cA\n?\u0001&\u0011q\b\u0006\u0002\u0007\u001fB$\u0018n\u001c81\u0005\u0005C\u0005c\u0001\"F\u000f6\t1I\u0003\u0002E\u0015\u000511o\u0019:jaRL!AR\"\u0003#Q\u000b7o[*pMR\u0014VMZ3sK:\u001cW\r\u0005\u0002-\u0011\u0012I\u0011jOA\u0001\u0002\u0003\u0015\tA\u0013\u0002\u0004?\u0012\n\u0014C\u0001\u0019L!\tau*D\u0001N\u0015\tq%\"\u0001\u0004e_6\f\u0017N\\\u0005\u0003!6\u0013A\u0001V1tW\u0006!bM]8n\u0015>\u0014'k\\<%I\u00164\u0017-\u001e7uII*\u0012a\u0015\u0016\u0003)f\u00032a\u0005 Va\t1\u0006\fE\u0002C\u000b^\u0003\"\u0001\f-\u0005\u0013%#\u0011\u0011!A\u0001\u0006\u0003Q5&\u0001.\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016!C;oG\",7m[3e\u0015\tyF#\u0001\u0006b]:|G/\u0019;j_:L!!\u0019/\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u000b\u0002\u0001GB\u0011Am[\u0007\u0002K*\u0011amZ\u0001\u000bgR,'/Z8usB,'B\u00015j\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u00016\u0002\u0007=\u0014x-\u0003\u0002mK\nI1i\\7q_:,g\u000e\u001e")
public class TaskJobConverter {
    private final ReleaseService releaseService;

    public TaskJob<?> fromJobRow(JobRow jobRow, Option<TaskSoftReference<? extends Task>> taskSoftReference) {
        TaskJob<Task> taskJob;
        TaskSoftReference taskRef = (TaskSoftReference)taskSoftReference.getOrElse((Function0 & Serializable)() -> TaskSoftReferenceFactory.taskRef($this.releaseService, jobRow.taskId(), jobRow.executionId(), jobRow.releaseUid()));
        JobType jobType = jobRow.jobType();
        if (((Object)((Object)JobType.PRECONDITION)).equals((Object)jobType)) {
            taskJob = new PreconditionJob(taskRef);
        } else if (((Object)((Object)JobType.FACET_CHECK)).equals((Object)jobType)) {
            taskJob = new FacetCheckJob(taskRef);
        } else if (((Object)((Object)JobType.FAILURE_HANDLER)).equals((Object)jobType)) {
            taskJob = new FailureHandlerJob(taskRef);
        } else if (((Object)((Object)JobType.CUSTOM_SCRIPT_TASK)).equals((Object)jobType)) {
            taskJob = new CustomScriptTaskJob(taskRef);
        } else if (((Object)((Object)JobType.NEXT_CUSTOM_SCRIPT_TASK)).equals((Object)jobType)) {
            taskJob = new NextCustomScriptTaskJob(taskRef, jobRow.scheduledStartTime());
        } else if (((Object)((Object)JobType.SCRIPT_TASK)).equals((Object)jobType)) {
            taskJob = new ScriptTaskJob(taskRef);
        } else if (((Object)((Object)JobType.CREATE_RELEASE_TASK)).equals((Object)jobType)) {
            taskJob = new CreateReleaseTaskJob(taskRef);
        } else if (((Object)((Object)JobType.NOTIFICATION_TASK)).equals((Object)jobType)) {
            taskJob = new NotificationTaskJob(taskRef);
        } else if (((Object)((Object)JobType.CONTAINER_TASK)).equals((Object)jobType)) {
            taskJob = new ContainerTaskJob(taskRef);
        } else {
            if (((Object)((Object)JobType.FAIL_JOB)).equals((Object)jobType) ? true : ((Object)((Object)JobType.STOP_WORKER_THREAD)).equals((Object)jobType)) {
                throw new IllegalStateException("'" + jobRow.jobType() + "' is not a valid job type for TaskJob");
            }
            throw new MatchError((Object)jobType);
        }
        PreconditionJob job = taskJob;
        job.id_$eq(jobRow.id());
        job.node_$eq(jobRow.node());
        job.runnerId_$eq(jobRow.runnerId());
        job.status_$eq(jobRow.status());
        job.version_$eq(jobRow.version());
        job.submitTime_$eq(jobRow.submitTime());
        job.reservationTime_$eq(jobRow.reservationTime());
        job.startTime_$eq(jobRow.startTime());
        return job;
    }

    public Option<TaskSoftReference<? extends Task>> fromJobRow$default$2() {
        return None$.MODULE$;
    }

    public TaskJobConverter(ReleaseService releaseService) {
        this.releaseService = releaseService;
    }
}

