/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.AttachmentService;
import com.xebialabs.xlrelease.utils.FileContentValidation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.activation.FileTypeMap;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UploadService {
    private static final Logger logger = LoggerFactory.getLogger(UploadService.class);
    private final AttachmentService attachmentService;
    private final ReleaseRepository releaseRepository;
    private final AttachmentRepository attachmentRepository;
    private final ReleaseActorService releaseActorService;

    @Autowired
    public UploadService(AttachmentService attachmentService, ReleaseRepository releaseRepository, AttachmentRepository attachmentRepository, ReleaseActorService releaseActorService) {
        this.attachmentService = attachmentService;
        this.releaseRepository = releaseRepository;
        this.attachmentRepository = attachmentRepository;
        this.releaseActorService = releaseActorService;
    }

    @Timed
    public List<Attachment> addAttachment(String ciId, FileItemIterator fileItems) throws IOException, FileUploadException {
        ArrayList<Attachment> attachmentList = new ArrayList<Attachment>();
        while (fileItems.hasNext()) {
            FileItemStream item = fileItems.next();
            if (item.isFormField()) continue;
            String filename = item.getName();
            String contentType = item.getContentType();
            InputStream stream = item.openStream();
            try {
                InputStream validatedInputStream = (InputStream)FileContentValidation.apply(filename, stream).get();
                try {
                    logger.debug("Attaching {} to {}", (Object)filename, (Object)ciId);
                    attachmentList.add(this.addAttachment(ciId, filename, contentType, validatedInputStream));
                }
                finally {
                    if (validatedInputStream == null) continue;
                    validatedInputStream.close();
                }
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return attachmentList;
    }

    @Timed
    public Attachment addAttachment(String ciId, String fileName, byte[] fileByteArray) {
        return this.addAttachment(ciId, fileName, FileTypeMap.getDefaultFileTypeMap().getContentType(fileName), new ByteArrayInputStream(fileByteArray));
    }

    @Timed
    public Attachment addAttachment(String ciId, String fileName, String contentType, InputStream inputStream) {
        logger.debug("Attaching {} to {}", (Object)fileName, (Object)ciId);
        Release release = this.releaseRepository.findById(Ids.releaseIdFrom((String)ciId));
        Task task = null;
        if (!Ids.isReleaseId((String)ciId)) {
            task = release.getTask(ciId);
        }
        Attachment attachment = this.attachmentService.attachToRelease(release, fileName, contentType, inputStream);
        if (task != null) {
            task.getAttachments().add(attachment);
        }
        this.attachmentRepository.insertAttachment(release.getId(), attachment);
        if (null != task) {
            return this.releaseActorService.createAttachmentOnTask(task.getId(), attachment);
        }
        return this.releaseActorService.createAttachmentOnRelease(release.getId(), attachment);
    }
}

