/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade;

import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.UpgradeStrategy;
import com.xebialabs.deployit.upgrade.Upgrader;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.config.XlrConfig;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLReleaseUpgrader
extends Upgrader {
    private static final Logger logger = LoggerFactory.getLogger(XLReleaseUpgrader.class);

    public XLReleaseUpgrader(UpgradeStrategy upgradeStrategy, boolean forceUpgrades, RepositoryVersionService repositoryVersionService) {
        super(upgradeStrategy, forceUpgrades, repositoryVersionService);
        this.addComponent("deployit");
    }

    protected void updateVersion(Version version, List<Upgrade> upgrades) {
        XlrConfig xlrConfig = XlrConfig.getInstance();
        List<Object> upgradesToExecute = upgrades;
        if (xlrConfig.getXl().hasPath("upgrader.skip")) {
            List upgradesToSkip = xlrConfig.getXl().getStringList("upgrader.skip");
            upgradesToExecute = upgrades.stream().filter(upgrade -> {
                String upgradeName = upgrade.getClass().getSimpleName();
                if (upgradesToSkip != null && upgradesToSkip.contains(upgradeName)) {
                    logger.warn("Skipping upgrade [{}]", (Object)upgradeName);
                    return false;
                }
                return true;
            }).collect(Collectors.toList());
        }
        super.updateVersion(version, upgradesToExecute);
    }
}

