/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.IdType;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils;
import com.xebialabs.xlrelease.views.BaseConfigurationItemView;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;

abstract class BaseConfigurationItemViewConverter {
    protected final ConfigurationRepository configurationRepository;

    @Autowired
    public BaseConfigurationItemViewConverter(ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
    }

    void fillItem(ConfigurationItem item, BaseConfigurationItemView view) {
        this.getPropertyDescriptors(item.getType()).forEach(pd -> {
            Object propertyValue;
            block8: {
                block9: {
                    block10: {
                        propertyValue = view.getProperty(pd.getName());
                        if (propertyValue == null) break block8;
                        if (pd.getKind() != PropertyKind.CI) break block9;
                        if (!(propertyValue instanceof String)) break block10;
                        String internalId = (String)propertyValue;
                        if (!internalId.contains("Configuration/Custom")) {
                            internalId = IdType.CONFIGURATION.convertToInternalId((String)propertyValue);
                        }
                        propertyValue = this.configurationRepository.read(internalId);
                        Type referencedType = ((Configuration)propertyValue).getType();
                        Preconditions.checkArgument((boolean)referencedType.getDescriptor().isAssignableTo(pd.getReferencedType()), (Object)("Type of CI must be " + pd.getReferencedType().getName() + " got " + referencedType.getName()));
                        break block8;
                    }
                    if (!(propertyValue instanceof Map)) break block8;
                    propertyValue = this.configurationItemFromMap((Map)propertyValue);
                    break block8;
                }
                if (pd.getKind() == PropertyKind.SET_OF_STRING) {
                    propertyValue = Sets.newHashSet((Iterable)((Collection)propertyValue));
                } else if (pd.getKind() == PropertyKind.STRING) {
                    if (pd.isPassword()) {
                        propertyValue = PasswordEncrypter.getInstance().ensureDecrypted(propertyValue.toString());
                    }
                } else if (pd.getKind() == PropertyKind.SET_OF_CI) {
                    List listOfCiRepresentations = (List)propertyValue;
                    propertyValue = new HashSet();
                    for (Object ciRepresentation : listOfCiRepresentations) {
                        if (!(ciRepresentation instanceof Map)) continue;
                        ConfigurationItem ci = this.configurationItemFromMap((Map)ciRepresentation);
                        ((Collection)propertyValue).add(ci);
                    }
                }
            }
            item.setProperty(pd.getName(), propertyValue);
        });
        item.setId(view.getId());
    }

    private ConfigurationItem configurationItemFromMap(Map map) {
        ConfigurationItem item = null;
        String id = (String)map.get("id");
        String typeName = (String)map.get("type");
        String title = (String)map.get("title");
        if (null != typeName) {
            Type type = Type.valueOf((String)typeName);
            Descriptor typeDescriptor = type.getDescriptor();
            item = typeDescriptor.newInstance(id);
            BaseConfigurationItemView view = new BaseConfigurationItemView(){
                private String id;

                public String getId() {
                    return this.id;
                }

                public void setId(String id) {
                    this.id = id;
                }
            };
            view.setId(id);
            view.setType(typeName);
            view.setTitle(title);
            view.setProperties(map);
            this.fillItem(item, view);
        }
        return item;
    }

    void fillView(BaseConfigurationItemView view, ConfigurationItem instance) {
        view.setId(instance.getId());
        view.setType(instance.getType().toString());
        view.setTitle((String)instance.getProperty("title"));
        Map properties = view.getProperties();
        this.getPropertyDescriptors(instance.getType()).forEach(pd -> {
            String propertyName = pd.getName();
            if (pd.getKind() == PropertyKind.CI) {
                Configuration configuration = (Configuration)instance.getProperty(propertyName);
                properties.put(propertyName, configuration != null ? IdType.CONFIGURATION.convertToViewId(configuration.getId()) : null);
            } else if (pd.isPassword() && instance.getProperty(propertyName) != null) {
                properties.put(propertyName, PasswordVerificationUtils.PASSWORD_MASK());
            } else {
                properties.put(propertyName, instance.getProperty(propertyName));
            }
        });
    }

    <T extends ConfigurationItem> T newInstance(BaseConfigurationItemView view) {
        Descriptor descriptor = view.type().getDescriptor();
        return (T)descriptor.newInstance(view.getId());
    }

    Stream<PropertyDescriptor> getPropertyDescriptors(Type type) {
        return type.getDescriptor().getPropertyDescriptors().stream().filter(pd -> !pd.isHidden());
    }
}

