/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.views.TeamMemberView;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TeamMemberViewConverter {
    private final UserInfoResolver userInfoResolver;
    private final RoleService roleService;

    @Autowired
    public TeamMemberViewConverter(UserInfoResolver userInfoResolver, RoleService roleService) {
        this.userInfoResolver = userInfoResolver;
        this.roleService = roleService;
    }

    public TeamMemberView toView(String name, TeamMemberView.MemberType type) {
        List roles;
        TeamMemberView teamMemberView = new TeamMemberView();
        teamMemberView.setName(name);
        teamMemberView.setType(type);
        if (type == TeamMemberView.MemberType.PRINCIPAL) {
            teamMemberView.setFullName(this.userInfoResolver.getFullNameOf(name));
        } else if (type == TeamMemberView.MemberType.ROLE && !(roles = this.roleService.getRoles(name, null, null)).isEmpty()) {
            teamMemberView.setRoleId(((Role)roles.get(0)).getId());
        }
        return teamMemberView;
    }
}

