package com.xebialabs.xlrelease.db

import com.xebialabs.xlrelease.XLReleaseServerLaunchOptions
import grizzled.slf4j.Logging
import liquibase.snapshot.SnapshotGeneratorFactory
import org.springframework.beans.factory.annotation.Autowired

import javax.sql.DataSource

class XLReleaseDbInitializer(val dbConfig: String, val dataSource: DataSource) extends LiquibaseSupport with Logging {

  @Autowired
  var launchOptions: XLReleaseServerLaunchOptions = _

  def init(): Unit = {
    doWithLiquibase(dbConfig) { liquibase =>
      if (launchOptions != null && launchOptions.isReleaseDbLocks) {
        logger.info("Releasing liquibase  database locks")
        liquibase.forceReleaseLocks()
      }

      liquibase.update("")
    }
  }

  def isInitialized: Boolean = {
    doWithLiquibase(dbConfig) { liquibase =>
      SnapshotGeneratorFactory.getInstance().hasDatabaseChangeLogTable(liquibase.getDatabase)
    }
  }

}
