package com.xebialabs.xlrelease.features

import com.xebialabs.xlrelease.features.distributed.BaseDistributedFeature
import com.xebialabs.xlrelease.features.settings.ScriptBackpressureFeatureSettings

import scala.concurrent.duration.{DurationInt, FiniteDuration}


trait ScriptBackpressureFeature {
  def enabled: Boolean

  def responseThreshold: FiniteDuration

  def sleepDuration: FiniteDuration

  def responseThresholdRatio: Int

  def warningThreshold: FiniteDuration
}

object ScriptBackpressureFeature extends BaseDistributedFeature[ScriptBackpressureFeatureSettings] with ScriptBackpressureFeature {

  override def enabled: Boolean = featureSettings.enabled

  override def responseThreshold: FiniteDuration = featureSettings.responseThresholdMs.millis

  override def sleepDuration: FiniteDuration = featureSettings.sleepDurationMs.millis

  override def responseThresholdRatio: Int = featureSettings.responseThresholdRatio

  override def warningThreshold: FiniteDuration = featureSettings.warningThresholdMs.millis
}