package com.xebialabs.xlrelease.scheduler

import com.xebialabs.xlrelease.actors.ReleaseActorService
import com.xebialabs.xlrelease.features.ScriptBackpressureFeature
import org.springframework.stereotype.Component

@Component
class DefaultScriptBackpressure(releaseActorService: ReleaseActorService, scriptBackpressureSettings: ScriptBackpressureFeature) extends ScriptBackpressure {
  override def backpressureFn(job: Job): Unit = {
    if (scriptBackpressureSettings.enabled) {
      job match {
        case job: TaskJob[_] => releaseActorService.backpressureWait(job.taskId)
        case _ => ()
      }
    }
  }
}
